/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.hooks;

import de.jabc.cinco.meta.runtime.hook.CincoPostMoveHook;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.gui.gui.DataContext;
import info.scce.dime.gui.gui.Variable;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class Variable_PostMove extends CincoPostMoveHook<Variable> {
  private final int OFFSET = 30;
  
  @Override
  public void postMove(final Variable node, final ModelElementContainer arg1, final ModelElementContainer arg2, final int arg3, final int arg4, final int arg5, final int arg6) {
    DataContext _container = node.getContainer();
    if ((_container instanceof DataContext)) {
      DataContext _container_1 = node.getContainer();
      DataContext dataContext = ((DataContext) _container_1);
      int maxHeight = this.maxHeight(dataContext);
      dataContext.setHeight((maxHeight + this.OFFSET));
    }
  }
  
  public int maxHeight(final DataContext context) {
    int maxLowerBound = 50;
    EList<? extends Node> _nodes = context.getNodes();
    for (final Node node : _nodes) {
      int _y = node.getY();
      int _height = node.getHeight();
      int _plus = (_y + _height);
      boolean _greaterThan = (_plus > maxLowerBound);
      if (_greaterThan) {
        int _y_1 = node.getY();
        int _height_1 = node.getHeight();
        int _plus_1 = (_y_1 + _height_1);
        maxLowerBound = _plus_1;
      }
    }
    return maxLowerBound;
  }
}
