/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.hooks;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.runtime.action.CincoPostAttributeChangeHook;
import info.scce.dime.gui.gui.ProgressBar;
import org.eclipse.emf.ecore.EStructuralFeature;

@SuppressWarnings("all")
public class ShowPercentValueChange extends CincoPostAttributeChangeHook<ProgressBar> {
  @Override
  public boolean canHandleChange(final ProgressBar bar, final EStructuralFeature arg1) {
    return true;
  }
  
  @Override
  public void handleChange(final ProgressBar bar, final EStructuralFeature e) {
    String _name = e.getName();
    boolean _equals = Objects.equal(_name, "percent");
    if (_equals) {
      boolean _isPercent = bar.isPercent();
      if (_isPercent) {
        bar.setValue("30%");
      } else {
        boolean _isPercent_1 = bar.isPercent();
        boolean _not = (!_isPercent_1);
        if (_not) {
          bar.setValue("30/100");
        }
      }
    }
  }
}
