/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.hooks;

import com.google.common.collect.Iterables;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.data.data.Type;
import info.scce.dime.gui.gui.Branch;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.ComplexInputPort;
import info.scce.dime.gui.gui.ComplexOutputPort;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.EventListener;
import info.scce.dime.gui.gui.GUIPlugin;
import info.scce.dime.gui.gui.InputGeneric;
import info.scce.dime.gui.gui.OutputGeneric;
import info.scce.dime.gui.gui.SIB;
import info.scce.dime.gui.gui.SetGenericType;
import java.util.Arrays;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * The create for edge hook is used to avoid the
 * creation of iteration edges from a non list variable or attribute
 * @author zweihoff
 */
@SuppressWarnings("all")
public class SetGenericTypeCreate extends DIMEPostCreateHook<SetGenericType> {
  /**
   * Avoids the creation of iteration edges from a non list variable or attribute
   */
  @Override
  public void postCreate(final SetGenericType object) {
    final SetGenericType cSetGenericType = object;
    final Node node = cSetGenericType.getSourceElement();
    final Type type = this.dataType(node);
    final String typeParameter = this.getTypeParameter(cSetGenericType.getTargetElement());
    final ModelElementContainer cSIB = cSetGenericType.getTargetElement().getContainer();
    if ((cSIB instanceof Branch)) {
      SIB _container = ((Branch)cSIB).getContainer();
      if ((_container instanceof GUIPlugin)) {
        SIB _container_1 = ((Branch)cSIB).getContainer();
        this.convertGenericPorts(((GUIPlugin) _container_1), typeParameter, type);
      }
    }
    if ((cSIB instanceof EventListener)) {
      SIB _container_2 = ((EventListener)cSIB).getContainer();
      if ((_container_2 instanceof GUIPlugin)) {
        SIB _container_3 = ((EventListener)cSIB).getContainer();
        this.convertGenericPorts(((GUIPlugin) _container_3), typeParameter, type);
      }
    }
    if ((cSIB instanceof GUIPlugin)) {
      this.convertGenericPorts(((GUIPlugin)cSIB), typeParameter, type);
    }
  }
  
  protected String _getTypeParameter(final InputGeneric node) {
    return node.getTypeParameter();
  }
  
  protected String _getTypeParameter(final OutputGeneric node) {
    return node.getTypeParameter();
  }
  
  public void convertGenericPorts(final GUIPlugin sib, final String typeParameter, final Type t) {
    final Function1<InputGeneric, Boolean> _function = new Function1<InputGeneric, Boolean>() {
      @Override
      public Boolean apply(final InputGeneric n) {
        return Boolean.valueOf(n.getTypeParameter().equals(typeParameter));
      }
    };
    final Consumer<InputGeneric> _function_1 = new Consumer<InputGeneric>() {
      @Override
      public void accept(final InputGeneric n) {
        SetGenericTypeCreate.this.convert(n, t, sib);
      }
    };
    IterableExtensions.<InputGeneric>filter(Iterables.<InputGeneric>filter(sib.getIOs(), InputGeneric.class), _function).forEach(_function_1);
    final Consumer<EventListener> _function_2 = new Consumer<EventListener>() {
      @Override
      public void accept(final EventListener listener) {
        final Function1<InputGeneric, Boolean> _function = new Function1<InputGeneric, Boolean>() {
          @Override
          public Boolean apply(final InputGeneric n) {
            return Boolean.valueOf(n.getTypeParameter().equals(typeParameter));
          }
        };
        final Consumer<InputGeneric> _function_1 = new Consumer<InputGeneric>() {
          @Override
          public void accept(final InputGeneric n) {
            SetGenericTypeCreate.this.convert(n, t, listener);
          }
        };
        IterableExtensions.<InputGeneric>filter(Iterables.<InputGeneric>filter(listener.getIOs(), InputGeneric.class), _function).forEach(_function_1);
      }
    };
    Iterables.<EventListener>filter(sib.getAbstractBranchs(), EventListener.class).forEach(_function_2);
    final Consumer<Branch> _function_3 = new Consumer<Branch>() {
      @Override
      public void accept(final Branch branch) {
        final Function1<OutputGeneric, Boolean> _function = new Function1<OutputGeneric, Boolean>() {
          @Override
          public Boolean apply(final OutputGeneric n) {
            return Boolean.valueOf(n.getTypeParameter().equals(typeParameter));
          }
        };
        final Consumer<OutputGeneric> _function_1 = new Consumer<OutputGeneric>() {
          @Override
          public void accept(final OutputGeneric n) {
            SetGenericTypeCreate.this.convert(n, t, branch);
          }
        };
        IterableExtensions.<OutputGeneric>filter(Iterables.<OutputGeneric>filter(branch.getOutputPorts(), OutputGeneric.class), _function).forEach(_function_1);
      }
    };
    Iterables.<Branch>filter(sib.getAbstractBranchs(), Branch.class).forEach(_function_3);
  }
  
  public void convert(final InputGeneric generic, final Type type, final GUIPlugin gp) {
    final ComplexInputPort port = gp.newComplexInputPort(type, generic.getX(), generic.getY());
    port.setName(generic.getName());
    port.setIsList(generic.isIsList());
    generic.delete();
  }
  
  public void convert(final InputGeneric generic, final Type type, final EventListener gp) {
    final ComplexInputPort port = gp.newComplexInputPort(type, generic.getX(), generic.getY());
    port.setName(generic.getName());
    port.setIsList(generic.isIsList());
    generic.delete();
  }
  
  public void convert(final OutputGeneric generic, final Type type, final Branch cb) {
    final ComplexOutputPort port = cb.newComplexOutputPort(type, generic.getX(), generic.getY());
    port.setName(generic.getName());
    port.setIsList(generic.isIsList());
    generic.delete();
  }
  
  protected Type _dataType(final ComplexVariable node) {
    return ((ComplexVariable) node).getDataType();
  }
  
  protected Type _dataType(final ComplexAttribute node) {
    return ((ComplexAttribute) node).getAttribute().getDataType();
  }
  
  public String getTypeParameter(final Node node) {
    if (node instanceof InputGeneric) {
      return _getTypeParameter((InputGeneric)node);
    } else if (node instanceof OutputGeneric) {
      return _getTypeParameter((OutputGeneric)node);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(node).toString());
    }
  }
  
  public Type dataType(final Node node) {
    if (node instanceof ComplexVariable) {
      return _dataType((ComplexVariable)node);
    } else if (node instanceof ComplexAttribute) {
      return _dataType((ComplexAttribute)node);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(node).toString());
    }
  }
}
