/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.hooks;

import de.jabc.cinco.meta.runtime.hook.CincoPostDeleteHook;
import graphmodel.Node;
import info.scce.dime.gui.gui.Event;
import info.scce.dime.gui.gui.ListenerContext;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class Event_PostDelete extends CincoPostDeleteHook<Event> {
  private final int OFFSET = 30;
  
  @Override
  public Runnable getPostDeleteFunction(final Event node) {
    Runnable _switchResult = null;
    ListenerContext _container = node.getContainer();
    final ListenerContext it = _container;
    boolean _matched = false;
    if (it instanceof ListenerContext) {
      _matched=true;
      final Runnable _function = new Runnable() {
        @Override
        public void run() {
          Event_PostDelete.this.layout(it);
        }
      };
      _switchResult = _function;
    }
    if (!_matched) {
      final Runnable _function = new Runnable() {
        @Override
        public void run() {
        }
      };
      _switchResult = _function;
    }
    return _switchResult;
  }
  
  public void layout(final ListenerContext node) {
    int maxHeight = this.maxHeight(node);
    node.setHeight((maxHeight + this.OFFSET));
  }
  
  public int maxHeight(final ListenerContext context) {
    int maxLowerBound = 50;
    EList<? extends Node> _nodes = context.getNodes();
    for (final Node node : _nodes) {
      int _y = node.getY();
      int _height = node.getHeight();
      int _plus = (_y + _height);
      boolean _greaterThan = (_plus > maxLowerBound);
      if (_greaterThan) {
        int _y_1 = node.getY();
        int _height_1 = node.getHeight();
        int _plus_1 = (_y_1 + _height_1);
        maxLowerBound = _plus_1;
      }
    }
    return maxLowerBound;
  }
}
