/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.hooks;

import com.google.common.collect.Iterables;
import info.scce.dime.gui.gui.ComplexOutputPort;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.Event;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.OutputPort;
import info.scce.dime.gui.gui.Placeholder;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.GUIBranch;
import info.scce.dime.gui.hooks.GUISIBHook;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * The GUI SIB hook is used create the corresponding ports and branches
 * for the new GUI SIB
 * @author zweihoff
 */
@SuppressWarnings("all")
public class DispatchedGUISIBHook extends GUISIBHook {
  /**
   * Creates the corresponding GUI SIB input ports for every input variable
   * of the referenced GUI model.
   * For every button and branch of embedded SIBs, a branch with the corresponding ports is added.
   */
  @Override
  public void postCreate(final GUISIB sib) {
    final GUI parentGUI = sib.getGui();
    final Set<GUI> allSubs = this._gUIExtension.getSubGUIs(parentGUI);
    final HashSet<Variable> dispatchableInputs = new HashSet<Variable>();
    final Consumer<Variable> _function = new Consumer<Variable>() {
      @Override
      public void accept(final Variable n) {
        dispatchableInputs.add(n);
      }
    };
    this._gUIExtension.inputVariables(parentGUI).forEach(_function);
    final List<GUIBranch> dispatchableBranches = this._gUIExtension.dispatchedOutputs(parentGUI);
    final HashMap<String, List<OutputPort>> dispatchableEvents = new HashMap<String, List<OutputPort>>();
    final Consumer<Event> _function_1 = new Consumer<Event>() {
      @Override
      public void accept(final Event e) {
        dispatchableEvents.put(e.getName(), e.getOutputPorts());
      }
    };
    this._gUIExtension.events(parentGUI).forEach(_function_1);
    final HashSet<String> dispatchablePlaceholders = new HashSet<String>();
    final Consumer<Placeholder> _function_2 = new Consumer<Placeholder>() {
      @Override
      public void accept(final Placeholder n) {
        dispatchablePlaceholders.add(n.getName());
      }
    };
    this._gUIExtension.<Placeholder>find(parentGUI, Placeholder.class).forEach(_function_2);
    final Consumer<GUI> _function_3 = new Consumer<GUI>() {
      @Override
      public void accept(final GUI n) {
        final Consumer<Placeholder> _function = new Consumer<Placeholder>() {
          @Override
          public void accept(final Placeholder pl) {
            dispatchablePlaceholders.add(pl.getName());
          }
        };
        DispatchedGUISIBHook.this._gUIExtension.<Placeholder>find(n, Placeholder.class).forEach(_function);
      }
    };
    allSubs.forEach(_function_3);
    for (final GUI subGUI : allSubs) {
      {
        Iterable<Variable> _inputVariables = this._gUIExtension.inputVariables(subGUI);
        for (final Variable input : _inputVariables) {
          {
            final Function1<Variable, Boolean> _function_4 = new Function1<Variable, Boolean>() {
              @Override
              public Boolean apply(final Variable n) {
                return Boolean.valueOf(n.getName().equals(input.getName()));
              }
            };
            final Variable alreadyKnownInput = IterableExtensions.<Variable>findFirst(dispatchableInputs, _function_4);
            boolean _notEquals = this._gUIExtension.operator_notEquals(alreadyKnownInput, null);
            if (_notEquals) {
              if ((alreadyKnownInput instanceof ComplexVariable)) {
                boolean _contains = this._dataExtension.getSuperTypes(((ComplexVariable)alreadyKnownInput).getDataType()).contains(((ComplexVariable) input).getDataType());
                if (_contains) {
                  dispatchableInputs.remove(alreadyKnownInput);
                  dispatchableInputs.add(input);
                }
              }
            } else {
              dispatchableInputs.add(input);
            }
          }
        }
        Iterable<Event> _events = this._gUIExtension.events(subGUI);
        for (final Event event : _events) {
          {
            final String name = event.getName();
            boolean _containsKey = dispatchableEvents.containsKey(name);
            boolean _not = (!_containsKey);
            if (_not) {
              dispatchableEvents.put(name, event.getOutputPorts());
            } else {
              final LinkedList<OutputPort> alreadyKnownEventPorts = new LinkedList<OutputPort>();
              alreadyKnownEventPorts.addAll(dispatchableEvents.get(name));
              EList<OutputPort> _outputPorts = event.getOutputPorts();
              for (final OutputPort port : _outputPorts) {
                {
                  final LinkedList<OutputPort> alreadyKnownPort = new LinkedList<OutputPort>();
                  final Function1<OutputPort, Boolean> _function_4 = new Function1<OutputPort, Boolean>() {
                    @Override
                    public Boolean apply(final OutputPort n) {
                      return Boolean.valueOf(n.getName().equals(port.getName()));
                    }
                  };
                  Iterables.<OutputPort>addAll(alreadyKnownPort, IterableExtensions.<OutputPort>filter(alreadyKnownEventPorts, _function_4));
                  boolean _isEmpty = alreadyKnownPort.isEmpty();
                  boolean _not_1 = (!_isEmpty);
                  if (_not_1) {
                    final OutputPort knownPort = alreadyKnownPort.get(0);
                    if ((knownPort instanceof ComplexOutputPort)) {
                      boolean _contains = this._dataExtension.getSuperTypes(((ComplexOutputPort)knownPort).getDataType()).contains(((ComplexOutputPort) port).getDataType());
                      if (_contains) {
                        alreadyKnownEventPorts.remove(knownPort);
                        alreadyKnownEventPorts.add(port);
                      }
                    }
                  } else {
                    alreadyKnownEventPorts.add(port);
                  }
                }
              }
              dispatchableEvents.put(name, alreadyKnownEventPorts);
            }
          }
        }
      }
    }
    this.init(sib, sib.getGui().getTitle(), dispatchableInputs.size());
    final Consumer<Variable> _function_4 = new Consumer<Variable>() {
      @Override
      public void accept(final Variable it) {
        DispatchedGUISIBHook.this.addGUIInput(it);
      }
    };
    dispatchableInputs.forEach(_function_4);
    final Consumer<GUIBranch> _function_5 = new Consumer<GUIBranch>() {
      @Override
      public void accept(final GUIBranch it) {
        DispatchedGUISIBHook.this.addBranch(it);
      }
    };
    dispatchableBranches.forEach(_function_5);
    final Consumer<Map.Entry<String, List<OutputPort>>> _function_6 = new Consumer<Map.Entry<String, List<OutputPort>>>() {
      @Override
      public void accept(final Map.Entry<String, List<OutputPort>> e) {
        DispatchedGUISIBHook.this.addEventBranches(e.getKey(), e.getValue());
      }
    };
    dispatchableEvents.entrySet().forEach(_function_6);
    final Consumer<String> _function_7 = new Consumer<String>() {
      @Override
      public void accept(final String n) {
        DispatchedGUISIBHook.this.addArgument(((GUISIB) DispatchedGUISIBHook.this.csib), n);
      }
    };
    dispatchablePlaceholders.forEach(_function_7);
    this.finish();
  }
  
  public boolean notIn(final String string, final List<String> strings) {
    boolean _contains = strings.contains(string);
    return (!_contains);
  }
  
  public boolean isIn(final String string, final List<String> strings) {
    boolean _notIn = this.notIn(string, strings);
    return (!_notIn);
  }
}
