/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.hooks;

import com.google.common.collect.Iterables;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.gui.actions.AddPrimitivePort;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.ComplexInputPort;
import info.scce.dime.gui.gui.ControlSIB;
import info.scce.dime.gui.gui.FORSIB;
import info.scce.dime.gui.gui.IFSIB;
import info.scce.dime.gui.gui.ISSIB;
import info.scce.dime.gui.gui.PrimitiveInputPort;
import info.scce.dime.gui.gui.SecuritySIB;
import info.scce.dime.gui.hooks.CreateComponentHook;
import info.scce.dime.process.process.ComplexOutputPort;
import info.scce.dime.process.process.PrimitiveOutputPort;
import java.util.function.Consumer;

/**
 * The IF SIB hook is used create the corresponding arguments for the
 * corresponding control SIB
 * @author zweihoff
 */
@SuppressWarnings("all")
public class ControlSIBHook extends DIMEPostCreateHook<ControlSIB> {
  /**
   * Creates the corresponding GUI SIB input ports for every input variable
   * of the referenced GUI model.
   * For every button and branch of embedded SIBs, a branch with the corresponding ports is added.
   */
  @Override
  public void postCreate(final ControlSIB sib) {
    if ((sib instanceof IFSIB)) {
      final Argument arg = ((IFSIB)sib).newArgument(10, 70);
      arg.setBlockName("THEN");
    }
    if ((sib instanceof ISSIB)) {
      final Argument arg_1 = ((ISSIB)sib).newArgument(10, 70);
      arg_1.setBlockName("THEN");
    }
    if ((sib instanceof FORSIB)) {
      final Argument arg_2 = ((FORSIB)sib).newArgument(10, 70);
      arg_2.setBlockName("FOR");
    }
    if ((sib instanceof SecuritySIB)) {
      final Argument arg_3 = ((SecuritySIB)sib).newArgument(10, 70);
      arg_3.setBlockName("GRANTED");
    }
    this.layout(sib);
    if ((sib instanceof ISSIB)) {
      final ComplexInputPort port = ((ISSIB)sib).newComplexInputPort(((ISSIB) sib).getDataType(), 0, 0);
      port.setName("condition");
    }
    if ((sib instanceof FORSIB)) {
      final ComplexInputPort port_1 = ((FORSIB)sib).newComplexInputPort(((FORSIB) sib).getDataType(), 0, 0);
      port_1.setIsList(true);
      port_1.setName("iteration");
    }
    if ((sib instanceof SecuritySIB)) {
      final SecuritySIB secSib = ((SecuritySIB)sib);
      info.scce.dime.process.process.Process _proMod = secSib.getProMod();
      final info.scce.dime.process.process.Process process = ((info.scce.dime.process.process.Process) _proMod);
      final Consumer<PrimitiveOutputPort> _function = new Consumer<PrimitiveOutputPort>() {
        @Override
        public void accept(final PrimitiveOutputPort n) {
          ControlSIBHook.this.createPrimitive(((SecuritySIB)sib), n);
        }
      };
      Iterables.<PrimitiveOutputPort>filter(process.getStartSIBs().get(0).getOutputs(), PrimitiveOutputPort.class).forEach(_function);
      final Consumer<ComplexOutputPort> _function_1 = new Consumer<ComplexOutputPort>() {
        @Override
        public void accept(final ComplexOutputPort n) {
          ControlSIBHook.this.createComplex(((SecuritySIB)sib), n);
        }
      };
      Iterables.<ComplexOutputPort>filter(process.getStartSIBs().get(0).getOutputs(), ComplexOutputPort.class).forEach(_function_1);
    }
  }
  
  public void createPrimitive(final SecuritySIB cSib, final PrimitiveOutputPort n) {
    final PrimitiveInputPort cpip = new AddPrimitivePort().createPrimitivePort(cSib);
    cpip.setDataType(this._gUIExtension.toGUI(this._dataExtension.toData(n.getDataType())));
    cpip.setName(n.getName());
    cpip.setIsList(n.isIsList());
  }
  
  public void createComplex(final SecuritySIB cSib, final ComplexOutputPort n) {
    final ComplexInputPort port = cSib.newComplexInputPort(n.getDataType(), 0, 0);
    port.setName(n.getName());
    port.setIsList(n.isIsList());
  }
  
  public void layout(final ControlSIB sib) {
    CreateComponentHook cch = new CreateComponentHook();
    cch.postCreate(sib);
  }
}
