/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.hooks;

import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.ComplexInputPort;
import info.scce.dime.gui.gui.ControlSIB;
import info.scce.dime.gui.hooks.CreateComponentHook;
import info.scce.dime.process.helper.LayoutConstants;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Adds input ports to a given IF SIB
 * @author zweihoff
 */
@SuppressWarnings("all")
public class ComplexInputPostCreate extends DIMEPostCreateHook<ComplexInputPort> {
  @Override
  public void postCreate(final ComplexInputPort node) {
    ModelElementContainer _container = node.getContainer();
    if ((_container instanceof ControlSIB)) {
      ModelElementContainer _container_1 = node.getContainer();
      final ControlSIB cIf = ((ControlSIB) _container_1);
      StringConcatenation _builder = new StringConcatenation();
      String _firstLower = StringExtensions.toFirstLower(node.getDataType().getName());
      _builder.append(_firstLower);
      int _size = cIf.getIOs().size();
      _builder.append(_size);
      node.setName(_builder.toString());
      int _length = node.getName().length();
      int _length_1 = node.getDataType().getName().length();
      int _plus = (_length + _length_1);
      int _plus_1 = (_plus + 2);
      int _multiply = (_plus_1 * 7);
      node.setWidth(_multiply);
      int _size_1 = cIf.getIOs().size();
      int _multiply_1 = (_size_1 * LayoutConstants.PORT_SPACE);
      final int posY = (50 + _multiply_1);
      node.moveTo(cIf, LayoutConstants.PORT_X, posY);
      int _width = cIf.getWidth();
      int _height = cIf.getHeight();
      int _plus_2 = (_height + LayoutConstants.PORT_SPACE);
      cIf.resize(_width, _plus_2);
      final Consumer<Argument> _function = new Consumer<Argument>() {
        @Override
        public void accept(final Argument n) {
          int _y = n.getY();
          int _plus = (_y + LayoutConstants.PORT_SPACE);
          n.setY(_plus);
        }
      };
      cIf.getArguments().forEach(_function);
      CreateComponentHook cch = new CreateComponentHook();
      cch.postCreate(cIf);
    } else {
    }
  }
}
