/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.hooks;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.runtime.action.CincoPostAttributeChangeHook;
import graphmodel.internal.InternalContainer;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import info.scce.dime.gui.gui.StaticContent;
import info.scce.dime.gui.gui.internal.InternalBadge;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

@SuppressWarnings("all")
public class BadgeContentChange extends CincoPostAttributeChangeHook<StaticContent> {
  private final int OFFSET = 50;
  
  @Override
  public boolean canHandleChange(final StaticContent arg0, final EStructuralFeature arg1) {
    return true;
  }
  
  @Override
  public void handleChange(final StaticContent con, final EStructuralFeature arg1) {
    String _name = arg1.getName();
    boolean _equals = Objects.equal(_name, "rawContent");
    if (_equals) {
      EObject _eContainer = con.eContainer();
      if ((_eContainer instanceof InternalBadge)) {
        EObject _eContainer_1 = con.eContainer();
        InternalBadge badge = ((InternalBadge) _eContainer_1);
        InternalModelElementContainer _container = badge.getContainer();
        if ((_container instanceof InternalContainer)) {
          InternalModelElementContainer _container_1 = badge.getContainer();
          InternalContainer container = ((InternalContainer) _container_1);
          int _maxHeight = this.maxHeight(container);
          int _plus = (_maxHeight + this.OFFSET);
          container.setHeight(_plus);
        }
      }
    }
  }
  
  public int maxHeight(final InternalContainer container) {
    int maxHeight = 200;
    EList<InternalModelElement> _modelElements = container.getModelElements();
    for (final InternalModelElement element : _modelElements) {
      if ((element instanceof InternalContainer)) {
        InternalContainer baseElem = ((InternalContainer) element);
        int _height = baseElem.getHeight();
        int _y = baseElem.getY();
        int _plus = (_height + _y);
        boolean _lessThan = (maxHeight < _plus);
        if (_lessThan) {
          int _height_1 = baseElem.getHeight();
          int _y_1 = baseElem.getY();
          int _plus_1 = (_height_1 + _y_1);
          maxHeight = _plus_1;
        }
      }
    }
    return maxHeight;
  }
}
