/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.helper;

import com.google.common.collect.Iterables;
import graphmodel.ModelElement;
import info.scce.dime.data.data.PrimitiveType;
import info.scce.dime.data.data.ReferencedEnumType;
import info.scce.dime.data.data.ReferencedType;
import info.scce.dime.data.data.ReferencedUserType;
import info.scce.dime.data.data.Type;
import info.scce.dime.gUIPlugin.AbstractParameter;
import info.scce.dime.gUIPlugin.ComplexParameter;
import info.scce.dime.gUIPlugin.GenericParameter;
import info.scce.dime.gUIPlugin.Output;
import info.scce.dime.gUIPlugin.PrimitiveParameter;
import info.scce.dime.gui.gui.AddComplexToSubmission;
import info.scce.dime.gui.gui.AddPrimitiveToSubmission;
import info.scce.dime.gui.gui.AddToSubmission;
import info.scce.dime.gui.gui.Branch;
import info.scce.dime.gui.gui.Button;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.ComplexInputPort;
import info.scce.dime.gui.gui.ComplexOutputPort;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.OutputGeneric;
import info.scce.dime.gui.gui.OutputPort;
import info.scce.dime.gui.gui.PrimitiveAttribute;
import info.scce.dime.gui.gui.PrimitiveInputPort;
import info.scce.dime.gui.gui.PrimitiveOutputPort;
import info.scce.dime.gui.gui.PrimitiveVariable;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.ComplexGUIBranchPort;
import info.scce.dime.gui.helper.PrimitiveGUIBranchPort;
import info.scce.dime.process.process.BooleanInputStatic;
import info.scce.dime.process.process.EndSIB;
import info.scce.dime.process.process.Input;
import info.scce.dime.process.process.InputPort;
import info.scce.dime.process.process.InputStatic;
import info.scce.dime.process.process.IntegerInputStatic;
import info.scce.dime.process.process.RealInputStatic;
import info.scce.dime.process.process.TextInputStatic;
import info.scce.dime.process.process.TimestampInputStatic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@Accessors
@SuppressWarnings("all")
public abstract class GUIBranchPort {
  private final String name;
  
  private final EObject portNode;
  
  private EObject portSelectiveNode;
  
  private final boolean isList;
  
  public GUIBranchPort(final EObject portNode) {
    this.name = GUIBranchPort.getPortName(portNode);
    this.portNode = portNode;
    this.portSelectiveNode = portNode;
    this.isList = GUIBranchPort.isList(portNode);
  }
  
  public static GUIBranchPort toGUIBranchPort(final EObject elm) {
    GUIBranchPort _switchResult = null;
    final EObject it = elm;
    boolean _matched = false;
    boolean _isComplex = GUIBranchPort.isComplex(it);
    if (_isComplex) {
      _matched=true;
      _switchResult = new ComplexGUIBranchPort(elm);
    }
    if (!_matched) {
      _switchResult = new PrimitiveGUIBranchPort(elm);
    }
    return _switchResult;
  }
  
  public static String getPortName(final EObject it) {
    String _switchResult = null;
    boolean _matched = false;
    if (it instanceof PrimitiveAttribute) {
      _matched=true;
      _switchResult = ((PrimitiveAttribute)it).getAttribute().getName();
    }
    if (!_matched) {
      if (it instanceof ComplexAttribute) {
        _matched=true;
        _switchResult = ((ComplexAttribute)it).getAttribute().getName();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPort) {
        _matched=true;
        _switchResult = ((PrimitiveInputPort)it).getName();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPort) {
        _matched=true;
        _switchResult = ((ComplexInputPort)it).getName();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPort) {
        _matched=true;
        _switchResult = ((ComplexOutputPort)it).getName();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPort) {
        _matched=true;
        _switchResult = ((PrimitiveOutputPort)it).getName();
      }
    }
    if (!_matched) {
      if (it instanceof OutputGeneric) {
        _matched=true;
        _switchResult = ((OutputGeneric)it).getName();
      }
    }
    if (!_matched) {
      if (it instanceof Variable) {
        _matched=true;
        _switchResult = ((Variable)it).getName();
      }
    }
    if (!_matched) {
      if (it instanceof AddToSubmission) {
        _matched=true;
        String _xifexpression = null;
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(((AddToSubmission)it).getOutputName());
        boolean _not = (!_isNullOrEmpty);
        if (_not) {
          _xifexpression = ((AddToSubmission)it).getOutputName();
        } else {
          _xifexpression = GUIBranchPort.getPortName(((AddToSubmission)it).getSourceElement());
        }
        _switchResult = _xifexpression;
      }
    }
    if (!_matched) {
      if (it instanceof AbstractParameter) {
        _matched=true;
        _switchResult = ((AbstractParameter)it).getName();
      }
    }
    if (!_matched) {
      if (it instanceof Input) {
        _matched=true;
        _switchResult = ((Input)it).getName();
      }
    }
    return _switchResult;
  }
  
  public static boolean isList(final EObject port) {
    boolean _switchResult = false;
    final EObject it = port;
    boolean _matched = false;
    if (it instanceof PrimitiveAttribute) {
      _matched=true;
      _switchResult = ((PrimitiveAttribute)it).getAttribute().isIsList();
    }
    if (!_matched) {
      if (it instanceof ComplexAttribute) {
        _matched=true;
        _switchResult = ((ComplexAttribute)it).getAttribute().isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPort) {
        _matched=true;
        _switchResult = ((PrimitiveInputPort)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexInputPort) {
        _matched=true;
        _switchResult = ((ComplexInputPort)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPort) {
        _matched=true;
        _switchResult = ((ComplexOutputPort)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPort) {
        _matched=true;
        _switchResult = ((PrimitiveOutputPort)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof OutputGeneric) {
        _matched=true;
        _switchResult = ((OutputGeneric)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof Variable) {
        _matched=true;
        _switchResult = ((Variable)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof AddToSubmission) {
        _matched=true;
        _switchResult = GUIBranchPort.isList(((AddToSubmission)it).getSourceElement());
      }
    }
    if (!_matched) {
      if (it instanceof AbstractParameter) {
        _matched=true;
        _switchResult = ((AbstractParameter)it).isIsList();
      }
    }
    if (!_matched) {
      if (it instanceof InputPort) {
        _matched=true;
        _switchResult = ((InputPort)it).isIsList();
      }
    }
    if (!_matched) {
      _switchResult = false;
    }
    return _switchResult;
  }
  
  public static boolean isComplex(final EObject port) {
    final Function1<Class<? extends EObject>, Boolean> _function = new Function1<Class<? extends EObject>, Boolean>() {
      @Override
      public Boolean apply(final Class<? extends EObject> it) {
        return Boolean.valueOf(it.isInstance(port));
      }
    };
    return IterableExtensions.exists(Collections.<Class<? extends EObject>>unmodifiableSet(CollectionLiterals.<Class<? extends EObject>>newHashSet(ComplexVariable.class, ComplexAttribute.class, ComplexOutputPort.class, AddComplexToSubmission.class, ComplexParameter.class, info.scce.dime.process.process.ComplexInputPort.class)), _function);
  }
  
  public static Type getComplexType(final EObject port) {
    Type _switchResult = null;
    final EObject it = port;
    boolean _matched = false;
    if (it instanceof ComplexVariable) {
      _matched=true;
      _switchResult = GUIBranchPort.getOriginalType(((ComplexVariable)it).getDataType());
    }
    if (!_matched) {
      if (it instanceof ComplexAttribute) {
        _matched=true;
        _switchResult = GUIBranchPort.getOriginalType(((ComplexAttribute)it).getAttribute().getDataType());
      }
    }
    if (!_matched) {
      if (it instanceof ComplexOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getOriginalType(((ComplexOutputPort)it).getDataType());
      }
    }
    if (!_matched) {
      if (it instanceof ComplexParameter) {
        _matched=true;
        EObject _type = ((ComplexParameter)it).getType();
        _switchResult = GUIBranchPort.getOriginalType(((Type) _type));
      }
    }
    if (!_matched) {
      if (it instanceof AddComplexToSubmission) {
        _matched=true;
        _switchResult = GUIBranchPort.getComplexType(((AddComplexToSubmission)it).getSourceElement());
      }
    }
    if (!_matched) {
      if (it instanceof info.scce.dime.process.process.ComplexInputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.getOriginalType(((info.scce.dime.process.process.ComplexInputPort)it).getDataType());
      }
    }
    return _switchResult;
  }
  
  public static boolean isPrimitive(final EObject port) {
    final Function1<Class<? extends EObject>, Boolean> _function = new Function1<Class<? extends EObject>, Boolean>() {
      @Override
      public Boolean apply(final Class<? extends EObject> it) {
        return Boolean.valueOf(it.isInstance(port));
      }
    };
    return IterableExtensions.exists(Collections.<Class<? extends EObject>>unmodifiableSet(CollectionLiterals.<Class<? extends EObject>>newHashSet(PrimitiveVariable.class, PrimitiveAttribute.class, PrimitiveInputPort.class, PrimitiveOutputPort.class, AddPrimitiveToSubmission.class, PrimitiveParameter.class, info.scce.dime.process.process.PrimitiveInputPort.class, InputStatic.class)), _function);
  }
  
  public static PrimitiveType getPrimitiveType(final EObject port) {
    PrimitiveType _switchResult = null;
    final EObject it = port;
    boolean _matched = false;
    if (it instanceof PrimitiveVariable) {
      _matched=true;
      _switchResult = GUIBranchPort.toData(((PrimitiveVariable)it).getDataType());
    }
    if (!_matched) {
      if (it instanceof PrimitiveAttribute) {
        _matched=true;
        _switchResult = ((PrimitiveAttribute)it).getAttribute().getDataType();
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveInputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.toData(((PrimitiveInputPort)it).getDataType());
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveOutputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.toData(((PrimitiveOutputPort)it).getDataType());
      }
    }
    if (!_matched) {
      if (it instanceof PrimitiveParameter) {
        _matched=true;
        _switchResult = GUIBranchPort.toData(((PrimitiveParameter)it).getType());
      }
    }
    if (!_matched) {
      if (it instanceof AddPrimitiveToSubmission) {
        _matched=true;
        _switchResult = GUIBranchPort.getPrimitiveType(((AddPrimitiveToSubmission)it).getSourceElement());
      }
    }
    if (!_matched) {
      if (it instanceof info.scce.dime.process.process.PrimitiveInputPort) {
        _matched=true;
        _switchResult = GUIBranchPort.toData(((info.scce.dime.process.process.PrimitiveInputPort)it).getDataType());
      }
    }
    if (!_matched) {
      if (it instanceof TextInputStatic) {
        _matched=true;
        _switchResult = PrimitiveType.TEXT;
      }
    }
    if (!_matched) {
      if (it instanceof IntegerInputStatic) {
        _matched=true;
        _switchResult = PrimitiveType.INTEGER;
      }
    }
    if (!_matched) {
      if (it instanceof RealInputStatic) {
        _matched=true;
        _switchResult = PrimitiveType.REAL;
      }
    }
    if (!_matched) {
      if (it instanceof BooleanInputStatic) {
        _matched=true;
        _switchResult = PrimitiveType.BOOLEAN;
      }
    }
    if (!_matched) {
      if (it instanceof TimestampInputStatic) {
        _matched=true;
        _switchResult = PrimitiveType.TIMESTAMP;
      }
    }
    return _switchResult;
  }
  
  protected static List<GUIBranchPort> _getPorts(final EndSIB endSIB) {
    ArrayList<GUIBranchPort> _newArrayList = CollectionLiterals.<GUIBranchPort>newArrayList();
    final Procedure1<ArrayList<GUIBranchPort>> _function = new Procedure1<ArrayList<GUIBranchPort>>() {
      @Override
      public void apply(final ArrayList<GUIBranchPort> it) {
        final Function1<Input, GUIBranchPort> _function = new Function1<Input, GUIBranchPort>() {
          @Override
          public GUIBranchPort apply(final Input it) {
            return GUIBranchPort.toGUIBranchPort(it);
          }
        };
        it.addAll(
          ListExtensions.<Input, GUIBranchPort>map(endSIB.getInputs(), _function));
      }
    };
    return ObjectExtensions.<ArrayList<GUIBranchPort>>operator_doubleArrow(_newArrayList, _function);
  }
  
  protected static List<GUIBranchPort> _getPorts(final Button button) {
    ArrayList<GUIBranchPort> _newArrayList = CollectionLiterals.<GUIBranchPort>newArrayList();
    final Procedure1<ArrayList<GUIBranchPort>> _function = new Procedure1<ArrayList<GUIBranchPort>>() {
      @Override
      public void apply(final ArrayList<GUIBranchPort> it) {
        boolean _isBranchable = GUIBranchPort.isBranchable(button);
        if (_isBranchable) {
          final Function1<AddToSubmission, ModelElement> _function = new Function1<AddToSubmission, ModelElement>() {
            @Override
            public ModelElement apply(final AddToSubmission it) {
              ModelElement _switchResult = null;
              boolean _matched = false;
              boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getOutputName());
              if (_isNullOrEmpty) {
                _matched=true;
                _switchResult = it.getSourceElement();
              }
              if (!_matched) {
                _switchResult = it;
              }
              return _switchResult;
            }
          };
          final Function1<ModelElement, GUIBranchPort> _function_1 = new Function1<ModelElement, GUIBranchPort>() {
            @Override
            public GUIBranchPort apply(final ModelElement it) {
              return GUIBranchPort.toGUIBranchPort(it);
            }
          };
          it.addAll(
            ListExtensions.<ModelElement, GUIBranchPort>map(ListExtensions.<AddToSubmission, ModelElement>map(button.<AddToSubmission>getIncoming(AddToSubmission.class), _function), _function_1));
        }
      }
    };
    return ObjectExtensions.<ArrayList<GUIBranchPort>>operator_doubleArrow(_newArrayList, _function);
  }
  
  protected static List<GUIBranchPort> _getPorts(final Output output) {
    ArrayList<GUIBranchPort> _newArrayList = CollectionLiterals.<GUIBranchPort>newArrayList();
    final Procedure1<ArrayList<GUIBranchPort>> _function = new Procedure1<ArrayList<GUIBranchPort>>() {
      @Override
      public void apply(final ArrayList<GUIBranchPort> it) {
        final Function1<AbstractParameter, Boolean> _function = new Function1<AbstractParameter, Boolean>() {
          @Override
          public Boolean apply(final AbstractParameter it) {
            return Boolean.valueOf((!(it instanceof GenericParameter)));
          }
        };
        final Function1<AbstractParameter, GUIBranchPort> _function_1 = new Function1<AbstractParameter, GUIBranchPort>() {
          @Override
          public GUIBranchPort apply(final AbstractParameter it) {
            return GUIBranchPort.toGUIBranchPort(it);
          }
        };
        Iterables.<GUIBranchPort>addAll(it, 
          IterableExtensions.<AbstractParameter, GUIBranchPort>map(IterableExtensions.<AbstractParameter>filter(output.getParameters(), _function), _function_1));
      }
    };
    return ObjectExtensions.<ArrayList<GUIBranchPort>>operator_doubleArrow(_newArrayList, _function);
  }
  
  protected static List<GUIBranchPort> _getPorts(final Branch branch) {
    ArrayList<GUIBranchPort> _newArrayList = CollectionLiterals.<GUIBranchPort>newArrayList();
    final Procedure1<ArrayList<GUIBranchPort>> _function = new Procedure1<ArrayList<GUIBranchPort>>() {
      @Override
      public void apply(final ArrayList<GUIBranchPort> it) {
        final Function1<OutputPort, GUIBranchPort> _function = new Function1<OutputPort, GUIBranchPort>() {
          @Override
          public GUIBranchPort apply(final OutputPort it) {
            return GUIBranchPort.toGUIBranchPort(it);
          }
        };
        it.addAll(
          ListExtensions.<OutputPort, GUIBranchPort>map(branch.getOutputPorts(), _function));
      }
    };
    return ObjectExtensions.<ArrayList<GUIBranchPort>>operator_doubleArrow(_newArrayList, _function);
  }
  
  public static boolean isBranchable(final Button it) {
    return ((!it.isDisabled()) && ((it.getOptions() == null) || StringExtensions.isNullOrEmpty(it.getOptions().getStaticURL())));
  }
  
  public static PrimitiveType toData(final info.scce.dime.gui.gui.PrimitiveType it) {
    PrimitiveType _switchResult = null;
    if (it != null) {
      switch (it) {
        case BOOLEAN:
          _switchResult = PrimitiveType.BOOLEAN;
          break;
        case FILE:
          _switchResult = PrimitiveType.FILE;
          break;
        case INTEGER:
          _switchResult = PrimitiveType.INTEGER;
          break;
        case REAL:
          _switchResult = PrimitiveType.REAL;
          break;
        case TEXT:
          _switchResult = PrimitiveType.TEXT;
          break;
        case TIMESTAMP:
          _switchResult = PrimitiveType.TIMESTAMP;
          break;
        default:
          break;
      }
    }
    return _switchResult;
  }
  
  public static PrimitiveType toData(final info.scce.dime.gUIPlugin.PrimitiveType it) {
    PrimitiveType _switchResult = null;
    if (it != null) {
      switch (it) {
        case BOOLEAN:
          _switchResult = PrimitiveType.BOOLEAN;
          break;
        case INTEGER:
          _switchResult = PrimitiveType.INTEGER;
          break;
        case REAL:
          _switchResult = PrimitiveType.REAL;
          break;
        case TEXT:
          _switchResult = PrimitiveType.TEXT;
          break;
        case TIMESTAMP:
          _switchResult = PrimitiveType.TIMESTAMP;
          break;
        default:
          break;
      }
    }
    return _switchResult;
  }
  
  public static PrimitiveType toData(final info.scce.dime.process.process.PrimitiveType it) {
    PrimitiveType _switchResult = null;
    if (it != null) {
      switch (it) {
        case BOOLEAN:
          _switchResult = PrimitiveType.BOOLEAN;
          break;
        case FILE:
          _switchResult = PrimitiveType.FILE;
          break;
        case INTEGER:
          _switchResult = PrimitiveType.INTEGER;
          break;
        case REAL:
          _switchResult = PrimitiveType.REAL;
          break;
        case TEXT:
          _switchResult = PrimitiveType.TEXT;
          break;
        case TIMESTAMP:
          _switchResult = PrimitiveType.TIMESTAMP;
          break;
        default:
          break;
      }
    }
    return _switchResult;
  }
  
  public static Type getOriginalType(final Type type) {
    Type _switchResult = null;
    final Type it = type;
    boolean _matched = false;
    if (it instanceof ReferencedType) {
      _matched=true;
      _switchResult = GUIBranchPort.getOriginalType(((ReferencedType)it).getReferencedType());
    }
    if (!_matched) {
      if (it instanceof ReferencedUserType) {
        _matched=true;
        _switchResult = GUIBranchPort.getOriginalType(((ReferencedUserType)it).getReferencedType());
      }
    }
    if (!_matched) {
      if (it instanceof ReferencedEnumType) {
        _matched=true;
        _switchResult = GUIBranchPort.getOriginalType(((ReferencedEnumType)it).getReferencedType());
      }
    }
    if (!_matched) {
      _switchResult = it;
    }
    return _switchResult;
  }
  
  public static List<GUIBranchPort> getPorts(final EObject button) {
    if (button instanceof Button) {
      return _getPorts((Button)button);
    } else if (button instanceof Branch) {
      return _getPorts((Branch)button);
    } else if (button instanceof EndSIB) {
      return _getPorts((EndSIB)button);
    } else if (button instanceof Output) {
      return _getPorts((Output)button);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(button).toString());
    }
  }
  
  @Pure
  public String getName() {
    return this.name;
  }
  
  @Pure
  public EObject getPortNode() {
    return this.portNode;
  }
  
  @Pure
  public EObject getPortSelectiveNode() {
    return this.portSelectiveNode;
  }
  
  public void setPortSelectiveNode(final EObject portSelectiveNode) {
    this.portSelectiveNode = portSelectiveNode;
  }
  
  @Pure
  public boolean isList() {
    return this.isList;
  }
}
