/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.helper;

import graphmodel.GraphModel;
import graphmodel.ModelElement;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.gUIPlugin.Output;
import info.scce.dime.gui.gui.BaseElement;
import info.scce.dime.gui.gui.Branch;
import info.scce.dime.gui.gui.Button;
import info.scce.dime.gui.gui.DispatchedGUISIB;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GUIPlugin;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.ProcessSIB;
import info.scce.dime.gui.gui.SIB;
import info.scce.dime.gui.helper.ComplexGUIBranchPort;
import info.scce.dime.gui.helper.GUIBranchPort;
import info.scce.dime.process.process.EndSIB;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.xtend.lib.annotations.Data;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

@Data
@SuppressWarnings("all")
public class GUIBranch {
  private final ModelElement element;
  
  private final String name;
  
  private final List<GUIBranchPort> ports;
  
  @Extension
  private final DataExtension _dataExtension = DataExtension.getInstance();
  
  public static final List<? extends Class<? extends BaseElement>> ALL_BRANCH_ELEMENT_TYPES = Collections.<Class<? extends BaseElement>>unmodifiableList(CollectionLiterals.<Class<? extends BaseElement>>newArrayList(Button.class, GUIPlugin.class, ProcessSIB.class, DispatchedGUISIB.class, GUISIB.class));
  
  public static final List<? extends Class<? extends SIB>> PROCESS_BRANCH_ELEMENT_TYPES = Collections.<Class<? extends SIB>>unmodifiableList(CollectionLiterals.<Class<? extends SIB>>newArrayList(ProcessSIB.class, GUISIB.class, DispatchedGUISIB.class));
  
  public GUIBranch mergedWith(final GUIBranch other) {
    GUIBranch _xblockexpression = null;
    {
      final Function1<GUIBranchPort, String> _function = new Function1<GUIBranchPort, String>() {
        @Override
        public String apply(final GUIBranchPort it) {
          return it.getName();
        }
      };
      final Map<String, GUIBranchPort> portsByName = IterableExtensions.<String, GUIBranchPort>toMap(this.ports, _function);
      for (final GUIBranchPort otherPort : other.ports) {
        {
          final GUIBranchPort knownPort = portsByName.get(otherPort.getName());
          if ((knownPort == null)) {
            portsByName.put(otherPort.getName(), otherPort);
          } else {
            if ((knownPort instanceof ComplexGUIBranchPort)) {
              boolean _equals = ((ComplexGUIBranchPort)knownPort).getType().equals(((ComplexGUIBranchPort) otherPort).getType());
              boolean _not = (!_equals);
              if (_not) {
                final List<Type> superTypes = this._dataExtension.getSuperTypes(((ComplexGUIBranchPort)knownPort).getType()).toList();
                final Predicate<Type> _function_1 = new Predicate<Type>() {
                  @Override
                  public boolean test(final Type it) {
                    return superTypes.contains(it);
                  }
                };
                final List<Type> equalSuperTypes = this._dataExtension.getSuperTypes(((ComplexGUIBranchPort) otherPort).getType()).filter(_function_1).toList();
                boolean _isEmpty = equalSuperTypes.isEmpty();
                boolean _not_1 = (!_isEmpty);
                if (_not_1) {
                  ((ComplexGUIBranchPort)knownPort).setType(equalSuperTypes.get(0));
                }
                final Consumer<Type> _function_2 = new Consumer<Type>() {
                  @Override
                  public void accept(final Type est) {
                    int _length = ((Object[])Conversions.unwrapArray(GUIBranch.this._dataExtension.getSuperTypes(((ComplexGUIBranchPort)knownPort).getType()), Object.class)).length;
                    int _length_1 = ((Object[])Conversions.unwrapArray(GUIBranch.this._dataExtension.getSuperTypes(est), Object.class)).length;
                    boolean _lessThan = (_length < _length_1);
                    if (_lessThan) {
                      ((ComplexGUIBranchPort)knownPort).setType(est);
                    }
                  }
                };
                equalSuperTypes.forEach(_function_2);
              }
            }
          }
        }
      }
      List<GUIBranchPort> _list = IterableExtensions.<GUIBranchPort>toList(portsByName.values());
      _xblockexpression = new GUIBranch(this.element, this.name, _list);
    }
    return _xblockexpression;
  }
  
  public Class<? extends GraphModel> getOriginatingModelClass() {
    return this.element.getRootElement().getClass();
  }
  
  public boolean hasGUIOrigin() {
    GraphModel _rootElement = this.element.getRootElement();
    return (_rootElement instanceof GUI);
  }
  
  public boolean hasProcessOrigin() {
    GraphModel _rootElement = this.element.getRootElement();
    return (_rootElement instanceof info.scce.dime.process.process.Process);
  }
  
  public static GUIBranch toGUIBranch(final ModelElement elm) {
    String _branchName = GUIBranch.getBranchName(elm);
    List<GUIBranchPort> _ports = GUIBranchPort.getPorts(elm);
    return new GUIBranch(elm, _branchName, _ports);
  }
  
  public static String getBranchName(final ModelElement elm) {
    String _switchResult = null;
    final ModelElement it = elm;
    boolean _matched = false;
    if (it instanceof Button) {
      _matched=true;
      _switchResult = ((Button)it).getLabel();
    }
    if (!_matched) {
      if (it instanceof Branch) {
        _matched=true;
        _switchResult = ((Branch)it).getName();
      }
    }
    if (!_matched) {
      if (it instanceof Output) {
        _matched=true;
        _switchResult = ((Output)it).getOutputName();
      }
    }
    if (!_matched) {
      if (it instanceof EndSIB) {
        _matched=true;
        _switchResult = ((EndSIB)it).getBranchName();
      }
    }
    return _switchResult;
  }
  
  public static Collection<GUIBranch> merge(final Iterable<GUIBranch> it) {
    final Function1<GUIBranch, List<Serializable>> _function = new Function1<GUIBranch, List<Serializable>>() {
      @Override
      public List<Serializable> apply(final GUIBranch it) {
        Class<? extends GraphModel> _originatingModelClass = it.getOriginatingModelClass();
        return Collections.<Serializable>unmodifiableList(CollectionLiterals.<Serializable>newArrayList(it.name, _originatingModelClass));
      }
    };
    final Function1<List<GUIBranch>, GUIBranch> _function_1 = new Function1<List<GUIBranch>, GUIBranch>() {
      @Override
      public GUIBranch apply(final List<GUIBranch> it) {
        final Function2<GUIBranch, GUIBranch, GUIBranch> _function = new Function2<GUIBranch, GUIBranch, GUIBranch>() {
          @Override
          public GUIBranch apply(final GUIBranch x, final GUIBranch y) {
            return x.mergedWith(y);
          }
        };
        return IterableExtensions.<GUIBranch>reduce(it, _function);
      }
    };
    return MapExtensions.<List<Serializable>, List<GUIBranch>, GUIBranch>mapValues(IterableExtensions.<List<Serializable>, GUIBranch>groupBy(it, _function), _function_1).values();
  }
  
  public GUIBranch(final ModelElement element, final String name, final List<GUIBranchPort> ports) {
    super();
    this.element = element;
    this.name = name;
    this.ports = ports;
  }
  
  @Override
  @Pure
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.element== null) ? 0 : this.element.hashCode());
    result = prime * result + ((this.name== null) ? 0 : this.name.hashCode());
    result = prime * result + ((this.ports== null) ? 0 : this.ports.hashCode());
    return prime * result + ((this._dataExtension== null) ? 0 : this._dataExtension.hashCode());
  }
  
  @Override
  @Pure
  public boolean equals(final Object obj) {
    if (this == obj)
      return true;
    if (obj == null)
      return false;
    if (getClass() != obj.getClass())
      return false;
    GUIBranch other = (GUIBranch) obj;
    if (this.element == null) {
      if (other.element != null)
        return false;
    } else if (!this.element.equals(other.element))
      return false;
    if (this.name == null) {
      if (other.name != null)
        return false;
    } else if (!this.name.equals(other.name))
      return false;
    if (this.ports == null) {
      if (other.ports != null)
        return false;
    } else if (!this.ports.equals(other.ports))
      return false;
    if (this._dataExtension == null) {
      if (other._dataExtension != null)
        return false;
    } else if (!this._dataExtension.equals(other._dataExtension))
      return false;
    return true;
  }
  
  @Override
  @Pure
  public String toString() {
    ToStringBuilder b = new ToStringBuilder(this);
    b.add("element", this.element);
    b.add("name", this.name);
    b.add("ports", this.ports);
    b.add("_dataExtension", this._dataExtension);
    return b.toString();
  }
  
  @Pure
  public ModelElement getElement() {
    return this.element;
  }
  
  @Pure
  public String getName() {
    return this.name;
  }
  
  @Pure
  public List<GUIBranchPort> getPorts() {
    return this.ports;
  }
  
  @Pure
  public DataExtension get_dataExtension() {
    return this._dataExtension;
  }
}
