/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.helper;

import graphmodel.Node;
import java.util.List;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Utility methods to collect model elements of a certain type
 * respecting their generation order as well as their vertical
 * and horizontal position.
 */
@SuppressWarnings("all")
public class ElementCollector {
  /**
   * Sorts a list of nodes according to their horizontal position.
   * 
   * @param elements
   * @return
   */
  public static <T extends Node> List<T> getElementsH(final Iterable<T> elements) {
    final Function1<T, Integer> _function = new Function1<T, Integer>() {
      @Override
      public Integer apply(final T it) {
        return Integer.valueOf(it.getX());
      }
    };
    return IterableExtensions.<T, Integer>sortBy(elements, _function);
  }
  
  /**
   * Sorts a list of nodes according to their vertical position.
   * 
   * @param elements
   * @return
   */
  public static <T extends Node> List<T> getElementsV(final Iterable<T> elements) {
    final Function1<T, Integer> _function = new Function1<T, Integer>() {
      @Override
      public Integer apply(final T it) {
        return Integer.valueOf(it.getY());
      }
    };
    return IterableExtensions.<T, Integer>sortBy(elements, _function);
  }
}
