/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.helper;

import com.google.common.base.Objects;
import graphmodel.ModelElementContainer;
import info.scce.dime.data.data.Type;
import info.scce.dime.gUIPlugin.AbstractParameter;
import info.scce.dime.gUIPlugin.Function;
import info.scce.dime.gUIPlugin.Output;
import info.scce.dime.gui.gui.AddComplexToSubmission;
import info.scce.dime.gui.gui.Branch;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.ComplexOutputPort;
import info.scce.dime.gui.gui.GUIPlugin;
import info.scce.dime.gui.gui.SIB;
import info.scce.dime.gui.helper.GUIBranchPort;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;

@Accessors
@SuppressWarnings("all")
public class ComplexGUIBranchPort extends GUIBranchPort {
  private Type type;
  
  public ComplexGUIBranchPort(final EObject portNode) {
    super(portNode);
    this.type = GUIBranchPort.getComplexType(portNode);
  }
  
  public EObject getTypeViewData() {
    EObject _switchResult = null;
    EObject _portSelectiveNode = this.getPortSelectiveNode();
    final EObject selectiveNode = _portSelectiveNode;
    boolean _matched = false;
    if (selectiveNode instanceof AddComplexToSubmission) {
      _matched=true;
      _switchResult = ((AddComplexToSubmission)selectiveNode).getSourceElement();
    }
    if (!_matched) {
      if (selectiveNode instanceof ComplexAttribute) {
        _matched=true;
        _switchResult = ((ComplexAttribute)selectiveNode).getAttribute();
      }
    }
    if (!_matched) {
      if (selectiveNode instanceof ComplexOutputPort) {
        if (((((ComplexOutputPort)selectiveNode).getContainer() instanceof Branch) && (((Branch) ((ComplexOutputPort)selectiveNode).getContainer()).getContainer() instanceof GUIPlugin))) {
          _matched=true;
          AbstractParameter _xblockexpression = null;
          {
            ModelElementContainer _container = ((ComplexOutputPort)selectiveNode).getContainer();
            SIB _container_1 = ((Branch) _container).getContainer();
            final GUIPlugin guiPlugin = ((GUIPlugin) _container_1);
            EObject _function = guiPlugin.getFunction();
            final Function fun = ((Function) _function);
            final Function1<Output, EList<AbstractParameter>> _function_1 = new Function1<Output, EList<AbstractParameter>>() {
              @Override
              public EList<AbstractParameter> apply(final Output it) {
                return it.getParameters();
              }
            };
            final Function1<AbstractParameter, Boolean> _function_2 = new Function1<AbstractParameter, Boolean>() {
              @Override
              public Boolean apply(final AbstractParameter it) {
                String _name = it.getName();
                String _name_1 = ((ComplexOutputPort)selectiveNode).getName();
                return Boolean.valueOf(Objects.equal(_name, _name_1));
              }
            };
            final AbstractParameter param = IterableExtensions.<AbstractParameter>findFirst(IterableExtensions.<Output, AbstractParameter>flatMap(fun.getOutputs(), _function_1), _function_2);
            AbstractParameter _xifexpression = null;
            if ((param == null)) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("port could not be found on plugin ");
              String _label = guiPlugin.getLabel();
              _builder.append(_label);
              _builder.append(" in ");
              String _title = guiPlugin.getRootElement().getTitle();
              _builder.append(_title);
              throw new IllegalStateException(_builder.toString());
            } else {
              _xifexpression = param;
            }
            _xblockexpression = _xifexpression;
          }
          _switchResult = _xblockexpression;
        }
      }
    }
    if (!_matched) {
      _switchResult = selectiveNode;
    }
    return _switchResult;
  }
  
  @Pure
  public Type getType() {
    return this.type;
  }
  
  public void setType(final Type type) {
    this.type = type;
  }
}
