/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.checks;

import com.google.common.collect.Iterables;
import graphmodel.Container;
import graphmodel.GraphModel;
import graphmodel.ModelElement;
import graphmodel.ModelElementContainer;
import info.scce.dime.checks.GUICheck;
import info.scce.dime.data.data.Type;
import info.scce.dime.gui.gui.Button;
import info.scce.dime.gui.gui.ComplexAttributeConnector;
import info.scce.dime.gui.gui.ComplexListAttributeConnector;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.FOR;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.MovableContainer;
import info.scce.dime.gui.gui.Placeholder;
import info.scce.dime.gui.gui.PrimitiveVariable;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.ComplexGUIBranchPort;
import info.scce.dime.gui.helper.GUIBranch;
import info.scce.dime.gui.helper.GUIBranchPort;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.jooq.lambda.Seq;

@SuppressWarnings("all")
public class UniqueNamesCheck extends GUICheck {
  private GUI model;
  
  private final HashSet<Object> contextVarNames = CollectionLiterals.<Object>newHashSet();
  
  private final HashSet<Object> placeholderNames = CollectionLiterals.<Object>newHashSet();
  
  @Override
  public void init() {
    this.contextVarNames.clear();
    this.placeholderNames.clear();
  }
  
  @Override
  public void check(final GUI model) {
    this.model = model;
    final Procedure1<GUI> _function = new Procedure1<GUI>() {
      @Override
      public void apply(final GUI it) {
        UniqueNamesCheck.this.checkBranches(it);
        final Consumer<Variable> _function = new Consumer<Variable>() {
          @Override
          public void accept(final Variable it) {
            UniqueNamesCheck.this.check(it);
          }
        };
        UniqueNamesCheck.this.guiex.<Variable>find(it, Variable.class).forEach(_function);
        final Consumer<Button> _function_1 = new Consumer<Button>() {
          @Override
          public void accept(final Button it) {
            UniqueNamesCheck.this.check(it);
          }
        };
        UniqueNamesCheck.this.guiex.<Button>find(it, Button.class).forEach(_function_1);
        final Consumer<FOR> _function_2 = new Consumer<FOR>() {
          @Override
          public void accept(final FOR it) {
            UniqueNamesCheck.this.check(it);
          }
        };
        UniqueNamesCheck.this.guiex.<FOR>find(it, FOR.class).forEach(_function_2);
        final Consumer<Placeholder> _function_3 = new Consumer<Placeholder>() {
          @Override
          public void accept(final Placeholder it) {
            UniqueNamesCheck.this.check(it);
          }
        };
        UniqueNamesCheck.this.guiex.<Placeholder>find(it, Placeholder.class).forEach(_function_3);
      }
    };
    ObjectExtensions.<GUI>operator_doubleArrow(model, _function);
  }
  
  protected void _check(final Button it) {
    final Function1<Button, Boolean> _function = new Function1<Button, Boolean>() {
      @Override
      public Boolean apply(final Button it) {
        final Function1<GUIBranchPort, String> _function = new Function1<GUIBranchPort, String>() {
          @Override
          public String apply(final GUIBranchPort it) {
            return it.getName();
          }
        };
        boolean _containsDuplicatesByKey = UniqueNamesCheck.this.<GUIBranchPort, String>containsDuplicatesByKey(GUIBranchPort.getPorts(it), _function);
        return Boolean.valueOf((!_containsDuplicatesByKey));
      }
    };
    this.<Button>check(it, _function).elseError("Port names must be unique");
  }
  
  protected void _check(final FOR forObj) {
    String index = forObj.getIndex();
    if (((index == null) || "".equals(index))) {
      this.addError(forObj, "index attribute not set");
      return;
    }
    ComplexVariable currentVar = null;
    int _size = forObj.getSourceElement().<ComplexListAttributeConnector>getOutgoing(ComplexListAttributeConnector.class).size();
    boolean _tripleEquals = (_size == 1);
    if (_tripleEquals) {
      ComplexVariable _targetElement = forObj.getSourceElement().<ComplexListAttributeConnector>getOutgoing(ComplexListAttributeConnector.class).get(0).getTargetElement();
      currentVar = ((ComplexVariable) _targetElement);
    }
    MovableContainer _targetElement_1 = forObj.getTargetElement();
    MovableContainer mc = ((MovableContainer) _targetElement_1);
    ModelElementContainer mec = mc.getContainer();
    while ((Boolean.valueOf((mec instanceof GraphModel)) == Boolean.valueOf(false))) {
      if ((mec instanceof Container)) {
        Container container = ((Container) mec);
        boolean _isEmpty = container.<FOR>getIncoming(FOR.class).isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          EList<FOR> _incoming = container.<FOR>getIncoming(FOR.class);
          for (final FOR parentFor : _incoming) {
            {
              boolean _equals = index.equals(parentFor.getIndex());
              if (_equals) {
                this.addError(forObj, "index attribute not unique");
              }
              ComplexVariable parentCurrentVar = null;
              int _size_1 = parentFor.getSourceElement().<ComplexListAttributeConnector>getOutgoing(ComplexListAttributeConnector.class).size();
              boolean _tripleEquals_1 = (_size_1 == 1);
              if (_tripleEquals_1) {
                ComplexVariable _targetElement_2 = parentFor.getSourceElement().<ComplexListAttributeConnector>getOutgoing(ComplexListAttributeConnector.class).get(0).getTargetElement();
                parentCurrentVar = ((ComplexVariable) _targetElement_2);
              }
              if ((((currentVar != null) && (parentCurrentVar != null)) && currentVar.getName().equals(parentCurrentVar.getName()))) {
                this.addError(this.adapter.getIdByString(currentVar.getId()), "name as iterator not unique");
              }
            }
          }
        }
        mec = container.getContainer();
      }
    }
  }
  
  /**
   * Checks if all button labels present in the GUI as well as all branch names of all embedded SIBs
   * are uniquely named.
   * @param gui
   */
  public void checkBranches(final GUI gui) {
    final Function1<GUIBranch, Boolean> _function = new Function1<GUIBranch, Boolean>() {
      @Override
      public Boolean apply(final GUIBranch it) {
        boolean _isEmpty = UniqueNamesCheck.this.guiex.equallyNamedPorts(it.getPorts()).isEmpty();
        return Boolean.valueOf((!_isEmpty));
      }
    };
    final Consumer<GUIBranch> _function_1 = new Consumer<GUIBranch>() {
      @Override
      public void accept(final GUIBranch n) {
        final Consumer<GUIBranchPort> _function = new Consumer<GUIBranchPort>() {
          @Override
          public void accept(final GUIBranchPort e) {
            final Function1<GUIBranchPort, Boolean> _function = new Function1<GUIBranchPort, Boolean>() {
              @Override
              public Boolean apply(final GUIBranchPort port) {
                return Boolean.valueOf(port.getName().equals(e.getName()));
              }
            };
            UniqueNamesCheck.this.checkEqualPortTypes(IterableExtensions.<GUIBranchPort>toList(IterableExtensions.<GUIBranchPort>filter(n.getPorts(), _function)), n.getName(), UniqueNamesCheck.this.guiex.equallyNamedPorts(n.getPorts()).get(0).getName());
          }
        };
        UniqueNamesCheck.this.guiex.equallyNamedPorts(n.getPorts()).forEach(_function);
      }
    };
    IterableExtensions.<GUIBranch>filter(this.guiex.getGUIBranchesMerged(gui), _function).forEach(_function_1);
  }
  
  public Object checkEqualPortTypes(final List<GUIBranchPort> ports, final String branchName, final String portName) {
    Object _xblockexpression = null;
    {
      final int complexSize = IterableExtensions.size(Iterables.<ComplexGUIBranchPort>filter(ports, ComplexGUIBranchPort.class));
      Object _xifexpression = null;
      if ((complexSize == 0)) {
        _xifexpression = null;
      } else {
        final Function1<ComplexGUIBranchPort, String> _function = new Function1<ComplexGUIBranchPort, String>() {
          @Override
          public String apply(final ComplexGUIBranchPort it) {
            return it.getName();
          }
        };
        Set<Map.Entry<String, List<ComplexGUIBranchPort>>> _entrySet = IterableExtensions.<String, ComplexGUIBranchPort>groupBy(Iterables.<ComplexGUIBranchPort>filter(ports, ComplexGUIBranchPort.class), _function).entrySet();
        for (final Map.Entry<String, List<ComplexGUIBranchPort>> group : _entrySet) {
          {
            final Function1<ComplexGUIBranchPort, Type> _function_1 = new Function1<ComplexGUIBranchPort, Type>() {
              @Override
              public Type apply(final ComplexGUIBranchPort it) {
                return it.getType();
              }
            };
            final List<Type> equallyNamedPorts = ListExtensions.<ComplexGUIBranchPort, Type>map(group.getValue(), _function_1);
            final Function1<Type, Seq<Type>> _function_2 = new Function1<Type, Seq<Type>>() {
              @Override
              public Seq<Type> apply(final Type it) {
                return UniqueNamesCheck.this._dataExtension.getSuperTypes(it);
              }
            };
            final List<Seq<Type>> superTypes = ListExtensions.<Type, Seq<Type>>map(equallyNamedPorts, _function_2);
            boolean found = true;
            for (final Type type : equallyNamedPorts) {
              Seq<Type> _superTypes = this._dataExtension.getSuperTypes(type);
              for (final Type suTypes : _superTypes) {
                {
                  final Function1<Type, List<Seq<Type>>> _function_3 = new Function1<Type, List<Seq<Type>>>() {
                    @Override
                    public List<Seq<Type>> apply(final Type it) {
                      return superTypes;
                    }
                  };
                  final Function1<List<Seq<Type>>, Boolean> _function_4 = new Function1<List<Seq<Type>>, Boolean>() {
                    @Override
                    public Boolean apply(final List<Seq<Type>> n) {
                      return Boolean.valueOf(n.contains(suTypes));
                    }
                  };
                  final int size = IterableExtensions.size(IterableExtensions.<List<Seq<Type>>>filter(ListExtensions.<Type, List<Seq<Type>>>map(equallyNamedPorts, _function_3), _function_4));
                  if ((size != 0)) {
                    found = true;
                  }
                }
              }
            }
            if ((!found)) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("The port ");
              _builder.append(portName);
              _builder.append(" of branch ");
              _builder.append(branchName);
              _builder.append(" is not always same complex type");
              this.addError(this.model, _builder.toString());
            }
            final Function1<ComplexGUIBranchPort, Boolean> _function_3 = new Function1<ComplexGUIBranchPort, Boolean>() {
              @Override
              public Boolean apply(final ComplexGUIBranchPort it) {
                return Boolean.valueOf(it.isList());
              }
            };
            int _size = IterableExtensions.<Boolean>toSet(ListExtensions.<ComplexGUIBranchPort, Boolean>map(group.getValue(), _function_3)).size();
            boolean _notEquals = (_size != 1);
            if (_notEquals) {
              StringConcatenation _builder_1 = new StringConcatenation();
              _builder_1.append("The port ");
              _builder_1.append(portName);
              _builder_1.append(" of branch ");
              _builder_1.append(branchName);
              _builder_1.append(" is not always same list status");
              this.addError(this.model, _builder_1.toString());
            }
          }
        }
      }
      _xblockexpression = _xifexpression;
    }
    return _xblockexpression;
  }
  
  protected void _check(final PrimitiveVariable it) {
    boolean _add = this.contextVarNames.add(it.getName());
    boolean _not = (!_add);
    if (_not) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Name \'");
      String _name = it.getName();
      _builder.append(_name);
      _builder.append("\' is not unique");
      this.addError(it, _builder.toString());
    }
  }
  
  protected void _check(final ComplexVariable it) {
    if (((it.<ComplexAttributeConnector>getIncoming(ComplexAttributeConnector.class).isEmpty() && it.<ComplexListAttributeConnector>getIncoming(ComplexListAttributeConnector.class).isEmpty()) && (!this.contextVarNames.add(it.getName())))) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Name \'");
      String _name = it.getName();
      _builder.append(_name);
      _builder.append("\' is not unique");
      this.addError(it, _builder.toString());
    }
  }
  
  protected void _check(final Placeholder it) {
    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getName());
    if (_isNullOrEmpty) {
      this.addError(it, "Name must not be empty");
    } else {
      boolean _add = this.placeholderNames.add(it.getName());
      boolean _not = (!_add);
      if (_not) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Name \'");
        String _name = it.getName();
        _builder.append(_name);
        _builder.append("\' is not unique");
        this.addError(it, _builder.toString());
      }
    }
  }
  
  private <T extends Object, U extends Object> boolean containsDuplicatesByKey(final Iterable<T> iterable, final Function1<? super T, ? extends U> keyExtractor) {
    boolean _isEmpty = this._collectionExtension.<T, U>duplicatesByKey(iterable, keyExtractor).isEmpty();
    return (!_isEmpty);
  }
  
  public void check(final ModelElement it) {
    if (it instanceof Button) {
      _check((Button)it);
      return;
    } else if (it instanceof Placeholder) {
      _check((Placeholder)it);
      return;
    } else if (it instanceof ComplexVariable) {
      _check((ComplexVariable)it);
      return;
    } else if (it instanceof FOR) {
      _check((FOR)it);
      return;
    } else if (it instanceof PrimitiveVariable) {
      _check((PrimitiveVariable)it);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(it).toString());
    }
  }
}
