/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.checks;

import com.google.common.collect.Iterables;
import info.scce.dime.checks.AbstractCheck;
import info.scce.dime.gui.gui.ButtonGroup;
import info.scce.dime.gui.gui.Iteration;
import info.scce.dime.gui.gui.Tab;
import info.scce.dime.gui.gui.Tabbing;
import info.scce.dime.gui.mcam.adapter.GUIAdapter;
import info.scce.dime.gui.mcam.adapter.GUIId;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * The event check is used to validate the event listeners
 * of all listener contexts of a GUI model
 * @author zweihoff
 */
@SuppressWarnings("all")
public class TabbingCheck extends AbstractCheck<GUIId, GUIAdapter> {
  private GUIAdapter adapter;
  
  /**
   * Checks, if the events in given GUI model
   * are valid.
   */
  @Override
  public void doExecute(final GUIAdapter arg0) {
    this.adapter = arg0;
    List<GUIId> _entityIds = this.adapter.getEntityIds();
    for (final GUIId id : _entityIds) {
      {
        Object obj = id.getElement();
        if ((obj instanceof Tabbing)) {
          final Function1<Tab, Boolean> _function = new Function1<Tab, Boolean>() {
            @Override
            public Boolean apply(final Tab n) {
              boolean _isEmpty = n.getPlaceholders().isEmpty();
              return Boolean.valueOf((!_isEmpty));
            }
          };
          final Function1<Tab, Boolean> _function_1 = new Function1<Tab, Boolean>() {
            @Override
            public Boolean apply(final Tab it) {
              return Boolean.valueOf(it.getButtonGroups().isEmpty());
            }
          };
          final Consumer<Tab> _function_2 = new Consumer<Tab>() {
            @Override
            public void accept(final Tab it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("A button group has to be provided");
              TabbingCheck.this.addError(id, _builder.toString());
            }
          };
          IterableExtensions.<Tab>filter(IterableExtensions.<Tab>filter(((Tabbing)obj).getTabs(), _function), _function_1).forEach(_function_2);
          final Function1<Tab, Boolean> _function_3 = new Function1<Tab, Boolean>() {
            @Override
            public Boolean apply(final Tab n) {
              boolean _isEmpty = n.getPlaceholders().isEmpty();
              return Boolean.valueOf((!_isEmpty));
            }
          };
          final Function1<Tab, EList<ButtonGroup>> _function_4 = new Function1<Tab, EList<ButtonGroup>>() {
            @Override
            public EList<ButtonGroup> apply(final Tab it) {
              return it.getButtonGroups();
            }
          };
          final Function1<ButtonGroup, Boolean> _function_5 = new Function1<ButtonGroup, Boolean>() {
            @Override
            public Boolean apply(final ButtonGroup it) {
              return Boolean.valueOf(it.getButtons().isEmpty());
            }
          };
          final Consumer<ButtonGroup> _function_6 = new Consumer<ButtonGroup>() {
            @Override
            public void accept(final ButtonGroup it) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("At least one button has to be provided");
              TabbingCheck.this.addError(id, _builder.toString());
            }
          };
          IterableExtensions.<ButtonGroup>filter(Iterables.<ButtonGroup>concat(IterableExtensions.<Tab, EList<ButtonGroup>>map(IterableExtensions.<Tab>filter(((Tabbing)obj).getTabs(), _function_3), _function_4)), _function_5).forEach(_function_6);
          final Function1<Tab, Boolean> _function_7 = new Function1<Tab, Boolean>() {
            @Override
            public Boolean apply(final Tab n) {
              boolean _isEmpty = n.getPlaceholders().isEmpty();
              return Boolean.valueOf((!_isEmpty));
            }
          };
          boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.<Tab>filter(((Tabbing)obj).getTabs(), _function_7));
          boolean _not = (!_isEmpty);
          if (_not) {
            final Function1<Tab, Boolean> _function_8 = new Function1<Tab, Boolean>() {
              @Override
              public Boolean apply(final Tab it) {
                return Boolean.valueOf(it.isDefault());
              }
            };
            final Consumer<Tab> _function_9 = new Consumer<Tab>() {
              @Override
              public void accept(final Tab n) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Default tab ");
                String _label = n.getLabel();
                _builder.append(_label);
                _builder.append(" is ignored in major/minor tabbing");
                TabbingCheck.this.addWarning(id, _builder.toString());
              }
            };
            IterableExtensions.<Tab>filter(((Tabbing)obj).getTabs(), _function_8).forEach(_function_9);
          } else {
            final Function1<Tab, Boolean> _function_10 = new Function1<Tab, Boolean>() {
              @Override
              public Boolean apply(final Tab it) {
                return Boolean.valueOf(it.isDefault());
              }
            };
            final Function1<Tab, Boolean> _function_11 = new Function1<Tab, Boolean>() {
              @Override
              public Boolean apply(final Tab it) {
                boolean _isEmpty = it.<Iteration>getIncoming(Iteration.class).isEmpty();
                return Boolean.valueOf((!_isEmpty));
              }
            };
            final Consumer<Tab> _function_12 = new Consumer<Tab>() {
              @Override
              public void accept(final Tab n) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("Looped tab ");
                String _label = n.getLabel();
                _builder.append(_label);
                _builder.append(" can not be default");
                TabbingCheck.this.addError(id, _builder.toString());
              }
            };
            IterableExtensions.<Tab>filter(IterableExtensions.<Tab>filter(((Tabbing)obj).getTabs(), _function_10), _function_11).forEach(_function_12);
          }
        }
      }
    }
  }
  
  @Override
  public void init() {
  }
}
