/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.checks;

import com.google.common.collect.Iterables;
import graphmodel.Node;
import info.scce.dime.checks.GUICheck;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.FOR;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.IF;
import info.scce.dime.gui.gui.IS;
import info.scce.dime.gui.gui.Iteration;
import info.scce.dime.gui.gui.MovableContainer;
import info.scce.dime.gui.gui.PrimitiveAttribute;
import info.scce.dime.gui.gui.Variable;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class StructuralDirectiveCheck extends GUICheck {
  @Override
  public void check(final GUI it) {
    final Function1<MovableContainer, Boolean> _function = new Function1<MovableContainer, Boolean>() {
      @Override
      public Boolean apply(final MovableContainer it) {
        return Boolean.valueOf(((!it.<FOR>getIncoming(FOR.class).isEmpty()) && (!it.<IF>getIncoming(IF.class).isEmpty())));
      }
    };
    final Consumer<MovableContainer> _function_1 = new Consumer<MovableContainer>() {
      @Override
      public void accept(final MovableContainer it) {
        StructuralDirectiveCheck.this.addError(it, "incoming IF and FOR at the same time is not supported");
      }
    };
    IterableExtensions.<MovableContainer>filter(this.guiex.<MovableContainer>find(it, MovableContainer.class), _function).forEach(_function_1);
    final Function1<Iteration, Node> _function_2 = new Function1<Iteration, Node>() {
      @Override
      public Node apply(final Iteration it) {
        return it.getSourceElement();
      }
    };
    final Function1<Variable, Boolean> _function_3 = new Function1<Variable, Boolean>() {
      @Override
      public Boolean apply(final Variable it) {
        boolean _isIsList = it.isIsList();
        return Boolean.valueOf((!_isIsList));
      }
    };
    final Consumer<Variable> _function_4 = new Consumer<Variable>() {
      @Override
      public void accept(final Variable it) {
        StructuralDirectiveCheck.this.addError(it, "Iteration can only be performed on a list");
      }
    };
    IterableExtensions.<Variable>filter(Iterables.<Variable>filter(ListExtensions.<Iteration, Node>map(this.guiex.<Iteration>find(it, Iteration.class), _function_2), Variable.class), _function_3).forEach(_function_4);
    final Function1<Iteration, Node> _function_5 = new Function1<Iteration, Node>() {
      @Override
      public Node apply(final Iteration it) {
        return it.getSourceElement();
      }
    };
    final Function1<ComplexAttribute, Boolean> _function_6 = new Function1<ComplexAttribute, Boolean>() {
      @Override
      public Boolean apply(final ComplexAttribute it) {
        boolean _isIsList = it.getAttribute().isIsList();
        return Boolean.valueOf((!_isIsList));
      }
    };
    final Consumer<ComplexAttribute> _function_7 = new Consumer<ComplexAttribute>() {
      @Override
      public void accept(final ComplexAttribute it) {
        StructuralDirectiveCheck.this.addError(it, "Iteration can only be performed on a list");
      }
    };
    IterableExtensions.<ComplexAttribute>filter(Iterables.<ComplexAttribute>filter(ListExtensions.<Iteration, Node>map(this.guiex.<Iteration>find(it, Iteration.class), _function_5), ComplexAttribute.class), _function_6).forEach(_function_7);
    final Function1<Iteration, Node> _function_8 = new Function1<Iteration, Node>() {
      @Override
      public Node apply(final Iteration it) {
        return it.getSourceElement();
      }
    };
    final Function1<PrimitiveAttribute, Boolean> _function_9 = new Function1<PrimitiveAttribute, Boolean>() {
      @Override
      public Boolean apply(final PrimitiveAttribute it) {
        boolean _isIsList = it.getAttribute().isIsList();
        return Boolean.valueOf((!_isIsList));
      }
    };
    final Consumer<PrimitiveAttribute> _function_10 = new Consumer<PrimitiveAttribute>() {
      @Override
      public void accept(final PrimitiveAttribute it) {
        StructuralDirectiveCheck.this.addError(it, "Iteration can only be performed on a list");
      }
    };
    IterableExtensions.<PrimitiveAttribute>filter(Iterables.<PrimitiveAttribute>filter(ListExtensions.<Iteration, Node>map(this.guiex.<Iteration>find(it, Iteration.class), _function_8), PrimitiveAttribute.class), _function_9).forEach(_function_10);
    final Function1<IS, Boolean> _function_11 = new Function1<IS, Boolean>() {
      @Override
      public Boolean apply(final IS it) {
        return Boolean.valueOf(StringExtensions.isNullOrEmpty(it.getMatchingType()));
      }
    };
    final Consumer<IS> _function_12 = new Consumer<IS>() {
      @Override
      public void accept(final IS it) {
        StructuralDirectiveCheck.this.addError(it, "IS edge matching type is not specified");
      }
    };
    IterableExtensions.<IS>filter(this.guiex.<IS>find(it, IS.class), _function_11).forEach(_function_12);
  }
}
