/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.checks;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.data.data.PrimitiveType;
import info.scce.dime.data.data.Type;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.gUIPlugin.AbstractParameter;
import info.scce.dime.gUIPlugin.ComplexInputParameter;
import info.scce.dime.gUIPlugin.ComplexParameter;
import info.scce.dime.gUIPlugin.GenericInputParameter;
import info.scce.dime.gUIPlugin.GenericParameter;
import info.scce.dime.gUIPlugin.Output;
import info.scce.dime.gUIPlugin.Placeholders;
import info.scce.dime.gUIPlugin.Plugin;
import info.scce.dime.gUIPlugin.PrimitiveInputParameter;
import info.scce.dime.gUIPlugin.PrimitiveParameter;
import info.scce.dime.gUIPlugin.Template;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.Attribute;
import info.scce.dime.gui.gui.BooleanInputStatic;
import info.scce.dime.gui.gui.Branch;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.ComplexExtensionAttribute;
import info.scce.dime.gui.gui.ComplexInputPort;
import info.scce.dime.gui.gui.ComplexOutputPort;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.DataContext;
import info.scce.dime.gui.gui.DispatchedGUISIB;
import info.scce.dime.gui.gui.Event;
import info.scce.dime.gui.gui.EventListener;
import info.scce.dime.gui.gui.ExtensionContext;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GUIPlugin;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.IO;
import info.scce.dime.gui.gui.InputPort;
import info.scce.dime.gui.gui.InputStatic;
import info.scce.dime.gui.gui.IntegerInputStatic;
import info.scce.dime.gui.gui.ListenerContext;
import info.scce.dime.gui.gui.OutputPort;
import info.scce.dime.gui.gui.Placeholder;
import info.scce.dime.gui.gui.PrimitiveAttribute;
import info.scce.dime.gui.gui.PrimitiveExtensionAttribute;
import info.scce.dime.gui.gui.PrimitiveInputPort;
import info.scce.dime.gui.gui.PrimitiveListAttribute;
import info.scce.dime.gui.gui.PrimitiveListAttributeName;
import info.scce.dime.gui.gui.PrimitiveOutputPort;
import info.scce.dime.gui.gui.PrimitiveVariable;
import info.scce.dime.gui.gui.Read;
import info.scce.dime.gui.gui.RealInputStatic;
import info.scce.dime.gui.gui.Registration;
import info.scce.dime.gui.gui.TextInputStatic;
import info.scce.dime.gui.gui.TimestampInputStatic;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.GUIExtension;
import info.scce.dime.gui.helper.GUIExtensionProvider;
import info.scce.dime.gui.mcam.adapter.GUIId;
import info.scce.dime.gui.mcam.modules.checks.GUICheck;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;

/**
 * The GUI SIB check is used to validate GUI SIBs and GUI plug in SIBs
 * placed in a GUI model
 * 
 * @author zweihoff
 * @author neubauer
 */
@SuppressWarnings("all")
public class GUISIBCheck extends GUICheck {
  @Extension
  protected GUIExtension guiex;
  
  @Extension
  protected DataExtension _dataExtension = DataExtension.getInstance();
  
  @Override
  public void init() {
    this.guiex = GUIExtensionProvider.guiextension();
  }
  
  private void _doCheck(final EObject it) {
  }
  
  private CharSequence ambiguousMsg(final List<GUI> matchingGUIs) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("Dispatching might be ambiguous for the following sub GUIs: ");
    {
      boolean _hasElements = false;
      for(final GUI it : matchingGUIs) {
        if (!_hasElements) {
          _hasElements = true;
        } else {
          _builder.appendImmediate(", ", "");
        }
        String _title = it.getTitle();
        _builder.append(_title);
      }
    }
    _builder.append(".");
    return _builder;
  }
  
  private void addError(final IdentifiableElement element, final CharSequence msg) {
    this.addError(element, msg.toString());
  }
  
  /**
   * Checks, if all GUI SIBs and GUI plug in SIBs in the given
   * GUI model are valid
   */
  @Override
  public void check(final GUI model) {
    final Function1<GUIId, IdentifiableElement> _function = new Function1<GUIId, IdentifiableElement>() {
      @Override
      public IdentifiableElement apply(final GUIId it) {
        return it.getElement();
      }
    };
    final Consumer<IdentifiableElement> _function_1 = new Consumer<IdentifiableElement>() {
      @Override
      public void accept(final IdentifiableElement it) {
        GUISIBCheck.this.doCheck(it);
      }
    };
    ListExtensions.<GUIId, IdentifiableElement>map(this.adapter.getEntityIds(), _function).forEach(_function_1);
  }
  
  private void checkListener(final List<EventListener> listener, final IdentifiableElement te) {
    final Function1<EventListener, Boolean> _function = new Function1<EventListener, Boolean>() {
      @Override
      public Boolean apply(final EventListener it) {
        boolean _isEmpty = it.<Registration>getIncoming(Registration.class).isEmpty();
        return Boolean.valueOf((!_isEmpty));
      }
    };
    final Consumer<EventListener> _function_1 = new Consumer<EventListener>() {
      @Override
      public void accept(final EventListener it) {
        GUISIBCheck.this.checkPortsConnected(it, te);
      }
    };
    IterableExtensions.<EventListener>filter(listener, _function).forEach(_function_1);
    final Function1<EventListener, Boolean> _function_2 = new Function1<EventListener, Boolean>() {
      @Override
      public Boolean apply(final EventListener it) {
        return Boolean.valueOf(it.<Registration>getIncoming(Registration.class).isEmpty());
      }
    };
    final Function1<EventListener, Boolean> _function_3 = new Function1<EventListener, Boolean>() {
      @Override
      public Boolean apply(final EventListener it) {
        final Function1<IO, Boolean> _function = new Function1<IO, Boolean>() {
          @Override
          public Boolean apply(final IO it) {
            boolean _isEmpty = it.getIncoming().isEmpty();
            return Boolean.valueOf((!_isEmpty));
          }
        };
        return Boolean.valueOf(IterableExtensions.<IO>exists(it.getIOs(), _function));
      }
    };
    final Consumer<EventListener> _function_4 = new Consumer<EventListener>() {
      @Override
      public void accept(final EventListener n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("data is never send");
        GUISIBCheck.this.addWarning(te, _builder.toString());
      }
    };
    IterableExtensions.<EventListener>filter(IterableExtensions.<EventListener>filter(listener, _function_2), _function_3).forEach(_function_4);
  }
  
  private Object checkPortsConnected(final EventListener el, final IdentifiableElement te) {
    return null;
  }
  
  private void checkGUIPluginListeners(final EList<EventListener> listeners, final EList<info.scce.dime.gUIPlugin.EventListener> events, final GUIPlugin te) {
    final Function1<info.scce.dime.gUIPlugin.EventListener, Boolean> _function = new Function1<info.scce.dime.gUIPlugin.EventListener, Boolean>() {
      @Override
      public Boolean apply(final info.scce.dime.gUIPlugin.EventListener it) {
        final Function1<EventListener, String> _function = new Function1<EventListener, String>() {
          @Override
          public String apply(final EventListener it) {
            return it.getName();
          }
        };
        boolean _contains = ListExtensions.<EventListener, String>map(listeners, _function).contains(it.getName());
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<info.scce.dime.gUIPlugin.EventListener> _function_1 = new Consumer<info.scce.dime.gUIPlugin.EventListener>() {
      @Override
      public void accept(final info.scce.dime.gUIPlugin.EventListener n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("missing event listener ");
        String _name = n.getName();
        _builder.append(_name);
        GUISIBCheck.this.addError(te, _builder.toString());
      }
    };
    IterableExtensions.<info.scce.dime.gUIPlugin.EventListener>filter(events, _function).forEach(_function_1);
    final Function1<EventListener, Boolean> _function_2 = new Function1<EventListener, Boolean>() {
      @Override
      public Boolean apply(final EventListener it) {
        final Function1<info.scce.dime.gUIPlugin.EventListener, String> _function = new Function1<info.scce.dime.gUIPlugin.EventListener, String>() {
          @Override
          public String apply(final info.scce.dime.gUIPlugin.EventListener it) {
            return it.getName();
          }
        };
        boolean _contains = ListExtensions.<info.scce.dime.gUIPlugin.EventListener, String>map(events, _function).contains(it.getName());
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<EventListener> _function_3 = new Consumer<EventListener>() {
      @Override
      public void accept(final EventListener n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("unkown event listener ");
        String _name = n.getName();
        _builder.append(_name);
        GUISIBCheck.this.addError(te, _builder.toString());
      }
    };
    IterableExtensions.<EventListener>filter(listeners, _function_2).forEach(_function_3);
    final Function1<EventListener, info.scce.dime.gUIPlugin.EventListener> _function_4 = new Function1<EventListener, info.scce.dime.gUIPlugin.EventListener>() {
      @Override
      public info.scce.dime.gUIPlugin.EventListener apply(final EventListener n) {
        final Function1<info.scce.dime.gUIPlugin.EventListener, Boolean> _function = new Function1<info.scce.dime.gUIPlugin.EventListener, Boolean>() {
          @Override
          public Boolean apply(final info.scce.dime.gUIPlugin.EventListener it) {
            return Boolean.valueOf(it.getName().equals(n.getName()));
          }
        };
        return IterableExtensions.<info.scce.dime.gUIPlugin.EventListener>findFirst(events, _function);
      }
    };
    Set<Map.Entry<info.scce.dime.gUIPlugin.EventListener, List<EventListener>>> _entrySet = IterableExtensions.<info.scce.dime.gUIPlugin.EventListener, EventListener>groupBy(listeners, _function_4).entrySet();
    for (final Map.Entry<info.scce.dime.gUIPlugin.EventListener, List<EventListener>> tuple : _entrySet) {
      {
        final info.scce.dime.gUIPlugin.EventListener evt = tuple.getKey();
        final EventListener listener = tuple.getValue().get(0);
        final Function1<AbstractParameter, Boolean> _function_5 = new Function1<AbstractParameter, Boolean>() {
          @Override
          public Boolean apply(final AbstractParameter it) {
            final Function1<IO, String> _function = new Function1<IO, String>() {
              @Override
              public String apply(final IO it) {
                return it.getName();
              }
            };
            boolean _contains = ListExtensions.<IO, String>map(listener.getIOs(), _function).contains(it.getName());
            return Boolean.valueOf((!_contains));
          }
        };
        final Consumer<AbstractParameter> _function_6 = new Consumer<AbstractParameter>() {
          @Override
          public void accept(final AbstractParameter n) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("missing port ");
            String _name = n.getName();
            _builder.append(_name);
            GUISIBCheck.this.addError(te, _builder.toString());
          }
        };
        IterableExtensions.<AbstractParameter>filter(evt.getParameters(), _function_5).forEach(_function_6);
        final Function1<IO, Boolean> _function_7 = new Function1<IO, Boolean>() {
          @Override
          public Boolean apply(final IO it) {
            final Function1<AbstractParameter, String> _function = new Function1<AbstractParameter, String>() {
              @Override
              public String apply(final AbstractParameter it) {
                return it.getName();
              }
            };
            boolean _contains = ListExtensions.<AbstractParameter, String>map(evt.getParameters(), _function).contains(it.getName());
            return Boolean.valueOf((!_contains));
          }
        };
        final Consumer<IO> _function_8 = new Consumer<IO>() {
          @Override
          public void accept(final IO n) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("unkown port ");
            String _name = n.getName();
            _builder.append(_name);
            GUISIBCheck.this.addError(te, _builder.toString());
          }
        };
        IterableExtensions.<IO>filter(listener.getIOs(), _function_7).forEach(_function_8);
        final Function1<IO, AbstractParameter> _function_9 = new Function1<IO, AbstractParameter>() {
          @Override
          public AbstractParameter apply(final IO n) {
            final Function1<AbstractParameter, Boolean> _function = new Function1<AbstractParameter, Boolean>() {
              @Override
              public Boolean apply(final AbstractParameter it) {
                return Boolean.valueOf(it.getName().equals(n.getName()));
              }
            };
            return IterableExtensions.<AbstractParameter>findFirst(evt.getParameters(), _function);
          }
        };
        final Function1<Map.Entry<AbstractParameter, List<IO>>, Boolean> _function_10 = new Function1<Map.Entry<AbstractParameter, List<IO>>, Boolean>() {
          @Override
          public Boolean apply(final Map.Entry<AbstractParameter, List<IO>> it) {
            AbstractParameter _key = it.getKey();
            return Boolean.valueOf((!Objects.equal(_key, null)));
          }
        };
        Iterable<Map.Entry<AbstractParameter, List<IO>>> _filter = IterableExtensions.<Map.Entry<AbstractParameter, List<IO>>>filter(IterableExtensions.<AbstractParameter, IO>groupBy(listener.getIOs(), _function_9).entrySet(), _function_10);
        for (final Map.Entry<AbstractParameter, List<IO>> portTupel : _filter) {
          {
            final AbstractParameter evtPort = portTupel.getKey();
            final IO listPort = portTupel.getValue().get(0);
            if ((listPort instanceof InputPort)) {
              boolean _isIsList = evtPort.isIsList();
              boolean _isIsList_1 = ((InputPort)listPort).isIsList();
              boolean _notEquals = (_isIsList != _isIsList_1);
              if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("wrong list status ");
                String _name = ((InputPort)listPort).getName();
                _builder.append(_name);
                this.addError(te, _builder.toString());
              }
            }
            if ((listPort instanceof ComplexInputPort)) {
              if ((evtPort instanceof ComplexParameter)) {
                EObject _type = ((ComplexParameter) evtPort).getType();
                String _name_1 = null;
                if (((Type) _type)!=null) {
                  _name_1=((Type) _type).getName();
                }
                final String typeName = _name_1;
                final Type dataType = ((ComplexInputPort) listPort).getDataType();
                if (((!Objects.equal(dataType.getName(), typeName)) && (!this._dataExtension.getSuperTypes(dataType).<String>map(new Function<Type, String>() {
                  @Override
                  public String apply(final Type it) {
                    return it.getName();
                  }
                }).contains(typeName)))) {
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append("incompatible complex types ");
                  String _name_2 = ((ComplexInputPort)listPort).getName();
                  _builder_1.append(_name_2);
                  this.addError(te, _builder_1.toString());
                }
              } else {
                if ((evtPort instanceof GenericParameter)) {
                } else {
                  StringConcatenation _builder_2 = new StringConcatenation();
                  String _name_3 = ((ComplexInputPort)listPort).getName();
                  _builder_2.append(_name_3);
                  _builder_2.append(" has to be complex");
                  this.addError(te, _builder_2.toString());
                }
              }
            }
            if (((listPort instanceof PrimitiveInputPort) && (!(listPort instanceof InputStatic)))) {
              if ((evtPort instanceof PrimitiveParameter)) {
                PrimitiveType _data = this.guiex.toData(((PrimitiveParameter)evtPort).getType());
                PrimitiveType _data_1 = this._dataExtension.toData(((PrimitiveInputPort) listPort).getDataType());
                boolean _notEquals_1 = (!Objects.equal(_data, _data_1));
                if (_notEquals_1) {
                  StringConcatenation _builder_3 = new StringConcatenation();
                  _builder_3.append("incompatible primitive types ");
                  String _name_4 = listPort.getName();
                  _builder_3.append(_name_4);
                  this.addError(te, _builder_3.toString());
                }
              } else {
                StringConcatenation _builder_4 = new StringConcatenation();
                String _name_5 = listPort.getName();
                _builder_4.append(_name_5);
                _builder_4.append(" has to be primitive");
                this.addError(te, _builder_4.toString());
              }
            }
          }
        }
      }
    }
  }
  
  public void checkGUISIBListeners(final List<EventListener> listeners, final List<Event> events, final GUISIB te) {
    final Function1<Event, Boolean> _function = new Function1<Event, Boolean>() {
      @Override
      public Boolean apply(final Event it) {
        final Function1<EventListener, String> _function = new Function1<EventListener, String>() {
          @Override
          public String apply(final EventListener it) {
            return it.getName();
          }
        };
        boolean _contains = ListExtensions.<EventListener, String>map(listeners, _function).contains(it.getName());
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<Event> _function_1 = new Consumer<Event>() {
      @Override
      public void accept(final Event n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("missing event listener ");
        String _name = n.getName();
        _builder.append(_name);
        GUISIBCheck.this.addError(te, _builder.toString());
      }
    };
    IterableExtensions.<Event>filter(events, _function).forEach(_function_1);
    final Function1<EventListener, Boolean> _function_2 = new Function1<EventListener, Boolean>() {
      @Override
      public Boolean apply(final EventListener it) {
        final Function1<Event, String> _function = new Function1<Event, String>() {
          @Override
          public String apply(final Event it) {
            return it.getName();
          }
        };
        boolean _contains = ListExtensions.<Event, String>map(events, _function).contains(it.getName());
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<EventListener> _function_3 = new Consumer<EventListener>() {
      @Override
      public void accept(final EventListener n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("unkown event listener ");
        String _name = n.getName();
        _builder.append(_name);
        GUISIBCheck.this.addError(te, _builder.toString());
      }
    };
    IterableExtensions.<EventListener>filter(listeners, _function_2).forEach(_function_3);
    final Function1<EventListener, Event> _function_4 = new Function1<EventListener, Event>() {
      @Override
      public Event apply(final EventListener n) {
        final Function1<Event, Boolean> _function = new Function1<Event, Boolean>() {
          @Override
          public Boolean apply(final Event it) {
            return Boolean.valueOf(it.getName().equals(n.getName()));
          }
        };
        return IterableExtensions.<Event>findFirst(events, _function);
      }
    };
    final Function1<Map.Entry<Event, List<EventListener>>, Boolean> _function_5 = new Function1<Map.Entry<Event, List<EventListener>>, Boolean>() {
      @Override
      public Boolean apply(final Map.Entry<Event, List<EventListener>> it) {
        Event _key = it.getKey();
        return Boolean.valueOf(GUISIBCheck.this.guiex.operator_notEquals(_key, null));
      }
    };
    Iterable<Map.Entry<Event, List<EventListener>>> _filter = IterableExtensions.<Map.Entry<Event, List<EventListener>>>filter(IterableExtensions.<Event, EventListener>groupBy(listeners, _function_4).entrySet(), _function_5);
    for (final Map.Entry<Event, List<EventListener>> tuple : _filter) {
      {
        final Event evt = tuple.getKey();
        final EventListener listener = tuple.getValue().get(0);
        final Function1<OutputPort, Boolean> _function_6 = new Function1<OutputPort, Boolean>() {
          @Override
          public Boolean apply(final OutputPort it) {
            final Function1<IO, String> _function = new Function1<IO, String>() {
              @Override
              public String apply(final IO it) {
                return it.getName();
              }
            };
            boolean _contains = ListExtensions.<IO, String>map(listener.getIOs(), _function).contains(it.getName());
            return Boolean.valueOf((!_contains));
          }
        };
        final Consumer<OutputPort> _function_7 = new Consumer<OutputPort>() {
          @Override
          public void accept(final OutputPort n) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("missing port ");
            String _name = n.getName();
            _builder.append(_name);
            GUISIBCheck.this.addError(te, _builder.toString());
          }
        };
        IterableExtensions.<OutputPort>filter(evt.getOutputPorts(), _function_6).forEach(_function_7);
        final Function1<IO, Boolean> _function_8 = new Function1<IO, Boolean>() {
          @Override
          public Boolean apply(final IO it) {
            final Function1<OutputPort, String> _function = new Function1<OutputPort, String>() {
              @Override
              public String apply(final OutputPort it) {
                return it.getName();
              }
            };
            boolean _contains = ListExtensions.<OutputPort, String>map(evt.getOutputPorts(), _function).contains(it.getName());
            return Boolean.valueOf((!_contains));
          }
        };
        final Consumer<IO> _function_9 = new Consumer<IO>() {
          @Override
          public void accept(final IO n) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("unkown port ");
            String _name = n.getName();
            _builder.append(_name);
            GUISIBCheck.this.addError(te, _builder.toString());
          }
        };
        IterableExtensions.<IO>filter(listener.getIOs(), _function_8).forEach(_function_9);
        final Function1<IO, OutputPort> _function_10 = new Function1<IO, OutputPort>() {
          @Override
          public OutputPort apply(final IO n) {
            final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
              @Override
              public Boolean apply(final OutputPort it) {
                return Boolean.valueOf(it.getName().equals(n.getName()));
              }
            };
            return IterableExtensions.<OutputPort>findFirst(evt.getOutputPorts(), _function);
          }
        };
        Set<Map.Entry<OutputPort, List<IO>>> _entrySet = IterableExtensions.<OutputPort, IO>groupBy(listener.getIOs(), _function_10).entrySet();
        for (final Map.Entry<OutputPort, List<IO>> portTupel : _entrySet) {
          {
            final OutputPort evtPort = portTupel.getKey();
            final IO listPort = portTupel.getValue().get(0);
            if ((listPort instanceof InputPort)) {
              boolean _isIsList = evtPort.isIsList();
              boolean _isIsList_1 = ((InputPort)listPort).isIsList();
              boolean _notEquals = (_isIsList != _isIsList_1);
              if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("wrong list status ");
                String _name = ((InputPort)listPort).getName();
                _builder.append(_name);
                this.addError(te, _builder.toString());
              }
            }
            if ((evtPort instanceof ComplexOutputPort)) {
              if ((listPort instanceof ComplexInputPort)) {
                if (((!this._dataExtension.getSuperTypes(((ComplexInputPort) listPort).getDataType()).contains(((ComplexOutputPort) evtPort).getDataType())) && (!((ComplexInputPort) listPort).getDataType().equals(((ComplexOutputPort) evtPort).getDataType())))) {
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append("incompatible complex types ");
                  String _name_1 = ((ComplexInputPort)listPort).getName();
                  _builder_1.append(_name_1);
                  this.addError(te, _builder_1.toString());
                }
              } else {
                if ((listPort instanceof GenericInputParameter)) {
                } else {
                  StringConcatenation _builder_2 = new StringConcatenation();
                  String _name_2 = listPort.getName();
                  _builder_2.append(_name_2);
                  _builder_2.append(" has to be complex");
                  this.addError(te, _builder_2.toString());
                }
              }
            }
            if (((evtPort instanceof PrimitiveOutputPort) && (!(listPort instanceof InputStatic)))) {
              if ((listPort instanceof PrimitiveInputPort)) {
                info.scce.dime.gui.gui.PrimitiveType _dataType = ((PrimitiveOutputPort) evtPort).getDataType();
                info.scce.dime.gui.gui.PrimitiveType _dataType_1 = ((PrimitiveInputPort) listPort).getDataType();
                boolean _notEquals_1 = (!Objects.equal(_dataType, _dataType_1));
                if (_notEquals_1) {
                  StringConcatenation _builder_3 = new StringConcatenation();
                  _builder_3.append("incompatible primitive types ");
                  String _name_3 = ((PrimitiveInputPort)listPort).getName();
                  _builder_3.append(_name_3);
                  this.addError(te, _builder_3.toString());
                }
              } else {
                StringConcatenation _builder_4 = new StringConcatenation();
                String _name_4 = listPort.getName();
                _builder_4.append(_name_4);
                _builder_4.append(" has to be primitive");
                this.addError(te, _builder_4.toString());
              }
            }
          }
        }
      }
    }
  }
  
  /**
   * TODO JN: why not use post create hook to create a new GUI SIB and check whether result is "the same" as current SIB?
   * 
   * Checks if the input ports, branches and output ports of
   * the given GUI SIB are still in sync with the referenced GUI model
   * @param id
   * @param te
   */
  private void _doCheck(final GUISIB te) {
    ModelElementContainer _container = te.getContainer();
    boolean _not = (!(_container instanceof ExtensionContext));
    if (_not) {
    }
    GUI gui = te.getGui();
    if ((te instanceof DispatchedGUISIB)) {
      final BiConsumer<Integer, List<GUI>> _function = new BiConsumer<Integer, List<GUI>>() {
        @Override
        public void accept(final Integer score, final List<GUI> matchingGUIs) {
          int _size = matchingGUIs.size();
          boolean _greaterThan = (_size > 1);
          if (_greaterThan) {
            GUISIBCheck.this.addWarning(te, GUISIBCheck.this.ambiguousMsg(matchingGUIs).toString());
          }
        }
      };
      this.guiex.getSortedDispatchedGUIs(gui).forEach(_function);
    }
    final Function1<ListenerContext, EList<Event>> _function_1 = new Function1<ListenerContext, EList<Event>>() {
      @Override
      public EList<Event> apply(final ListenerContext it) {
        return it.getEvents();
      }
    };
    this.checkGUISIBListeners(te.getEventListeners(), IterableExtensions.<Event>toList(Iterables.<Event>concat(ListExtensions.<ListenerContext, EList<Event>>map(gui.getListenerContexts(), _function_1))), te);
    this.checkListener(te.getEventListeners(), te);
    final Function1<Placeholder, String> _function_2 = new Function1<Placeholder, String>() {
      @Override
      public String apply(final Placeholder it) {
        return it.getName();
      }
    };
    final List<String> availablePlaceholder = IterableExtensions.<String>toList(ListExtensions.<Placeholder, String>map(this.guiex.<Placeholder>find(gui, Placeholder.class), _function_2));
    final Function1<Argument, String> _function_3 = new Function1<Argument, String>() {
      @Override
      public String apply(final Argument it) {
        return it.getBlockName();
      }
    };
    final List<String> providedArguments = ListExtensions.<Argument, String>map(te.getArguments(), _function_3);
    final Function1<String, Boolean> _function_4 = new Function1<String, Boolean>() {
      @Override
      public Boolean apply(final String n) {
        boolean _contains = providedArguments.contains(n);
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<String> _function_5 = new Consumer<String>() {
      @Override
      public void accept(final String n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Argument for placeholder ");
        _builder.append(n);
        _builder.append(" missing");
        GUISIBCheck.this.addError(te, _builder);
      }
    };
    IterableExtensions.<String>filter(availablePlaceholder, _function_4).forEach(_function_5);
    final Function1<String, Boolean> _function_6 = new Function1<String, Boolean>() {
      @Override
      public Boolean apply(final String n) {
        boolean _contains = availablePlaceholder.contains(n);
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<String> _function_7 = new Consumer<String>() {
      @Override
      public void accept(final String n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("No placeholder for ");
        _builder.append(n);
        _builder.append(" available");
        GUISIBCheck.this.addError(te, _builder);
      }
    };
    IterableExtensions.<String>filter(providedArguments, _function_6).forEach(_function_7);
    boolean _equals = gui.getTitle().equals(te.getLabel());
    boolean _not_1 = (!_equals);
    if (_not_1) {
      this.addError(te, "gui sib name is outdated");
    }
    EList<InputPort> _inputPorts = te.getInputPorts();
    for (final InputPort ip : _inputPorts) {
      {
        boolean isPortFound = false;
        final Function<DataContext, Stream<Variable>> _function_8 = new Function<DataContext, Stream<Variable>>() {
          @Override
          public Stream<Variable> apply(final DataContext n) {
            return n.getVariables().stream();
          }
        };
        final Predicate<Variable> _function_9 = new Predicate<Variable>() {
          @Override
          public boolean test(final Variable n) {
            return n.isIsInput();
          }
        };
        List<Variable> _collect = gui.getDataContexts().stream().<Variable>flatMap(_function_8).filter(_function_9).collect(Collectors.<Variable>toList());
        for (final Variable var : _collect) {
          boolean _equals_1 = var.getName().equals(ip.getName());
          if (_equals_1) {
            isPortFound = true;
            boolean _isIsList = var.isIsList();
            boolean _isIsList_1 = ip.isIsList();
            boolean _tripleNotEquals = (Boolean.valueOf(_isIsList) != Boolean.valueOf(_isIsList_1));
            if (_tripleNotEquals) {
              StringConcatenation _builder = new StringConcatenation();
              _builder.append("gui sib input port ");
              String _name = ip.getName();
              _builder.append(_name);
              _builder.append(" list state is outdated");
              this.addError(te, _builder.toString());
            }
            if ((var instanceof ComplexVariable)) {
              if ((!(ip instanceof ComplexInputPort))) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("gui sib input port ");
                String _name_1 = ip.getName();
                _builder_1.append(_name_1);
                _builder_1.append(" type is outdated");
                this.addError(te, _builder_1.toString());
              } else {
                ComplexVariable cv = ((ComplexVariable) var);
                ComplexInputPort cip = ((ComplexInputPort) ip);
                boolean _equals_2 = cv.getDataType().equals(cip.getDataType());
                boolean _not_2 = (!_equals_2);
                if (_not_2) {
                  StringConcatenation _builder_2 = new StringConcatenation();
                  _builder_2.append("gui sib input port ");
                  String _name_2 = ip.getName();
                  _builder_2.append(_name_2);
                  _builder_2.append(" data type is outdated");
                  this.addError(te, _builder_2.toString());
                }
              }
            }
            if ((var instanceof PrimitiveVariable)) {
              if ((!(ip instanceof PrimitiveInputPort))) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("gui sib input port ");
                String _name_3 = ip.getName();
                _builder_3.append(_name_3);
                _builder_3.append(" type is outdated");
                this.addError(te, _builder_3.toString());
              } else {
                PrimitiveVariable cv_1 = ((PrimitiveVariable) var);
                PrimitiveInputPort cip_1 = ((PrimitiveInputPort) ip);
                boolean _equals_3 = cv_1.getDataType().equals(cip_1.getDataType());
                boolean _not_3 = (!_equals_3);
                if (_not_3) {
                  StringConcatenation _builder_4 = new StringConcatenation();
                  _builder_4.append("gui sib input port ");
                  String _name_4 = ip.getName();
                  _builder_4.append(_name_4);
                  _builder_4.append(" data type is outdated");
                  this.addError(te, _builder_4.toString());
                }
              }
            }
          }
        }
        ModelElementContainer _container_1 = te.getContainer();
        if ((_container_1 instanceof ExtensionContext)) {
          return;
        }
        boolean _isEmpty = ip.getIncoming().isEmpty();
        if (_isEmpty) {
          StringConcatenation _builder_5 = new StringConcatenation();
          _builder_5.append("gui sib port ");
          String _name_5 = ip.getName();
          _builder_5.append(_name_5);
          _builder_5.append(" is not connected to variable");
          this.addWarning(te, _builder_5.toString());
        } else {
          final Function<Read, Node> _function_10 = new Function<Read, Node>() {
            @Override
            public Node apply(final Read n) {
              return n.getSourceElement();
            }
          };
          List<Node> _collect_1 = ip.<Read>getIncoming(Read.class).stream().<Node>map(_function_10).collect(
            Collectors.<Node>toList());
          for (final Node node : _collect_1) {
            if ((node instanceof Variable)) {
              Variable var_1 = ((Variable) node);
              boolean _isIsList_2 = var_1.isIsList();
              boolean _isIsList_3 = ip.isIsList();
              boolean _tripleNotEquals_1 = (Boolean.valueOf(_isIsList_2) != Boolean.valueOf(_isIsList_3));
              if (_tripleNotEquals_1) {
                StringConcatenation _builder_6 = new StringConcatenation();
                _builder_6.append("gui sib port ");
                String _name_6 = ip.getName();
                _builder_6.append(_name_6);
                _builder_6.append(" is not compatible to variable on list status");
                this.addError(te, 
                  _builder_6.toString());
              }
              if ((var_1 instanceof PrimitiveVariable)) {
                if ((ip instanceof PrimitiveInputPort)) {
                  info.scce.dime.gui.gui.PrimitiveType _dataType = ((PrimitiveVariable) var_1).getDataType();
                  info.scce.dime.gui.gui.PrimitiveType _dataType_1 = ((PrimitiveInputPort) ip).getDataType();
                  boolean _tripleNotEquals_2 = (_dataType != _dataType_1);
                  if (_tripleNotEquals_2) {
                    StringConcatenation _builder_7 = new StringConcatenation();
                    _builder_7.append("gui sib port ");
                    String _name_7 = ((PrimitiveInputPort)ip).getName();
                    _builder_7.append(_name_7);
                    _builder_7.append(" primitive type is not compatible to variable");
                    this.addError(te, _builder_7);
                  }
                } else {
                  StringConcatenation _builder_8 = new StringConcatenation();
                  _builder_8.append("complex gui sib port ");
                  String _name_8 = ip.getName();
                  _builder_8.append(_name_8);
                  _builder_8.append(" is not compatible to primitive variable");
                  this.addError(te, _builder_8);
                }
              } else {
                if ((ip instanceof ComplexInputPort)) {
                  Type _dataType_2 = ((ComplexVariable) var_1).getDataType();
                  Pair<Node, Type> _pair = new Pair<Node, Type>(var_1, _dataType_2);
                  Type _dataType_3 = ((ComplexInputPort) ip).getDataType();
                  Pair<InputPort, Type> _pair_1 = new Pair<InputPort, Type>(ip, _dataType_3);
                  boolean _isSubTypeWithSmartCast = this.guiex.isSubTypeWithSmartCast(_pair, _pair_1);
                  boolean _not_4 = (!_isSubTypeWithSmartCast);
                  if (_not_4) {
                    StringConcatenation _builder_9 = new StringConcatenation();
                    _builder_9.append("gui sib port ");
                    String _name_9 = ((ComplexInputPort)ip).getName();
                    _builder_9.append(_name_9);
                    _builder_9.append(" type is not compatible to variable");
                    this.addError(te, 
                      _builder_9.toString());
                  }
                } else {
                  StringConcatenation _builder_10 = new StringConcatenation();
                  _builder_10.append("primitive gui sib port ");
                  String _name_10 = ip.getName();
                  _builder_10.append(_name_10);
                  _builder_10.append(" is not compatible to complex variable");
                  this.addError(te, 
                    _builder_10.toString());
                }
              }
            } else {
              if ((node instanceof Attribute)) {
                final Attribute attr = ((Attribute) node);
                if ((attr instanceof PrimitiveAttribute)) {
                  boolean _isIsList_4 = ((PrimitiveAttribute) attr).getAttribute().isIsList();
                  boolean _isIsList_5 = ip.isIsList();
                  boolean _tripleNotEquals_3 = (Boolean.valueOf(_isIsList_4) != Boolean.valueOf(_isIsList_5));
                  if (_tripleNotEquals_3) {
                    StringConcatenation _builder_11 = new StringConcatenation();
                    _builder_11.append("gui sib port ");
                    String _name_11 = ip.getName();
                    _builder_11.append(_name_11);
                    _builder_11.append(" is not compatible to attribute on list status");
                    this.addError(te, _builder_11);
                  }
                  if ((ip instanceof PrimitiveInputPort)) {
                    PrimitiveType _dataType_4 = ((PrimitiveAttribute) attr).getAttribute().getDataType();
                    PrimitiveType _data = this._dataExtension.toData(((PrimitiveInputPort) ip).getDataType());
                    boolean _tripleNotEquals_4 = (_dataType_4 != _data);
                    if (_tripleNotEquals_4) {
                      StringConcatenation _builder_12 = new StringConcatenation();
                      _builder_12.append("gui sib port ");
                      String _name_12 = ((PrimitiveInputPort)ip).getName();
                      _builder_12.append(_name_12);
                      _builder_12.append(" primitive type is not compatible to attribute");
                      this.addError(te, _builder_12);
                    }
                  } else {
                    StringConcatenation _builder_13 = new StringConcatenation();
                    _builder_13.append("complex gui sib port ");
                    String _name_13 = ip.getName();
                    _builder_13.append(_name_13);
                    _builder_13.append(" is not compatible to primitive attribute");
                    this.addError(te, 
                      _builder_13.toString());
                  }
                } else {
                  if ((attr instanceof PrimitiveExtensionAttribute)) {
                    boolean _isIsList_6 = ((PrimitiveExtensionAttribute) attr).getAttribute().isIsList();
                    boolean _isIsList_7 = ip.isIsList();
                    boolean _tripleNotEquals_5 = (Boolean.valueOf(_isIsList_6) != Boolean.valueOf(_isIsList_7));
                    if (_tripleNotEquals_5) {
                      StringConcatenation _builder_14 = new StringConcatenation();
                      _builder_14.append("gui sib port ");
                      String _name_14 = ip.getName();
                      _builder_14.append(_name_14);
                      _builder_14.append(" is not compatible to attribute on list status");
                      this.addError(te, _builder_14);
                    }
                    if ((ip instanceof PrimitiveInputPort)) {
                      PrimitiveType _primitiveDataType = this._dataExtension.getPrimitiveDataType(((PrimitiveExtensionAttribute) attr).getAttribute());
                      PrimitiveType _data_1 = this._dataExtension.toData(((PrimitiveInputPort) ip).getDataType());
                      boolean _tripleNotEquals_6 = (_primitiveDataType != _data_1);
                      if (_tripleNotEquals_6) {
                        StringConcatenation _builder_15 = new StringConcatenation();
                        _builder_15.append("gui sib port ");
                        String _name_15 = ((PrimitiveInputPort)ip).getName();
                        _builder_15.append(_name_15);
                        _builder_15.append(" primitive type is not compatible to attribute");
                        this.addError(te, _builder_15);
                      }
                    } else {
                      StringConcatenation _builder_16 = new StringConcatenation();
                      _builder_16.append("complex gui sib port ");
                      String _name_16 = ip.getName();
                      _builder_16.append(_name_16);
                      _builder_16.append(" is not compatible to primitive attribute");
                      this.addError(te, 
                        _builder_16.toString());
                    }
                  } else {
                    if ((attr instanceof ComplexExtensionAttribute)) {
                      if ((ip instanceof ComplexInputPort)) {
                        Type _complexDataType = this._dataExtension.getComplexDataType(((ComplexExtensionAttribute) attr).getAttribute());
                        Pair<Node, Type> _mappedTo = Pair.<Node, Type>of(attr, _complexDataType);
                        Type _dataType_5 = ((ComplexInputPort) ip).getDataType();
                        Pair<InputPort, Type> _mappedTo_1 = Pair.<InputPort, Type>of(ip, _dataType_5);
                        boolean _isSubTypeWithSmartCast_1 = this.guiex.isSubTypeWithSmartCast(_mappedTo, _mappedTo_1);
                        boolean _not_5 = (!_isSubTypeWithSmartCast_1);
                        if (_not_5) {
                          StringConcatenation _builder_17 = new StringConcatenation();
                          _builder_17.append("gui sib port ");
                          String _name_17 = ((ComplexInputPort)ip).getName();
                          _builder_17.append(_name_17);
                          _builder_17.append(" type is not compatible to attribute");
                          this.addError(te, _builder_17);
                        }
                      } else {
                        StringConcatenation _builder_18 = new StringConcatenation();
                        _builder_18.append("primitive gui sib port ");
                        String _name_18 = ip.getName();
                        _builder_18.append(_name_18);
                        _builder_18.append(" is not compatible to complex attribute");
                        this.addError(te, _builder_18);
                      }
                    } else {
                      if ((ip instanceof ComplexInputPort)) {
                        Type _dataType_6 = ((ComplexAttribute) attr).getAttribute().getDataType();
                        Pair<Node, Type> _mappedTo_2 = Pair.<Node, Type>of(attr, _dataType_6);
                        Type _dataType_7 = ((ComplexInputPort) ip).getDataType();
                        Pair<InputPort, Type> _mappedTo_3 = Pair.<InputPort, Type>of(ip, _dataType_7);
                        boolean _isSubTypeWithSmartCast_2 = this.guiex.isSubTypeWithSmartCast(_mappedTo_2, _mappedTo_3);
                        boolean _not_6 = (!_isSubTypeWithSmartCast_2);
                        if (_not_6) {
                          StringConcatenation _builder_19 = new StringConcatenation();
                          _builder_19.append("gui sib port ");
                          String _name_19 = ((ComplexInputPort)ip).getName();
                          _builder_19.append(_name_19);
                          _builder_19.append(" type is not compatible to attribute");
                          this.addError(te, _builder_19);
                        }
                      } else {
                        StringConcatenation _builder_20 = new StringConcatenation();
                        _builder_20.append("primitive gui sib port ");
                        String _name_20 = ip.getName();
                        _builder_20.append(_name_20);
                        _builder_20.append(" is not compatible to complex attribute");
                        this.addError(te, _builder_20);
                      }
                    }
                  }
                }
              }
            }
          }
        }
        if ((!isPortFound)) {
          StringConcatenation _builder_21 = new StringConcatenation();
          _builder_21.append("gui sib port ");
          String _name_21 = ip.getName();
          _builder_21.append(_name_21);
          _builder_21.append(" is outdated");
          this.addError(te, _builder_21);
        }
      }
    }
    GUI _gui = te.getGui();
    List<PrimitiveVariable> _find = null;
    if (_gui!=null) {
      _find=this.guiex.<PrimitiveVariable>find(_gui, PrimitiveVariable.class);
    }
    final Function1<PrimitiveVariable, Boolean> _function_8 = new Function1<PrimitiveVariable, Boolean>() {
      @Override
      public Boolean apply(final PrimitiveVariable it) {
        return Boolean.valueOf(it.isIsInput());
      }
    };
    final Iterable<PrimitiveVariable> guiPrimInputVars = IterableExtensions.<PrimitiveVariable>filter(_find, _function_8);
    EList<InputStatic> _inputStatics = te.getInputStatics();
    for (final InputStatic inputStatic : _inputStatics) {
      {
        PrimitiveVariable _findFirst = null;
        if (guiPrimInputVars!=null) {
          final Function1<PrimitiveVariable, Boolean> _function_9 = new Function1<PrimitiveVariable, Boolean>() {
            @Override
            public Boolean apply(final PrimitiveVariable it) {
              String _name = it.getName();
              String _name_1 = inputStatic.getName();
              return Boolean.valueOf(Objects.equal(_name, _name_1));
            }
          };
          _findFirst=IterableExtensions.<PrimitiveVariable>findFirst(guiPrimInputVars, _function_9);
        }
        final PrimitiveVariable primInputVar = _findFirst;
        if ((primInputVar == null)) {
          String _label = te.getLabel();
          String _plus = ("GUISIB \'" + _label);
          String _plus_1 = (_plus + "\': input variable \'");
          String _name = inputStatic.getName();
          String _plus_2 = (_plus_1 + _name);
          String _plus_3 = (_plus_2 + "\' not found in GUI");
          this.addError(te, _plus_3);
        } else {
          String primInputVarTypeName = primInputVar.getDataType().getName();
          boolean primInputVarIsList = primInputVar.isIsList();
          if ((inputStatic instanceof IntegerInputStatic)) {
            boolean _notEquals = (!Objects.equal(primInputVarTypeName, "Integer"));
            if (_notEquals) {
              String _name_1 = te.getName();
              String _plus_4 = ("Type mismatch of IntegerInputStatic in GUISIB \'" + _name_1);
              String _plus_5 = (_plus_4 + "\': corresponding variable \'");
              String _name_2 = primInputVar.getName();
              String _plus_6 = (_plus_5 + _name_2);
              String _plus_7 = (_plus_6 + "\' does not have an integer type");
              this.addError(te, _plus_7);
            }
            if (primInputVarIsList) {
              String _name_3 = te.getName();
              String _plus_8 = ("List type mismatch of IntegerInputStatic in GUISIB \'" + _name_3);
              String _plus_9 = (_plus_8 + "\':  corresponding variable \'");
              String _name_4 = primInputVar.getName();
              String _plus_10 = (_plus_9 + _name_4);
              String _plus_11 = (_plus_10 + "\' is a list");
              this.addError(te, _plus_11);
            }
          }
          if ((inputStatic instanceof BooleanInputStatic)) {
            boolean _notEquals_1 = (!Objects.equal(primInputVarTypeName, "Boolean"));
            if (_notEquals_1) {
              String _name_5 = te.getName();
              String _plus_12 = ("Type mismatch of BooleanInputStatic in GUISIB \'" + _name_5);
              String _plus_13 = (_plus_12 + "\': corresponding variable \'");
              String _name_6 = primInputVar.getName();
              String _plus_14 = (_plus_13 + _name_6);
              String _plus_15 = (_plus_14 + "\' does not have a boolean type");
              this.addError(te, _plus_15);
            }
            if (primInputVarIsList) {
              String _name_7 = te.getName();
              String _plus_16 = ("List type mismatch of BooleanInputStatic in GUISIB \'" + _name_7);
              String _plus_17 = (_plus_16 + "\': corresponding variable \'");
              String _name_8 = primInputVar.getName();
              String _plus_18 = (_plus_17 + _name_8);
              String _plus_19 = (_plus_18 + "\' is a list");
              this.addError(te, _plus_19);
            }
          }
          if ((inputStatic instanceof RealInputStatic)) {
            boolean _notEquals_2 = (!Objects.equal(primInputVarTypeName, "Real"));
            if (_notEquals_2) {
              String _name_9 = te.getName();
              String _plus_20 = ("Type mismatch of RealInputStatic in GUISIB \'" + _name_9);
              String _plus_21 = (_plus_20 + "\': corresponding variable \'");
              String _name_10 = primInputVar.getName();
              String _plus_22 = (_plus_21 + _name_10);
              String _plus_23 = (_plus_22 + "\' does not have a real type");
              this.addError(te, _plus_23);
            }
            if (primInputVarIsList) {
              String _name_11 = te.getName();
              String _plus_24 = ("List type mismatch of RealInputStatic in GUISIB \'" + _name_11);
              String _plus_25 = (_plus_24 + "\': corresponding variable \'");
              String _name_12 = primInputVar.getName();
              String _plus_26 = (_plus_25 + _name_12);
              String _plus_27 = (_plus_26 + "\' is a list");
              this.addError(te, _plus_27);
            }
          }
          if ((inputStatic instanceof TextInputStatic)) {
            boolean _notEquals_3 = (!Objects.equal(primInputVarTypeName, "Text"));
            if (_notEquals_3) {
              String _name_13 = te.getName();
              String _plus_28 = ("Type mismatch of TextInputStatic in GUISIB \'" + _name_13);
              String _plus_29 = (_plus_28 + "\': corresponding variable \'");
              String _name_14 = primInputVar.getName();
              String _plus_30 = (_plus_29 + _name_14);
              String _plus_31 = (_plus_30 + "\' does not have a text type");
              this.addError(te, _plus_31);
            }
            if (primInputVarIsList) {
              String _name_15 = te.getName();
              String _plus_32 = ("List type mismatch of TextInputStatic in GUISIB \'" + _name_15);
              String _plus_33 = (_plus_32 + "\': corresponding variable \'");
              String _name_16 = primInputVar.getName();
              String _plus_34 = (_plus_33 + _name_16);
              String _plus_35 = (_plus_34 + "\' is a list");
              this.addError(te, _plus_35);
            }
          }
          if ((inputStatic instanceof TimestampInputStatic)) {
            boolean _notEquals_4 = (!Objects.equal(primInputVarTypeName, "Timestamp"));
            if (_notEquals_4) {
              String _name_17 = te.getName();
              String _plus_36 = ("Type mismatch of TimestampInputStatic in GUISIB \'" + _name_17);
              String _plus_37 = (_plus_36 + "\': corresponding variable \'");
              String _name_18 = primInputVar.getName();
              String _plus_38 = (_plus_37 + _name_18);
              String _plus_39 = (_plus_38 + "\' does not have a timestamp type");
              this.addError(te, _plus_39);
            }
            if (primInputVarIsList) {
              String _name_19 = te.getName();
              String _plus_40 = ("List type mismatch of TimestampInputStatic in GUISIB \'" + _name_19);
              String _plus_41 = (_plus_40 + "\': corresponding variable \'");
              String _name_20 = primInputVar.getName();
              String _plus_42 = (_plus_41 + _name_20);
              String _plus_43 = (_plus_42 + "\' is a list");
              this.addError(te, _plus_43);
            }
          }
        }
      }
    }
    int _size = te.getInputPorts().size();
    int _size_1 = te.getInputStatics().size();
    int portSize = (_size + _size_1);
    final Function<DataContext, Stream<Variable>> _function_9 = new Function<DataContext, Stream<Variable>>() {
      @Override
      public Stream<Variable> apply(final DataContext n) {
        return n.getVariables().stream();
      }
    };
    final Predicate<Variable> _function_10 = new Predicate<Variable>() {
      @Override
      public boolean test(final Variable n) {
        return n.isIsInput();
      }
    };
    long inputVars = gui.getDataContexts().stream().<Variable>flatMap(_function_9).filter(_function_10).count();
    if ((portSize < inputVars)) {
      this.addError(te, 
        "gui sib input ports are missing");
    }
  }
  
  /**
   * Checks if the input ports, branches and output ports of
   * the given GUI plug in SIB are still in sync with the referenced GUI plug in
   * @param id
   * @param te
   */
  private void _doCheck(final GUIPlugin te) {
    EObject _function = te.getFunction();
    final info.scce.dime.gUIPlugin.Function function = ((info.scce.dime.gUIPlugin.Function) _function);
    if ((((!te.getInputGenerics().isEmpty()) || IterableExtensions.<Branch>exists(Iterables.<Branch>filter(te.getAbstractBranchs(), Branch.class), new Function1<Branch, Boolean>() {
      @Override
      public Boolean apply(final Branch it) {
        boolean _isEmpty = it.getOutputGenerics().isEmpty();
        return Boolean.valueOf((!_isEmpty));
      }
    })) || IterableExtensions.<EventListener>exists(te.getEventListeners(), new Function1<EventListener, Boolean>() {
      @Override
      public Boolean apply(final EventListener it) {
        boolean _isEmpty = it.getInputGenerics().isEmpty();
        return Boolean.valueOf((!_isEmpty));
      }
    }))) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("generic inputs has to be replaced");
      this.addError(te, _builder.toString());
    }
    this.checkGUIPluginListeners(te.getEventListeners(), function.getEvents(), te);
    this.checkListener(te.getEventListeners(), te);
    EObject _eContainer = function.eContainer();
    final Plugin plugin = ((Plugin) _eContainer);
    final LinkedList<String> availablePlaceholder = new LinkedList<String>();
    Template _template = plugin.getTemplate();
    Placeholders _placholders = null;
    if (_template!=null) {
      _placholders=_template.getPlacholders();
    }
    EList<info.scce.dime.gUIPlugin.Placeholder> _placeholders = null;
    if (_placholders!=null) {
      _placeholders=_placholders.getPlaceholders();
    }
    boolean _notEquals = (!Objects.equal(_placeholders, null));
    if (_notEquals) {
      final Function1<info.scce.dime.gUIPlugin.Placeholder, String> _function_1 = new Function1<info.scce.dime.gUIPlugin.Placeholder, String>() {
        @Override
        public String apply(final info.scce.dime.gUIPlugin.Placeholder it) {
          return it.getName();
        }
      };
      List<String> _list = IterableExtensions.<String>toList(ListExtensions.<info.scce.dime.gUIPlugin.Placeholder, String>map(plugin.getTemplate().getPlacholders().getPlaceholders(), _function_1));
      Iterables.<String>addAll(availablePlaceholder, _list);
    }
    final Function1<Argument, String> _function_2 = new Function1<Argument, String>() {
      @Override
      public String apply(final Argument it) {
        return it.getBlockName();
      }
    };
    final List<String> providedArguments = ListExtensions.<Argument, String>map(te.getArguments(), _function_2);
    final Function1<String, Boolean> _function_3 = new Function1<String, Boolean>() {
      @Override
      public Boolean apply(final String n) {
        boolean _contains = providedArguments.contains(n);
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<String> _function_4 = new Consumer<String>() {
      @Override
      public void accept(final String n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Argument for placeholder ");
        _builder.append(n);
        _builder.append(" missing");
        GUISIBCheck.this.addError(te, _builder);
      }
    };
    IterableExtensions.<String>filter(availablePlaceholder, _function_3).forEach(_function_4);
    final Function1<String, Boolean> _function_5 = new Function1<String, Boolean>() {
      @Override
      public Boolean apply(final String n) {
        boolean _contains = availablePlaceholder.contains(n);
        return Boolean.valueOf((!_contains));
      }
    };
    final Consumer<String> _function_6 = new Consumer<String>() {
      @Override
      public void accept(final String n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("No placeholder for ");
        _builder.append(n);
        _builder.append(" available");
        GUISIBCheck.this.addError(te, _builder);
      }
    };
    IterableExtensions.<String>filter(providedArguments, _function_5).forEach(_function_6);
    EObject _function_7 = te.getFunction();
    info.scce.dime.gUIPlugin.Function fun = ((info.scce.dime.gUIPlugin.Function) _function_7);
    boolean _equals = fun.getFunctionName().equals(te.getLabel());
    boolean _not = (!_equals);
    if (_not) {
      this.addError(te, "native gui sib name is outdated");
    }
    EList<InputPort> _inputPorts = te.getInputPorts();
    for (final InputPort ip : _inputPorts) {
      {
        boolean portFound = false;
        EList<AbstractParameter> _parameters = fun.getParameters();
        for (final AbstractParameter par : _parameters) {
          {
            String _xifexpression = null;
            if ((par instanceof ComplexInputParameter)) {
              _xifexpression = ((ComplexInputParameter)par).getParameter().getName();
            } else {
              String _xifexpression_1 = null;
              if ((par instanceof GenericInputParameter)) {
                _xifexpression_1 = ((GenericInputParameter)par).getParameter().getName();
              } else {
                _xifexpression_1 = ((PrimitiveInputParameter) par).getParameter().getName();
              }
              _xifexpression = _xifexpression_1;
            }
            String ipName = _xifexpression;
            boolean _xifexpression_2 = false;
            if ((par instanceof ComplexInputParameter)) {
              _xifexpression_2 = ((ComplexInputParameter)par).getParameter().isIsList();
            } else {
              boolean _xifexpression_3 = false;
              if ((par instanceof GenericInputParameter)) {
                _xifexpression_3 = ((GenericInputParameter)par).getParameter().isIsList();
              } else {
                _xifexpression_3 = ((PrimitiveInputParameter) par).getParameter().isIsList();
              }
              _xifexpression_2 = _xifexpression_3;
            }
            boolean ipIsList = _xifexpression_2;
            boolean _equals_1 = ipName.equals(ip.getName());
            if (_equals_1) {
              portFound = true;
              boolean _isIsList = ip.isIsList();
              boolean _notEquals_1 = (ipIsList != _isIsList);
              if (_notEquals_1) {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append("native gui sib input port ");
                String _name = ip.getName();
                _builder_1.append(_name);
                _builder_1.append(" list state is outdated");
                this.addError(te, _builder_1.toString());
              }
              if (((par instanceof ComplexInputParameter) && (ip instanceof PrimitiveInputPort))) {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append("native gui sib port ");
                String _name_1 = ip.getName();
                _builder_2.append(_name_1);
                _builder_2.append(" outdated");
                this.addError(te, _builder_2.toString());
              }
              if (((par instanceof PrimitiveInputParameter) && (ip instanceof ComplexInputPort))) {
                StringConcatenation _builder_3 = new StringConcatenation();
                _builder_3.append("native gui sib port ");
                String _name_2 = ip.getName();
                _builder_3.append(_name_2);
                _builder_3.append(" outdated");
                this.addError(te, _builder_3.toString());
              }
              if (((par instanceof ComplexInputParameter) && (ip instanceof ComplexInputPort))) {
                boolean _equals_2 = this.guiex.toComplexType(((ComplexInputParameter) par)).equals(((ComplexInputPort) ip).getDataType());
                boolean _not_1 = (!_equals_2);
                if (_not_1) {
                  StringConcatenation _builder_4 = new StringConcatenation();
                  _builder_4.append("native gui sib port ");
                  String _name_3 = ip.getName();
                  _builder_4.append(_name_3);
                  _builder_4.append(" outdated");
                  this.addError(te, _builder_4.toString());
                }
              }
              if (((par instanceof PrimitiveInputParameter) && (ip instanceof PrimitiveInputPort))) {
                info.scce.dime.gui.gui.PrimitiveType _primitiveType = this.guiex.toPrimitiveType(((PrimitiveInputParameter) par).getParameter().getType());
                info.scce.dime.gui.gui.PrimitiveType _dataType = ((PrimitiveInputPort) ip).getDataType();
                boolean _notEquals_2 = (!Objects.equal(_primitiveType, _dataType));
                if (_notEquals_2) {
                  StringConcatenation _builder_5 = new StringConcatenation();
                  _builder_5.append("native gui sib port ");
                  String _name_4 = ip.getName();
                  _builder_5.append(_name_4);
                  _builder_5.append(" outdated");
                  this.addError(te, _builder_5.toString());
                }
              }
            }
          }
        }
        if ((!portFound)) {
          StringConcatenation _builder_1 = new StringConcatenation();
          _builder_1.append("native gui sib iput port ");
          String _name = ip.getName();
          _builder_1.append(_name);
          _builder_1.append(" is outdated ");
          this.addError(te, _builder_1.toString());
        }
        final Function1<Read, Node> _function_8 = new Function1<Read, Node>() {
          @Override
          public Node apply(final Read it) {
            return it.getSourceElement();
          }
        };
        List<Node> _map = ListExtensions.<Read, Node>map(ip.<Read>getIncoming(Read.class), _function_8);
        for (final Node node : _map) {
          if ((node instanceof Variable)) {
            Variable var = ((Variable) node);
            boolean _isIsList = var.isIsList();
            boolean _isIsList_1 = ip.isIsList();
            boolean _tripleNotEquals = (Boolean.valueOf(_isIsList) != Boolean.valueOf(_isIsList_1));
            if (_tripleNotEquals) {
              StringConcatenation _builder_2 = new StringConcatenation();
              _builder_2.append("native gui sib port ");
              String _name_1 = ip.getName();
              _builder_2.append(_name_1);
              _builder_2.append(" is not compatible to variable on list status");
              this.addError(te, _builder_2.toString());
            }
            if ((var instanceof PrimitiveVariable)) {
              if ((ip instanceof PrimitiveInputPort)) {
                info.scce.dime.gui.gui.PrimitiveType _dataType = ((PrimitiveVariable) var).getDataType();
                info.scce.dime.gui.gui.PrimitiveType _dataType_1 = ((PrimitiveInputPort) ip).getDataType();
                boolean _tripleNotEquals_1 = (_dataType != _dataType_1);
                if (_tripleNotEquals_1) {
                  StringConcatenation _builder_3 = new StringConcatenation();
                  _builder_3.append("native gui sib port ");
                  String _name_2 = ((PrimitiveInputPort)ip).getName();
                  _builder_3.append(_name_2);
                  _builder_3.append(" primitive type is not compatible to variable");
                  this.addError(te, _builder_3.toString());
                }
              } else {
                StringConcatenation _builder_4 = new StringConcatenation();
                _builder_4.append("complex native gui sib port ");
                String _name_3 = ip.getName();
                _builder_4.append(_name_3);
                _builder_4.append(" is not compatible to primitive variable");
                this.addError(te, _builder_4.toString());
              }
            } else {
              if ((ip instanceof ComplexInputPort)) {
                Type _dataType_2 = ((ComplexVariable) var).getDataType();
                Pair<Node, Type> _pair = new Pair<Node, Type>(var, _dataType_2);
                Type _dataType_3 = ((ComplexInputPort) ip).getDataType();
                Pair<InputPort, Type> _pair_1 = new Pair<InputPort, Type>(ip, _dataType_3);
                boolean _isSubTypeWithSmartCast = this.guiex.isSubTypeWithSmartCast(_pair, _pair_1);
                boolean _not_1 = (!_isSubTypeWithSmartCast);
                if (_not_1) {
                  StringConcatenation _builder_5 = new StringConcatenation();
                  _builder_5.append("native gui sib port ");
                  String _name_4 = ((ComplexInputPort)ip).getName();
                  _builder_5.append(_name_4);
                  _builder_5.append(" type is not compatible to variable");
                  this.addError(te, _builder_5.toString());
                }
              } else {
                StringConcatenation _builder_6 = new StringConcatenation();
                _builder_6.append("primitive native gui sib port ");
                String _name_5 = ip.getName();
                _builder_6.append(_name_5);
                _builder_6.append(" is not compatible to complex variable");
                this.addError(te, _builder_6.toString());
              }
            }
          } else {
            if ((node instanceof Attribute)) {
              final Attribute attr = ((Attribute) node);
              if ((attr instanceof PrimitiveAttribute)) {
                boolean _isIsList_2 = ((PrimitiveAttribute) attr).getAttribute().isIsList();
                boolean _isIsList_3 = ip.isIsList();
                boolean _tripleNotEquals_2 = (Boolean.valueOf(_isIsList_2) != Boolean.valueOf(_isIsList_3));
                if (_tripleNotEquals_2) {
                  StringConcatenation _builder_7 = new StringConcatenation();
                  _builder_7.append("native gui sib port ");
                  String _name_6 = ip.getName();
                  _builder_7.append(_name_6);
                  _builder_7.append(" is not compatible to attribute on list status");
                  this.addError(te, _builder_7.toString());
                }
                if ((ip instanceof PrimitiveInputPort)) {
                  PrimitiveType _dataType_4 = ((PrimitiveAttribute) attr).getAttribute().getDataType();
                  PrimitiveType _data = this._dataExtension.toData(((PrimitiveInputPort) ip).getDataType());
                  boolean _tripleNotEquals_3 = (_dataType_4 != _data);
                  if (_tripleNotEquals_3) {
                    StringConcatenation _builder_8 = new StringConcatenation();
                    _builder_8.append("native gui sib port ");
                    String _name_7 = ((PrimitiveInputPort)ip).getName();
                    _builder_8.append(_name_7);
                    _builder_8.append(" primitive type is not compatible to attribute");
                    this.addError(te, _builder_8.toString());
                  }
                } else {
                  StringConcatenation _builder_9 = new StringConcatenation();
                  _builder_9.append("native complex gui sib port ");
                  String _name_8 = ip.getName();
                  _builder_9.append(_name_8);
                  _builder_9.append(" is not compatible to primitive attribute");
                  this.addError(te, _builder_9.toString());
                }
              } else {
                if ((attr instanceof PrimitiveExtensionAttribute)) {
                  boolean _isIsList_4 = ((PrimitiveExtensionAttribute) attr).getAttribute().isIsList();
                  boolean _isIsList_5 = ip.isIsList();
                  boolean _tripleNotEquals_4 = (Boolean.valueOf(_isIsList_4) != Boolean.valueOf(_isIsList_5));
                  if (_tripleNotEquals_4) {
                    StringConcatenation _builder_10 = new StringConcatenation();
                    _builder_10.append("native gui sib port ");
                    String _name_9 = ip.getName();
                    _builder_10.append(_name_9);
                    _builder_10.append(" is not compatible to attribute on list status");
                    this.addError(te, _builder_10.toString());
                  }
                  if ((ip instanceof PrimitiveInputPort)) {
                    PrimitiveType _primitiveDataType = this._dataExtension.getPrimitiveDataType(((PrimitiveExtensionAttribute) attr).getAttribute());
                    PrimitiveType _data_1 = this._dataExtension.toData(((PrimitiveInputPort) ip).getDataType());
                    boolean _tripleNotEquals_5 = (_primitiveDataType != _data_1);
                    if (_tripleNotEquals_5) {
                      StringConcatenation _builder_11 = new StringConcatenation();
                      _builder_11.append("native gui sib port ");
                      String _name_10 = ((PrimitiveInputPort)ip).getName();
                      _builder_11.append(_name_10);
                      _builder_11.append(" primitive type is not compatible to attribute");
                      this.addError(te, _builder_11.toString());
                    }
                  } else {
                    StringConcatenation _builder_12 = new StringConcatenation();
                    _builder_12.append("native complex gui sib port ");
                    String _name_11 = ip.getName();
                    _builder_12.append(_name_11);
                    _builder_12.append(" is not compatible to primitive attribute");
                    this.addError(te, _builder_12.toString());
                  }
                } else {
                  if ((attr instanceof PrimitiveListAttribute)) {
                    if ((ip instanceof PrimitiveInputPort)) {
                      if ((Objects.equal(((PrimitiveListAttribute) attr).getAttributeName(), PrimitiveListAttributeName.SIZE) && (!Objects.equal(this._dataExtension.toData(((PrimitiveInputPort) ip).getDataType()), PrimitiveType.INTEGER)))) {
                        StringConcatenation _builder_13 = new StringConcatenation();
                        _builder_13.append("native gui sib port ");
                        String _name_12 = ((PrimitiveInputPort)ip).getName();
                        _builder_13.append(_name_12);
                        _builder_13.append(" primitive type is not compatible to size list attribute");
                        this.addError(te, _builder_13.toString());
                      }
                    } else {
                      StringConcatenation _builder_14 = new StringConcatenation();
                      _builder_14.append("native gui sib port ");
                      String _name_13 = ip.getName();
                      _builder_14.append(_name_13);
                      _builder_14.append(" is not compatible to primitive list attribute");
                      this.addError(te, _builder_14.toString());
                    }
                  } else {
                    if ((attr instanceof ComplexExtensionAttribute)) {
                      if ((ip instanceof ComplexInputPort)) {
                        Type _complexDataType = this._dataExtension.getComplexDataType(((ComplexExtensionAttribute) attr).getAttribute());
                        Pair<Node, Type> _pair_2 = new Pair<Node, Type>(attr, _complexDataType);
                        Type _dataType_5 = ((ComplexInputPort) ip).getDataType();
                        Pair<InputPort, Type> _pair_3 = new Pair<InputPort, Type>(ip, _dataType_5);
                        boolean _isSubTypeWithSmartCast_1 = this.guiex.isSubTypeWithSmartCast(_pair_2, _pair_3);
                        boolean _not_2 = (!_isSubTypeWithSmartCast_1);
                        if (_not_2) {
                          StringConcatenation _builder_15 = new StringConcatenation();
                          _builder_15.append("native gui sib port ");
                          String _name_14 = ((ComplexInputPort)ip).getName();
                          _builder_15.append(_name_14);
                          _builder_15.append(" type is not compatible to attribute");
                          this.addError(te, _builder_15.toString());
                        }
                      } else {
                        StringConcatenation _builder_16 = new StringConcatenation();
                        _builder_16.append("native primitive gui sib port ");
                        String _name_15 = ip.getName();
                        _builder_16.append(_name_15);
                        _builder_16.append(" is not compatible to complex attribute");
                        this.addError(te, _builder_16.toString());
                      }
                    } else {
                      if ((ip instanceof ComplexInputPort)) {
                        Type _dataType_6 = ((ComplexAttribute) attr).getAttribute().getDataType();
                        Pair<Node, Type> _pair_4 = new Pair<Node, Type>(attr, _dataType_6);
                        Type _dataType_7 = ((ComplexInputPort) ip).getDataType();
                        Pair<InputPort, Type> _pair_5 = new Pair<InputPort, Type>(ip, _dataType_7);
                        boolean _isSubTypeWithSmartCast_2 = this.guiex.isSubTypeWithSmartCast(_pair_4, _pair_5);
                        boolean _not_3 = (!_isSubTypeWithSmartCast_2);
                        if (_not_3) {
                          StringConcatenation _builder_17 = new StringConcatenation();
                          _builder_17.append("native gui sib port ");
                          String _name_16 = ((ComplexInputPort)ip).getName();
                          _builder_17.append(_name_16);
                          _builder_17.append(" type is not compatible to attribute");
                          this.addError(te, _builder_17.toString());
                        }
                      } else {
                        StringConcatenation _builder_18 = new StringConcatenation();
                        _builder_18.append("native primitive gui sib port ");
                        String _name_17 = ip.getName();
                        _builder_18.append(_name_17);
                        _builder_18.append(" is not compatible to complex attribute");
                        this.addError(te, _builder_18.toString());
                      }
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    int _size = te.getInputPorts().size();
    int _size_1 = te.getInputStatics().size();
    int portSize = (_size + _size_1);
    long requiredOutputs = fun.getParameters().size();
    if ((portSize < requiredOutputs)) {
      this.addError(te, "native GUI SIB input ports are missing");
    }
    final Consumer<Branch> _function_8 = new Consumer<Branch>() {
      @Override
      public void accept(final Branch b) {
        final Function1<Output, Boolean> _function = new Function1<Output, Boolean>() {
          @Override
          public Boolean apply(final Output it) {
            return Boolean.valueOf(it.getOutputName().equals(b.getName()));
          }
        };
        final Output output = IterableExtensions.<Output>findFirst(function.getOutputs(), _function);
        if ((output == null)) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("branch ");
          String _name = b.getName();
          _builder.append(_name);
          _builder.append(" does not exist in GUIPlugin ");
          String _label = te.getLabel();
          _builder.append(_label);
          GUISIBCheck.this.addError(b, _builder.toString());
        } else {
          final Consumer<OutputPort> _function_1 = new Consumer<OutputPort>() {
            @Override
            public void accept(final OutputPort p) {
              final Function1<AbstractParameter, Boolean> _function = new Function1<AbstractParameter, Boolean>() {
                @Override
                public Boolean apply(final AbstractParameter it) {
                  return Boolean.valueOf(it.getName().equals(p.getName()));
                }
              };
              final AbstractParameter parameter = IterableExtensions.<AbstractParameter>findFirst(output.getParameters(), _function);
              if ((parameter == null)) {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("port ");
                String _name = p.getName();
                _builder.append(_name);
                _builder.append(" does not exist in GUIPlugin ");
                String _label = te.getLabel();
                _builder.append(_label);
                _builder.append(" branch ");
                String _outputName = output.getOutputName();
                _builder.append(_outputName);
                GUISIBCheck.this.addError(b, _builder.toString());
              } else {
                boolean _isIsList = parameter.isIsList();
                boolean _isIsList_1 = p.isIsList();
                boolean _notEquals = (_isIsList != _isIsList_1);
                if (_notEquals) {
                  StringConcatenation _builder_1 = new StringConcatenation();
                  _builder_1.append("port ");
                  String _name_1 = p.getName();
                  _builder_1.append(_name_1);
                  _builder_1.append(" list state is outdated of GUIPlugin ");
                  String _label_1 = te.getLabel();
                  _builder_1.append(_label_1);
                  _builder_1.append(" branch ");
                  String _outputName_1 = output.getOutputName();
                  _builder_1.append(_outputName_1);
                  GUISIBCheck.this.addError(b, _builder_1.toString());
                }
                if (((parameter instanceof ComplexParameter) && (p instanceof ComplexOutputPort))) {
                  boolean _equals = ((ComplexParameter) parameter).getType().equals(((ComplexOutputPort) p).getDataType());
                  boolean _not = (!_equals);
                  if (_not) {
                    StringConcatenation _builder_2 = new StringConcatenation();
                    _builder_2.append("port ");
                    String _name_2 = p.getName();
                    _builder_2.append(_name_2);
                    _builder_2.append(" type is outdated of GUIPlugin ");
                    String _label_2 = te.getLabel();
                    _builder_2.append(_label_2);
                    _builder_2.append(" branch ");
                    String _outputName_2 = output.getOutputName();
                    _builder_2.append(_outputName_2);
                    GUISIBCheck.this.addError(b, _builder_2.toString());
                  }
                } else {
                  if (((parameter instanceof PrimitiveParameter) && (p instanceof PrimitiveOutputPort))) {
                    PrimitiveType _data = GUISIBCheck.this.guiex.toData(((PrimitiveParameter) parameter).getType());
                    PrimitiveType _data_1 = GUISIBCheck.this._dataExtension.toData(((PrimitiveOutputPort) p).getDataType());
                    boolean _notEquals_1 = (!Objects.equal(_data, _data_1));
                    if (_notEquals_1) {
                      StringConcatenation _builder_3 = new StringConcatenation();
                      _builder_3.append("port ");
                      String _name_3 = p.getName();
                      _builder_3.append(_name_3);
                      _builder_3.append(" type is outdated of GUIPlugin ");
                      String _label_3 = te.getLabel();
                      _builder_3.append(_label_3);
                      _builder_3.append(" branch ");
                      String _outputName_3 = output.getOutputName();
                      _builder_3.append(_outputName_3);
                      GUISIBCheck.this.addError(b, _builder_3.toString());
                    }
                  } else {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    _builder_4.append("port ");
                    String _name_4 = p.getName();
                    _builder_4.append(_name_4);
                    _builder_4.append(" type is outdated of GUIPlugin ");
                    String _label_4 = te.getLabel();
                    _builder_4.append(_label_4);
                    _builder_4.append(" branch ");
                    String _outputName_4 = output.getOutputName();
                    _builder_4.append(_outputName_4);
                    GUISIBCheck.this.addError(b, _builder_4.toString());
                  }
                }
              }
            }
          };
          b.getOutputPorts().forEach(_function_1);
        }
      }
    };
    te.getBranchs().forEach(_function_8);
  }
  
  private void doCheck(final EObject te) {
    if (te instanceof GUIPlugin) {
      _doCheck((GUIPlugin)te);
      return;
    } else if (te instanceof GUISIB) {
      _doCheck((GUISIB)te);
      return;
    } else if (te != null) {
      _doCheck(te);
      return;
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(te).toString());
    }
  }
}
