/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.checks;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import graphmodel.Edge;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.checks.AbstractCheck;
import info.scce.dime.data.helper.DataExtension;
import info.scce.dime.gui.gui.Attribute;
import info.scce.dime.gui.gui.ComplexAttribute;
import info.scce.dime.gui.gui.ComplexAttributeConnector;
import info.scce.dime.gui.gui.ComplexListAttributeConnector;
import info.scce.dime.gui.gui.ComplexListAttributeName;
import info.scce.dime.gui.gui.ComplexOutputPort;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.Event;
import info.scce.dime.gui.gui.EventListener;
import info.scce.dime.gui.gui.InputPort;
import info.scce.dime.gui.gui.OutputPort;
import info.scce.dime.gui.gui.PrimitiveAttribute;
import info.scce.dime.gui.gui.PrimitiveOutputPort;
import info.scce.dime.gui.gui.PrimitiveType;
import info.scce.dime.gui.gui.PrimitiveVariable;
import info.scce.dime.gui.gui.Write;
import info.scce.dime.gui.mcam.adapter.GUIAdapter;
import info.scce.dime.gui.mcam.adapter.GUIId;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

/**
 * The event check is used to validate the event listeners
 * of all listener contexts of a GUI model
 * @author zweihoff
 */
@SuppressWarnings("all")
public class EventCheck extends AbstractCheck<GUIId, GUIAdapter> {
  private GUIAdapter adapter;
  
  private Set<String> knownNames;
  
  @Extension
  private DataExtension _dataExtension = DataExtension.getInstance();
  
  /**
   * Checks, if the events in given GUI model
   * are valid.
   */
  @Override
  public void doExecute(final GUIAdapter arg0) {
    this.adapter = arg0;
    List<GUIId> _entityIds = this.adapter.getEntityIds();
    for (final GUIId id : _entityIds) {
      {
        Object obj = id.getElement();
        if ((obj instanceof Event)) {
          this.checkEventNames(id, ((Event)obj));
          this.checkWriteEdges(id, ((Event)obj));
        }
        if ((obj instanceof EventListener)) {
          this.checkReadEdges(id, ((EventListener)obj));
        }
      }
    }
  }
  
  public void checkWriteEdges(final GUIId id, final Event event) {
    final Function1<OutputPort, EList<? extends Write>> _function = new Function1<OutputPort, EList<? extends Write>>() {
      @Override
      public EList<? extends Write> apply(final OutputPort it) {
        return it.getOutgoing();
      }
    };
    final Function1<Write, Node> _function_1 = new Function1<Write, Node>() {
      @Override
      public Node apply(final Write it) {
        return it.getTargetElement();
      }
    };
    final Iterable<Node> connectedData = IterableExtensions.<Write, Node>map(Iterables.<Write>concat(ListExtensions.<OutputPort, EList<? extends Write>>map(event.getOutputPorts(), _function)), _function_1);
    final Function1<Node, Node> _function_2 = new Function1<Node, Node>() {
      @Override
      public Node apply(final Node it) {
        return EventCheck.this.toRootScopeData(it);
      }
    };
    final Function1<Node, Boolean> _function_3 = new Function1<Node, Boolean>() {
      @Override
      public Boolean apply(final Node n) {
        return Boolean.valueOf((!Objects.equal(n, null)));
      }
    };
    final Consumer<Node> _function_4 = new Consumer<Node>() {
      @Override
      public void accept(final Node n) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = event.getName();
        _builder.append(_name);
        _builder.append(" writes to inner scope data");
        EventCheck.this.addError(id, _builder.toString());
      }
    };
    IterableExtensions.<Node>filter(IterableExtensions.<Node, Node>map(connectedData, _function_2), _function_3).forEach(_function_4);
    final Function1<OutputPort, Boolean> _function_5 = new Function1<OutputPort, Boolean>() {
      @Override
      public Boolean apply(final OutputPort it) {
        boolean _isEmpty = it.getOutgoing().isEmpty();
        return Boolean.valueOf((!_isEmpty));
      }
    };
    final Consumer<OutputPort> _function_6 = new Consumer<OutputPort>() {
      @Override
      public void accept(final OutputPort port) {
        final Function1<Write, Node> _function = new Function1<Write, Node>() {
          @Override
          public Node apply(final Write it) {
            return it.getTargetElement();
          }
        };
        final Consumer<Node> _function_1 = new Consumer<Node>() {
          @Override
          public void accept(final Node data) {
            if (((port instanceof ComplexOutputPort) && (data instanceof ComplexVariable))) {
              boolean _isIsList = port.isIsList();
              boolean _isIsList_1 = ((ComplexVariable) data).isIsList();
              boolean _notEquals = (_isIsList != _isIsList_1);
              if (_notEquals) {
                StringConcatenation _builder = new StringConcatenation();
                String _name = port.getName();
                _builder.append(_name);
                _builder.append(" list state does not match ");
                String _name_1 = ((ComplexVariable) data).getName();
                _builder.append(_name_1);
                EventCheck.this.addError(id, _builder.toString());
              }
              boolean _contains = EventCheck.this._dataExtension.getKnownSubTypes(((ComplexVariable) data).getDataType()).contains(((ComplexOutputPort) port).getDataType());
              boolean _not = (!_contains);
              if (_not) {
                StringConcatenation _builder_1 = new StringConcatenation();
                String _name_2 = port.getName();
                _builder_1.append(_name_2);
                _builder_1.append(" type cannot be connected to ");
                String _name_3 = ((ComplexVariable) data).getDataType().getName();
                _builder_1.append(_name_3);
                EventCheck.this.addError(id, _builder_1.toString());
              }
            } else {
              if (((port instanceof ComplexOutputPort) && (data instanceof ComplexAttribute))) {
                boolean _isIsList_2 = port.isIsList();
                boolean _isIsList_3 = ((ComplexAttribute) data).getAttribute().isIsList();
                boolean _notEquals_1 = (_isIsList_2 != _isIsList_3);
                if (_notEquals_1) {
                  StringConcatenation _builder_2 = new StringConcatenation();
                  String _name_4 = port.getName();
                  _builder_2.append(_name_4);
                  _builder_2.append(" list state does not match ");
                  String _name_5 = ((ComplexAttribute) data).getAttribute().getName();
                  _builder_2.append(_name_5);
                  EventCheck.this.addError(id, _builder_2.toString());
                }
                boolean _contains_1 = EventCheck.this._dataExtension.getKnownSubTypes(EventCheck.this._dataExtension.getType(((ComplexAttribute) data).getAttribute())).contains(((ComplexOutputPort) port).getDataType());
                boolean _not_1 = (!_contains_1);
                if (_not_1) {
                  StringConcatenation _builder_3 = new StringConcatenation();
                  String _name_6 = port.getName();
                  _builder_3.append(_name_6);
                  _builder_3.append(" type cannot be connected to ");
                  String _name_7 = EventCheck.this._dataExtension.getType(((ComplexAttribute) data).getAttribute()).getName();
                  _builder_3.append(_name_7);
                  EventCheck.this.addError(id, _builder_3.toString());
                }
              } else {
                if (((port instanceof PrimitiveOutputPort) && (data instanceof PrimitiveVariable))) {
                  boolean _isIsList_4 = port.isIsList();
                  boolean _isIsList_5 = ((PrimitiveVariable) data).isIsList();
                  boolean _notEquals_2 = (_isIsList_4 != _isIsList_5);
                  if (_notEquals_2) {
                    StringConcatenation _builder_4 = new StringConcatenation();
                    String _name_8 = port.getName();
                    _builder_4.append(_name_8);
                    _builder_4.append(" list state does not match ");
                    String _name_9 = ((PrimitiveVariable) data).getName();
                    _builder_4.append(_name_9);
                    EventCheck.this.addError(id, _builder_4.toString());
                  }
                  PrimitiveType _dataType = ((PrimitiveOutputPort) port).getDataType();
                  PrimitiveType _dataType_1 = ((PrimitiveVariable) data).getDataType();
                  boolean _notEquals_3 = (!Objects.equal(_dataType, _dataType_1));
                  if (_notEquals_3) {
                    StringConcatenation _builder_5 = new StringConcatenation();
                    String _name_10 = port.getName();
                    _builder_5.append(_name_10);
                    _builder_5.append(" type cannot be connected to ");
                    String _literal = ((PrimitiveVariable) data).getDataType().getLiteral();
                    _builder_5.append(_literal);
                    EventCheck.this.addError(id, _builder_5.toString());
                  }
                } else {
                  if (((port instanceof PrimitiveOutputPort) && (data instanceof PrimitiveAttribute))) {
                    boolean _isIsList_6 = port.isIsList();
                    boolean _isIsList_7 = ((PrimitiveAttribute) data).getAttribute().isIsList();
                    boolean _notEquals_4 = (_isIsList_6 != _isIsList_7);
                    if (_notEquals_4) {
                      StringConcatenation _builder_6 = new StringConcatenation();
                      String _name_11 = port.getName();
                      _builder_6.append(_name_11);
                      _builder_6.append(" list state does not match ");
                      String _name_12 = ((PrimitiveAttribute) data).getAttribute().getName();
                      _builder_6.append(_name_12);
                      EventCheck.this.addError(id, _builder_6.toString());
                    }
                    String _literal_1 = ((PrimitiveOutputPort) port).getDataType().getLiteral();
                    String _literal_2 = ((PrimitiveAttribute) data).getAttribute().getDataType().getLiteral();
                    boolean _notEquals_5 = (!Objects.equal(_literal_1, _literal_2));
                    if (_notEquals_5) {
                      StringConcatenation _builder_7 = new StringConcatenation();
                      String _name_13 = port.getName();
                      _builder_7.append(_name_13);
                      _builder_7.append(" type cannot be connected to ");
                      String _literal_3 = ((PrimitiveAttribute) data).getAttribute().getDataType().getLiteral();
                      _builder_7.append(_literal_3);
                      EventCheck.this.addError(id, _builder_7.toString());
                    }
                  } else {
                    StringConcatenation _builder_8 = new StringConcatenation();
                    String _name_14 = port.getName();
                    _builder_8.append(_name_14);
                    _builder_8.append(" incompatible connected variable");
                    EventCheck.this.addError(id, _builder_8.toString());
                  }
                }
              }
            }
          }
        };
        ListExtensions.map(port.getOutgoing(), _function).forEach(_function_1);
      }
    };
    IterableExtensions.<OutputPort>filter(event.getOutputPorts(), _function_5).forEach(_function_6);
  }
  
  public void checkReadEdges(final GUIId id, final EventListener event) {
    final Function1<InputPort, EList<? extends Edge>> _function = new Function1<InputPort, EList<? extends Edge>>() {
      @Override
      public EList<? extends Edge> apply(final InputPort it) {
        return it.getIncoming();
      }
    };
    final Function1<Edge, Node> _function_1 = new Function1<Edge, Node>() {
      @Override
      public Node apply(final Edge it) {
        return it.getSourceElement();
      }
    };
    final Iterable<Node> connectedData = IterableExtensions.<Edge, Node>map(Iterables.<Edge>concat(ListExtensions.<InputPort, EList<? extends Edge>>map(event.getInputPorts(), _function)), _function_1);
    final Function1<Node, Node> _function_2 = new Function1<Node, Node>() {
      @Override
      public Node apply(final Node it) {
        return EventCheck.this.toRootScopeData(it);
      }
    };
    final Function1<Node, Boolean> _function_3 = new Function1<Node, Boolean>() {
      @Override
      public Boolean apply(final Node n) {
        return Boolean.valueOf((!Objects.equal(n, null)));
      }
    };
    final Consumer<Node> _function_4 = new Consumer<Node>() {
      @Override
      public void accept(final Node n) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = event.getName();
        _builder.append(_name);
        _builder.append(" reads from inner scope data");
        EventCheck.this.addError(id, _builder.toString());
      }
    };
    IterableExtensions.<Node>filter(IterableExtensions.<Node, Node>map(connectedData, _function_2), _function_3).forEach(_function_4);
  }
  
  public Node toRootScopeData(final Node node) {
    if ((node instanceof ComplexVariable)) {
      boolean _isEmpty = ((ComplexVariable)node).<ComplexAttributeConnector>getIncoming(ComplexAttributeConnector.class).isEmpty();
      boolean _not = (!_isEmpty);
      if (_not) {
        return this.toRootScopeData(((ComplexVariable)node).<ComplexAttributeConnector>getIncoming(ComplexAttributeConnector.class).get(0).getSourceElement());
      }
      boolean _isEmpty_1 = ((ComplexVariable)node).<ComplexListAttributeConnector>getIncoming(ComplexListAttributeConnector.class).isEmpty();
      boolean _not_1 = (!_isEmpty_1);
      if (_not_1) {
        final ComplexListAttributeConnector edge = ((ComplexVariable)node).<ComplexListAttributeConnector>getIncoming(ComplexListAttributeConnector.class).get(0);
        ComplexListAttributeName _attributeName = edge.getAttributeName();
        boolean _equals = Objects.equal(_attributeName, ComplexListAttributeName.CURRENT);
        if (_equals) {
          return edge.getSourceElement();
        }
        return this.toRootScopeData(edge.getSourceElement());
      }
    } else {
      if ((node instanceof Attribute)) {
        ModelElementContainer _container = ((Attribute)node).getContainer();
        return this.toRootScopeData(((Node) _container));
      }
    }
    return null;
  }
  
  @Override
  public void init() {
    HashSet<String> _hashSet = new HashSet<String>();
    this.knownNames = _hashSet;
  }
  
  /**
   * Checks, if a given event has a unique name
   * @param id
   * @param te
   */
  private void checkEventNames(final GUIId id, final Event te) {
    boolean _add = this.knownNames.add(te.getName());
    boolean _not = (!_add);
    if (_not) {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("Multiple events have the same name ");
      String _name = te.getName();
      _builder.append(_name);
      this.addError(id, _builder.toString());
    }
    final HashSet<String> knownPortNames = new HashSet<String>();
    final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
      @Override
      public Boolean apply(final OutputPort n) {
        boolean _add = knownPortNames.add(n.getName());
        return Boolean.valueOf((!_add));
      }
    };
    final Consumer<OutputPort> _function_1 = new Consumer<OutputPort>() {
      @Override
      public void accept(final OutputPort n) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Multiple ports have the same name ");
        String _name = n.getName();
        _builder.append(_name);
        EventCheck.this.addError(id, _builder.toString());
      }
    };
    IterableExtensions.<OutputPort>filter(te.getOutputPorts(), _function).forEach(_function_1);
  }
}
