/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.checks;

import graphmodel.ModelElementContainer;
import info.scce.dime.checks.AbstractCheck;
import info.scce.dime.gui.gui.ExtensionContext;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.mcam.adapter.GUIAdapter;
import info.scce.dime.gui.mcam.adapter.GUIId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;

/**
 * The embedded models check is used the validate that no inductive
 * structure is defined by the GUI SIBs placed in a given GUI model
 * @author zweihoff
 */
@SuppressWarnings("all")
public class EmbeddedModelsCheck extends AbstractCheck<GUIId, GUIAdapter> {
  private GUIAdapter adapter;
  
  /**
   * Checks if the given GUI model and the embedded GUI SIB define
   * no inductive structure
   */
  @Override
  public void doExecute(final GUIAdapter arg0) {
    this.adapter = arg0;
    List<GUIId> _entityIds = this.adapter.getEntityIds();
    for (final GUIId id : _entityIds) {
      {
        Object obj = id.getElement();
        if ((obj instanceof GUI)) {
          ArrayList<String> _arrayList = new ArrayList<String>();
          this.checkCycleInGuiReferences(id, ((GUI) obj), _arrayList);
        }
      }
    }
  }
  
  @Override
  public void init() {
  }
  
  /**
   * Checks if the given GUI is already known, so that a cycle is detected.
   * Otherwise the check is repeated for all GUI SIBs placed in the model
   * @param id
   * @param gui
   * @param knownGuiIds
   */
  private void checkCycleInGuiReferences(final GUIId id, final GUI gui, final ArrayList<String> knownGuiIds) {
    boolean _contains = knownGuiIds.contains(gui.getId());
    if (_contains) {
      this.addError(id, "cycle in gui references found");
      return;
    } else {
      knownGuiIds.add(gui.getId());
    }
    List<GUISIB> _containedGuiSibs = this.getContainedGuiSibs(gui);
    for (final GUISIB containedGuiSib : _containedGuiSibs) {
      GUI _gui = containedGuiSib.getGui();
      ArrayList<String> _arrayList = new ArrayList<String>(knownGuiIds);
      this.checkCycleInGuiReferences(id, _gui, _arrayList);
    }
  }
  
  /**
   * Returns a list of all GUI SIBs present anywhere in the given GUI model
   * @param gui
   * @return
   */
  private List<GUISIB> getContainedGuiSibs(final GUI gui) {
    ArrayList<GUISIB> list = new ArrayList<GUISIB>();
    TreeIterator<EObject> it = gui.eAllContents();
    while (it.hasNext()) {
      {
        Object obj = it.next();
        if ((obj instanceof GUISIB)) {
          ModelElementContainer _container = ((GUISIB)obj).getContainer();
          boolean _not = (!(_container instanceof ExtensionContext));
          if (_not) {
            GUISIB guiSib = ((GUISIB) obj);
            list.add(guiSib);
          }
        }
      }
    }
    return list;
  }
}
