/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.checks;

import de.jabc.cinco.meta.plugin.mcam.runtime.core.CincoCheckModule;
import graphmodel.Edge;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.checks.GUICheck;
import info.scce.dime.gui.gui.AddToSubmission;
import info.scce.dime.gui.gui.Attribute;
import info.scce.dime.gui.gui.Branch;
import info.scce.dime.gui.gui.ComplexAttributeConnector;
import info.scce.dime.gui.gui.ComplexListAttributeConnector;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.FormLoadSubmit;
import info.scce.dime.gui.gui.FormSubmit;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.OutputPort;
import info.scce.dime.gui.gui.Read;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class BranchCheck extends GUICheck {
  @Override
  public void check(final GUI model) {
    final Function1<Branch, EList<OutputPort>> _function = new Function1<Branch, EList<OutputPort>>() {
      @Override
      public EList<OutputPort> apply(final Branch it) {
        return it.getOutputPorts();
      }
    };
    final Consumer<OutputPort> _function_1 = new Consumer<OutputPort>() {
      @Override
      public void accept(final OutputPort it) {
        final Function1<OutputPort, Boolean> _function = new Function1<OutputPort, Boolean>() {
          @Override
          public Boolean apply(final OutputPort it) {
            return Boolean.valueOf(it.getOutgoing().isEmpty());
          }
        };
        CincoCheckModule.Check<OutputPort> _check = BranchCheck.this.<OutputPort>check(it, _function);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("No outgoing edges allowed for port ");
        String _name = it.getName();
        _builder.append(_name);
        _check.elseError(_builder.toString());
      }
    };
    IterableExtensions.<Branch, OutputPort>flatMap(this.guiex.<Branch>find(model, Branch.class), _function).forEach(_function_1);
    final Function1<Edge, Boolean> _function_2 = new Function1<Edge, Boolean>() {
      @Override
      public Boolean apply(final Edge it) {
        return Boolean.valueOf(((it instanceof FormSubmit) || (it instanceof FormLoadSubmit)));
      }
    };
    final Function1<Edge, Node> _function_3 = new Function1<Edge, Node>() {
      @Override
      public Node apply(final Edge it) {
        return it.getSourceElement();
      }
    };
    final Consumer<Node> _function_4 = new Consumer<Node>() {
      @Override
      public void accept(final Node it) {
        final Function1<Node, Boolean> _function = new Function1<Node, Boolean>() {
          @Override
          public Boolean apply(final Node it) {
            return Boolean.valueOf(BranchCheck.this.isReadOrSubmitted(it));
          }
        };
        BranchCheck.this.<Node>check(it, _function).elseError("Modified variable is not persisted");
      }
    };
    IterableExtensions.<Edge, Node>map(IterableExtensions.<Edge>filter(model.getAllEdges(), _function_2), _function_3).forEach(_function_4);
  }
  
  public boolean isReadOrSubmitted(final Node it) {
    boolean _switchResult = false;
    boolean _matched = false;
    if (it instanceof Attribute) {
      _matched=true;
      ModelElementContainer _container = ((Attribute)it).getContainer();
      _switchResult = this.isReadOrSubmitted(((ComplexVariable) _container));
    }
    if (!_matched) {
      _switchResult = ((!this.guiex.findSuccessorsVia(it, Read.class, AddToSubmission.class).isEmpty()) || IterableExtensions.<Node>exists(this.guiex.findPredecessorsVia(it, 
        ComplexAttributeConnector.class, ComplexListAttributeConnector.class), new Function1<Node, Boolean>() {
        @Override
        public Boolean apply(final Node it) {
          return Boolean.valueOf(BranchCheck.this.isReadOrSubmitted(it));
        }
      }));
    }
    return _switchResult;
  }
}
