/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import info.scce.dime.gui.actions.DIMEGUICustomAction;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.Box;
import info.scce.dime.gui.gui.Col;
import info.scce.dime.gui.gui.Form;
import info.scce.dime.gui.gui.GeneralStyling;
import info.scce.dime.gui.gui.Jumbotron;
import info.scce.dime.gui.gui.Panel;
import info.scce.dime.gui.gui.SecuritySIB;
import info.scce.dime.gui.gui.Tab;
import info.scce.dime.gui.gui.Template;
import info.scce.dime.gui.gui.Thumbnail;
import info.scce.dime.process.process.ProcessType;
import org.eclipse.emf.ecore.EObject;

/**
 * Context menu action, which updates a given GUI SIB.
 * The update process includes the input ports and the branches and their output ports.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class UpdateSecuritySIB extends DIMEGUICustomAction<SecuritySIB> {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Update security SIB";
  }
  
  /**
   * Checks if the reference to a GUI SIB is present and valid
   */
  @Override
  public boolean canExecute(final SecuritySIB guiSib) throws ClassCastException {
    boolean _switchResult = false;
    info.scce.dime.process.process.Process _proMod = guiSib.getProMod();
    final info.scce.dime.process.process.Process it = _proMod;
    boolean _matched = false;
    if (it instanceof info.scce.dime.process.process.Process) {
      _matched=true;
      ProcessType _processType = it.getProcessType();
      _switchResult = Objects.equal(_processType, ProcessType.SECURITY);
    }
    return _switchResult;
  }
  
  /**
   * Updates the given GUI SIB.
   * The update process creates a new GUI SIB
   * and uses the semantics of the post create hook to
   * consider all changes.
   * In a second step, the data flow edges are reconnected
   * and the out dated GUI SIB is removed, so that
   * the new SIB is in the same position
   */
  @Override
  public void execute(final SecuritySIB guiSib) {
    final info.scce.dime.process.process.Process model = guiSib.getProMod();
    if ((Boolean.valueOf((model instanceof info.scce.dime.process.process.Process)) == Boolean.valueOf(false))) {
      this._gUIActionExtension.showDialog("Referenced model is null", "Update failed. Referenced model is null!");
      return;
    }
    EObject eObj = ReferenceRegistry.getInstance().getEObject(guiSib.getLibraryComponentUID());
    if (((eObj == null) || (Boolean.valueOf((eObj instanceof info.scce.dime.process.process.Process)) == Boolean.valueOf(false)))) {
      this._gUIActionExtension.showDialog("Reference is null", "Update failed. Reference is null!");
      return;
    }
    SecuritySIB newSecuritySIB = null;
    EObject container = guiSib.getContainer();
    if ((container instanceof Template)) {
      Template n = ((Template) container);
      int _x = guiSib.getX();
      int _plus = (_x + 1);
      int _y = guiSib.getY();
      int _plus_1 = (_y + 1);
      newSecuritySIB = n.newSecuritySIB(eObj, _plus, _plus_1);
    }
    if ((container instanceof Col)) {
      Col n_1 = ((Col) container);
      int _x_1 = guiSib.getX();
      int _plus_2 = (_x_1 + 1);
      int _y_1 = guiSib.getY();
      int _plus_3 = (_y_1 + 1);
      newSecuritySIB = n_1.newSecuritySIB(eObj, _plus_2, _plus_3);
    }
    if ((container instanceof Tab)) {
      Tab n_2 = ((Tab) container);
      int _x_2 = guiSib.getX();
      int _plus_4 = (_x_2 + 1);
      int _y_2 = guiSib.getY();
      int _plus_5 = (_y_2 + 1);
      newSecuritySIB = n_2.newSecuritySIB(eObj, _plus_4, _plus_5);
    }
    if ((container instanceof Argument)) {
      Argument n_3 = ((Argument) container);
      int _x_3 = guiSib.getX();
      int _plus_6 = (_x_3 + 1);
      int _y_3 = guiSib.getY();
      int _plus_7 = (_y_3 + 1);
      newSecuritySIB = n_3.newSecuritySIB(eObj, _plus_6, _plus_7);
    }
    if ((container instanceof Panel)) {
      Panel n_4 = ((Panel) container);
      int _x_4 = guiSib.getX();
      int _plus_8 = (_x_4 + 1);
      int _y_4 = guiSib.getY();
      int _plus_9 = (_y_4 + 1);
      newSecuritySIB = n_4.newSecuritySIB(eObj, _plus_8, _plus_9);
    }
    if ((container instanceof Jumbotron)) {
      Jumbotron n_5 = ((Jumbotron) container);
      int _x_5 = guiSib.getX();
      int _plus_10 = (_x_5 + 1);
      int _y_5 = guiSib.getY();
      int _plus_11 = (_y_5 + 1);
      newSecuritySIB = n_5.newSecuritySIB(eObj, _plus_10, _plus_11);
    }
    if ((container instanceof Box)) {
      Box n_6 = ((Box) container);
      int _x_6 = guiSib.getX();
      int _plus_12 = (_x_6 + 1);
      int _y_6 = guiSib.getY();
      int _plus_13 = (_y_6 + 1);
      newSecuritySIB = n_6.newSecuritySIB(eObj, _plus_12, _plus_13);
    }
    if ((container instanceof Form)) {
      Form n_7 = ((Form) container);
      int _x_7 = guiSib.getX();
      int _plus_14 = (_x_7 + 1);
      int _y_7 = guiSib.getY();
      int _plus_15 = (_y_7 + 1);
      newSecuritySIB = n_7.newSecuritySIB(eObj, _plus_14, _plus_15);
    }
    if ((container instanceof Thumbnail)) {
      Thumbnail n_8 = ((Thumbnail) container);
      int _x_8 = guiSib.getX();
      int _plus_16 = (_x_8 + 1);
      int _y_8 = guiSib.getY();
      int _plus_17 = (_y_8 + 1);
      newSecuritySIB = n_8.newSecuritySIB(eObj, _plus_16, _plus_17);
    }
    GeneralStyling _generalStyle = guiSib.getGeneralStyle();
    boolean _notEquals = this._gUIExtension.operator_notEquals(_generalStyle, null);
    if (_notEquals) {
      newSecuritySIB.setGeneralStyle(guiSib.getGeneralStyle());
    }
    this._gUIActionExtension.rebuildPorts(guiSib, newSecuritySIB);
    guiSib.delete();
  }
}
