/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import graphmodel.ModelElementContainer;
import info.scce.dime.gui.actions.DIMEGUICustomAction;
import info.scce.dime.gui.gui.Alert;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.Box;
import info.scce.dime.gui.gui.Col;
import info.scce.dime.gui.gui.Form;
import info.scce.dime.gui.gui.GUISIBModal;
import info.scce.dime.gui.gui.GeneralStyling;
import info.scce.dime.gui.gui.Jumbotron;
import info.scce.dime.gui.gui.Panel;
import info.scce.dime.gui.gui.ProcessSIB;
import info.scce.dime.gui.gui.Tab;
import info.scce.dime.gui.gui.TableEntry;
import info.scce.dime.gui.gui.Template;
import info.scce.dime.gui.gui.Thumbnail;
import org.eclipse.emf.ecore.EObject;

/**
 * Context menu action, which updates a given Process SIB.
 * The update process includes the input ports and the branches and their output ports.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class UpdateProcessSIB extends DIMEGUICustomAction<ProcessSIB> {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Update Process SIB";
  }
  
  /**
   * Checks if the reference to a Process SIB is present and valid
   */
  @Override
  public boolean canExecute(final ProcessSIB sib) {
    EObject _eObject = ReferenceRegistry.getInstance().getEObject(sib.getLibraryComponentUID());
    return (!Objects.equal(_eObject, null));
  }
  
  /**
   * Updates the given Process SIB.
   * The update process creates a new Process SIB
   * and uses the semantics of the post create hook to
   * consider all changes.
   * In a second step, the data flow edges are reconnected
   * and the out dated Interaction SIB is removed, so that
   * the new SIB is in the same position
   */
  @Override
  public void execute(final ProcessSIB sib) {
    EObject eObj = sib.getProMod();
    if (((eObj == null) || (Boolean.valueOf((eObj instanceof info.scce.dime.process.process.Process)) == Boolean.valueOf(false)))) {
      this._gUIActionExtension.showDialog("Reference is null", "Update failed. Reference is null!");
      return;
    }
    ProcessSIB newSIB = this.createSIB(sib);
    boolean _equals = this._gUIExtension.operator_equals(newSIB, null);
    if (_equals) {
      return;
    }
    GeneralStyling _generalStyle = sib.getGeneralStyle();
    boolean _notEquals = this._gUIExtension.operator_notEquals(_generalStyle, null);
    if (_notEquals) {
      newSIB.setGeneralStyle(sib.getGeneralStyle());
    }
    GUISIBModal _modal = sib.getModal();
    boolean _notEquals_1 = this._gUIExtension.operator_notEquals(_modal, null);
    if (_notEquals_1) {
      newSIB.setModal(sib.getModal());
    }
    this._gUIActionExtension.rebuildPorts(sib, newSIB);
    sib.delete();
  }
  
  public ProcessSIB createSIB(final ProcessSIB sib) {
    ProcessSIB _xblockexpression = null;
    {
      final info.scce.dime.process.process.Process process = sib.getProMod();
      final int x = sib.getX();
      final int y = sib.getY();
      ProcessSIB _switchResult = null;
      ModelElementContainer _container = sib.getContainer();
      final ModelElementContainer it = _container;
      boolean _matched = false;
      if (it instanceof Alert) {
        _matched=true;
        _switchResult = ((Alert)it).newProcessSIB(process, x, y);
      }
      if (!_matched) {
        if (it instanceof Argument) {
          _matched=true;
          _switchResult = ((Argument)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Box) {
          _matched=true;
          _switchResult = ((Box)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Col) {
          _matched=true;
          _switchResult = ((Col)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Form) {
          _matched=true;
          _switchResult = ((Form)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Jumbotron) {
          _matched=true;
          _switchResult = ((Jumbotron)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Panel) {
          _matched=true;
          _switchResult = ((Panel)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Tab) {
          _matched=true;
          _switchResult = ((Tab)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof TableEntry) {
          _matched=true;
          _switchResult = ((TableEntry)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Template) {
          _matched=true;
          _switchResult = ((Template)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Thumbnail) {
          _matched=true;
          _switchResult = ((Thumbnail)it).newProcessSIB(process, x, y);
        }
      }
      if (!_matched) {
        {
          this._gUIActionExtension.showDialog("Unknown container", "Update failed: No handler for the SIB\'s container");
          return null;
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
}
