/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import com.google.common.base.Objects;
import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import info.scce.dime.gui.actions.DIMEGUICustomAction;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.Box;
import info.scce.dime.gui.gui.Col;
import info.scce.dime.gui.gui.Form;
import info.scce.dime.gui.gui.GeneralStyling;
import info.scce.dime.gui.gui.Jumbotron;
import info.scce.dime.gui.gui.LinkProcessSIB;
import info.scce.dime.gui.gui.Panel;
import info.scce.dime.gui.gui.Tab;
import info.scce.dime.gui.gui.Template;
import info.scce.dime.gui.gui.Thumbnail;
import org.eclipse.emf.ecore.EObject;

/**
 * Context menu action, which updates a given Link Process SIB.
 * The update process includes the input ports and the branches and their output ports.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class UpdateLinkProcessSIB extends DIMEGUICustomAction<LinkProcessSIB> {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Update Link SIB";
  }
  
  /**
   * Checks if the reference to a Link Process SIB is present and valid
   */
  @Override
  public boolean canExecute(final LinkProcessSIB sib) {
    EObject _eObject = ReferenceRegistry.getInstance().getEObject(sib.getLibraryComponentUID());
    return (!Objects.equal(_eObject, null));
  }
  
  /**
   * Updates the given Link Process SIB.
   * The update process creates a new Link Process SIB
   * and uses the semantics of the post create hook to
   * consider all changes.
   * In a second step, the data flow edges are reconnected
   * and the out dated Link Process SIB is removed, so that
   * the new SIB is in the same position
   */
  @Override
  public void execute(final LinkProcessSIB sib) {
    EObject eObj = sib.getProMod();
    if (((eObj == null) || (Boolean.valueOf((eObj instanceof info.scce.dime.process.process.Process)) == Boolean.valueOf(false)))) {
      this._gUIActionExtension.showDialog("Reference is null", "Update failed. Reference is null!");
      return;
    }
    LinkProcessSIB newSIB = null;
    EObject container = sib.getContainer();
    if ((container instanceof Template)) {
      Template n = ((Template) container);
      int _x = sib.getX();
      int _plus = (_x + 1);
      int _y = sib.getY();
      int _plus_1 = (_y + 1);
      newSIB = n.newLinkProcessSIB(eObj, _plus, _plus_1);
    }
    if ((container instanceof Col)) {
      Col n_1 = ((Col) container);
      int _x_1 = sib.getX();
      int _plus_2 = (_x_1 + 1);
      int _y_1 = sib.getY();
      int _plus_3 = (_y_1 + 1);
      newSIB = n_1.newLinkProcessSIB(eObj, _plus_2, _plus_3);
    }
    if ((container instanceof Tab)) {
      Tab n_2 = ((Tab) container);
      int _x_2 = sib.getX();
      int _plus_4 = (_x_2 + 1);
      int _y_2 = sib.getY();
      int _plus_5 = (_y_2 + 1);
      newSIB = n_2.newLinkProcessSIB(eObj, _plus_4, _plus_5);
    }
    if ((container instanceof Argument)) {
      Argument n_3 = ((Argument) container);
      int _x_3 = sib.getX();
      int _plus_6 = (_x_3 + 1);
      int _y_3 = sib.getY();
      int _plus_7 = (_y_3 + 1);
      newSIB = n_3.newLinkProcessSIB(eObj, _plus_6, _plus_7);
    }
    if ((container instanceof Panel)) {
      Panel n_4 = ((Panel) container);
      int _x_4 = sib.getX();
      int _plus_8 = (_x_4 + 1);
      int _y_4 = sib.getY();
      int _plus_9 = (_y_4 + 1);
      newSIB = n_4.newLinkProcessSIB(eObj, _plus_8, _plus_9);
    }
    if ((container instanceof Jumbotron)) {
      Jumbotron n_5 = ((Jumbotron) container);
      int _x_5 = sib.getX();
      int _plus_10 = (_x_5 + 1);
      int _y_5 = sib.getY();
      int _plus_11 = (_y_5 + 1);
      newSIB = n_5.newLinkProcessSIB(eObj, _plus_10, _plus_11);
    }
    if ((container instanceof Box)) {
      Box n_6 = ((Box) container);
      int _x_6 = sib.getX();
      int _plus_12 = (_x_6 + 1);
      int _y_6 = sib.getY();
      int _plus_13 = (_y_6 + 1);
      newSIB = n_6.newLinkProcessSIB(eObj, _plus_12, _plus_13);
    }
    if ((container instanceof Form)) {
      Form n_7 = ((Form) container);
      int _x_7 = sib.getX();
      int _plus_14 = (_x_7 + 1);
      int _y_7 = sib.getY();
      int _plus_15 = (_y_7 + 1);
      newSIB = n_7.newLinkProcessSIB(eObj, _plus_14, _plus_15);
    }
    if ((container instanceof Thumbnail)) {
      Thumbnail n_8 = ((Thumbnail) container);
      int _x_8 = sib.getX();
      int _plus_16 = (_x_8 + 1);
      int _y_8 = sib.getY();
      int _plus_17 = (_y_8 + 1);
      newSIB = n_8.newLinkProcessSIB(eObj, _plus_16, _plus_17);
    }
    GeneralStyling _generalStyle = sib.getGeneralStyle();
    boolean _notEquals = this._gUIExtension.operator_notEquals(_generalStyle, null);
    if (_notEquals) {
      newSIB.setGeneralStyle(sib.getGeneralStyle());
    }
    this._gUIActionExtension.rebuildPorts(sib, newSIB);
    sib.delete();
  }
}
