/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import com.google.common.base.Objects;
import graphmodel.ModelElementContainer;
import info.scce.dime.gui.actions.DIMEGUICustomAction;
import info.scce.dime.gui.gui.Alert;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.BaseElement;
import info.scce.dime.gui.gui.Box;
import info.scce.dime.gui.gui.Col;
import info.scce.dime.gui.gui.ExtensionContext;
import info.scce.dime.gui.gui.Form;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.GeneralStyling;
import info.scce.dime.gui.gui.Jumbotron;
import info.scce.dime.gui.gui.Panel;
import info.scce.dime.gui.gui.Tab;
import info.scce.dime.gui.gui.TableEntry;
import info.scce.dime.gui.gui.Template;
import info.scce.dime.gui.gui.Thumbnail;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;

/**
 * Context menu action, which updates a given GUI SIB.
 * The update process includes the input ports and the branches and their output ports.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class UpdateGuiSIB extends DIMEGUICustomAction<GUISIB> {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Update GuiSIB";
  }
  
  /**
   * Checks if the reference to a GUI SIB is present and valid
   */
  @Override
  public boolean canExecute(final GUISIB guiSib) {
    GUI _gui = guiSib.getGui();
    return this._gUIExtension.operator_notEquals(_gui, null);
  }
  
  /**
   * Updates the given GUI SIB.
   * The update process creates a new GUI SIB
   * and uses the semantics of the post create hook to
   * consider all changes.
   * In a second step, the data flow edges are reconnected
   * and the out dated GUI SIB is removed, so that
   * the new SIB is in the same position
   */
  @Override
  public void execute(final GUISIB guiSib) {
    this.updateSIB(guiSib);
  }
  
  public void updateSIB(final GUISIB guiSIB) {
    final GUI gui = guiSIB.getGui();
    boolean _equals = this._gUIExtension.operator_equals(gui, null);
    if (_equals) {
      this._gUIActionExtension.showDialog("Referenced model is null", "Update failed. Referenced model is null!");
      return;
    }
    final GUISIB newSIB = this.createSIB(guiSIB);
    boolean _equals_1 = this._gUIExtension.operator_equals(newSIB, null);
    if (_equals_1) {
      return;
    }
    newSIB.setModal(guiSIB.getModal());
    newSIB.setName(guiSIB.getName());
    GeneralStyling _generalStyle = guiSIB.getGeneralStyle();
    boolean _notEquals = this._gUIExtension.operator_notEquals(_generalStyle, null);
    if (_notEquals) {
      newSIB.setGeneralStyle(guiSIB.getGeneralStyle());
    }
    final Procedure1<GUISIB> _function = new Procedure1<GUISIB>() {
      @Override
      public void apply(final GUISIB it) {
        UpdateGuiSIB.this._gUIActionExtension.rebuildPorts(it, newSIB);
        final Consumer<Argument> _function = new Consumer<Argument>() {
          @Override
          public void accept(final Argument arg) {
            final Consumer<BaseElement> _function = new Consumer<BaseElement>() {
              @Override
              public void accept(final BaseElement it) {
                final Function1<Argument, Boolean> _function = new Function1<Argument, Boolean>() {
                  @Override
                  public Boolean apply(final Argument it) {
                    String _blockName = it.getBlockName();
                    String _blockName_1 = arg.getBlockName();
                    return Boolean.valueOf(Objects.equal(_blockName, _blockName_1));
                  }
                };
                it.moveTo(IterableExtensions.<Argument>findFirst(newSIB.getArguments(), _function), it.getX(), it.getY());
              }
            };
            arg.getBaseElements().forEach(_function);
          }
        };
        it.getArguments().forEach(_function);
        it.delete();
      }
    };
    ObjectExtensions.<GUISIB>operator_doubleArrow(guiSIB, _function);
  }
  
  public GUISIB createSIB(final GUISIB guiSIB) {
    GUISIB _xblockexpression = null;
    {
      final GUI gui = guiSIB.getGui();
      final int x = guiSIB.getX();
      final int y = guiSIB.getY();
      GUISIB _switchResult = null;
      ModelElementContainer _container = guiSIB.getContainer();
      final ModelElementContainer it = _container;
      boolean _matched = false;
      if (it instanceof Alert) {
        _matched=true;
        _switchResult = ((Alert)it).newGUISIB(guiSIB.getGui(), x, y);
      }
      if (!_matched) {
        if (it instanceof Argument) {
          _matched=true;
          _switchResult = ((Argument)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Box) {
          _matched=true;
          _switchResult = ((Box)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Col) {
          _matched=true;
          _switchResult = ((Col)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof ExtensionContext) {
          _matched=true;
          _switchResult = ((ExtensionContext)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Form) {
          _matched=true;
          _switchResult = ((Form)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Jumbotron) {
          _matched=true;
          _switchResult = ((Jumbotron)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Panel) {
          _matched=true;
          _switchResult = ((Panel)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Tab) {
          _matched=true;
          _switchResult = ((Tab)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof TableEntry) {
          _matched=true;
          _switchResult = ((TableEntry)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Template) {
          _matched=true;
          _switchResult = ((Template)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Thumbnail) {
          _matched=true;
          _switchResult = ((Thumbnail)it).newGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        {
          this._gUIActionExtension.showDialog("Unknown container", "Update failed: No handler for the SIB\'s container");
          return null;
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
}
