/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import info.scce.dime.gUIPlugin.Function;
import info.scce.dime.gui.actions.DIMEGUICustomAction;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.BaseElement;
import info.scce.dime.gui.gui.Box;
import info.scce.dime.gui.gui.Col;
import info.scce.dime.gui.gui.Form;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GUIPlugin;
import info.scce.dime.gui.gui.GeneralStyling;
import info.scce.dime.gui.gui.Jumbotron;
import info.scce.dime.gui.gui.Panel;
import info.scce.dime.gui.gui.Tab;
import info.scce.dime.gui.gui.Template;
import info.scce.dime.gui.gui.Thumbnail;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Context menu action, which updates a given GUI plug in SIB.
 * The update process includes the input ports and the branches and their output ports.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class UpdateGuiPlugin extends DIMEGUICustomAction<GUIPlugin> {
  private GUI parentGUI;
  
  private Function refGui;
  
  private GUIPlugin sib;
  
  private EObject eObj;
  
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Update GuiPlugin";
  }
  
  /**
   * Checks if the reference to a GUI plug in is present and valid
   */
  @Override
  public boolean canExecute(final GUIPlugin guiSib) throws ClassCastException {
    EObject eObj = guiSib.getFunction();
    if (((eObj == null) || (Boolean.valueOf((eObj instanceof Function)) == Boolean.valueOf(false)))) {
      return false;
    }
    return true;
  }
  
  /**
   * Updates the given GUI plug in SIB.
   */
  @Override
  public void execute(final GUIPlugin guiSib) {
    this.eObj = guiSib.getFunction();
    if (((this.eObj == null) || (Boolean.valueOf((this.eObj instanceof Function)) == Boolean.valueOf(false)))) {
      this._gUIActionExtension.showDialog("Reference is null", "GUI Plugin Update failed. Reference is null!");
      return;
    }
    this.refGui = ((Function) this.eObj);
    this.sib = guiSib;
    this.parentGUI = this.sib.getRootElement();
    this.updateSib();
  }
  
  /**
   * The update process creates a new GUI plug in SIB
   * and uses the semantics of the post create hook to
   * consider all changes.
   * In a second step, the data flow edges are reconnected
   * and the out dated GUI plug in SIB is removed, so that
   * the new SIB is in the same position
   */
  private void updateSib() {
    this.sib.setLabel(this.refGui.getFunctionName());
    GUIPlugin newGUIPlugin = null;
    EObject container = this.sib.getContainer();
    if ((container instanceof Template)) {
      Template n = ((Template) container);
      int _x = this.sib.getX();
      int _plus = (_x + 1);
      int _y = this.sib.getY();
      int _plus_1 = (_y + 1);
      newGUIPlugin = n.newGUIPlugin(this.eObj, _plus, _plus_1);
    }
    if ((container instanceof Col)) {
      Col n_1 = ((Col) container);
      int _x_1 = this.sib.getX();
      int _plus_2 = (_x_1 + 1);
      int _y_1 = this.sib.getY();
      int _plus_3 = (_y_1 + 1);
      newGUIPlugin = n_1.newGUIPlugin(this.eObj, _plus_2, _plus_3);
    }
    if ((container instanceof Tab)) {
      Tab n_2 = ((Tab) container);
      int _x_2 = this.sib.getX();
      int _plus_4 = (_x_2 + 1);
      int _y_2 = this.sib.getY();
      int _plus_5 = (_y_2 + 1);
      newGUIPlugin = n_2.newGUIPlugin(this.eObj, _plus_4, _plus_5);
    }
    if ((container instanceof Argument)) {
      Argument n_3 = ((Argument) container);
      int _x_3 = this.sib.getX();
      int _plus_6 = (_x_3 + 1);
      int _y_3 = this.sib.getY();
      int _plus_7 = (_y_3 + 1);
      newGUIPlugin = n_3.newGUIPlugin(this.eObj, _plus_6, _plus_7);
    }
    if ((container instanceof Panel)) {
      Panel n_4 = ((Panel) container);
      int _x_4 = this.sib.getX();
      int _plus_8 = (_x_4 + 1);
      int _y_4 = this.sib.getY();
      int _plus_9 = (_y_4 + 1);
      newGUIPlugin = n_4.newGUIPlugin(this.eObj, _plus_8, _plus_9);
    }
    if ((container instanceof Jumbotron)) {
      Jumbotron n_5 = ((Jumbotron) container);
      int _x_5 = this.sib.getX();
      int _plus_10 = (_x_5 + 1);
      int _y_5 = this.sib.getY();
      int _plus_11 = (_y_5 + 1);
      newGUIPlugin = n_5.newGUIPlugin(this.eObj, _plus_10, _plus_11);
    }
    if ((container instanceof Box)) {
      Box n_6 = ((Box) container);
      int _x_6 = this.sib.getX();
      int _plus_12 = (_x_6 + 1);
      int _y_6 = this.sib.getY();
      int _plus_13 = (_y_6 + 1);
      newGUIPlugin = n_6.newGUIPlugin(this.eObj, _plus_12, _plus_13);
    }
    if ((container instanceof Form)) {
      Form n_7 = ((Form) container);
      int _x_7 = this.sib.getX();
      int _plus_14 = (_x_7 + 1);
      int _y_7 = this.sib.getY();
      int _plus_15 = (_y_7 + 1);
      newGUIPlugin = n_7.newGUIPlugin(this.eObj, _plus_14, _plus_15);
    }
    if ((container instanceof Thumbnail)) {
      Thumbnail n_8 = ((Thumbnail) container);
      int _x_8 = this.sib.getX();
      int _plus_16 = (_x_8 + 1);
      int _y_8 = this.sib.getY();
      int _plus_17 = (_y_8 + 1);
      newGUIPlugin = n_8.newGUIPlugin(this.eObj, _plus_16, _plus_17);
    }
    this.parentGUI = this.sib.getRootElement();
    GeneralStyling _generalStyle = this.sib.getGeneralStyle();
    boolean _notEquals = this._gUIExtension.operator_notEquals(_generalStyle, null);
    if (_notEquals) {
      newGUIPlugin.setGeneralStyle(this.sib.getGeneralStyle());
    }
    this._gUIActionExtension.rebuildPorts(this.sib, newGUIPlugin);
    if (((!this.sib.getArguments().isEmpty()) && (!newGUIPlugin.getArguments().isEmpty()))) {
      final GUIPlugin fg = newGUIPlugin;
      final Consumer<Argument> _function = new Consumer<Argument>() {
        @Override
        public void accept(final Argument e) {
          final Consumer<BaseElement> _function = new Consumer<BaseElement>() {
            @Override
            public void accept(final BaseElement n) {
              final Function1<Argument, Boolean> _function = new Function1<Argument, Boolean>() {
                @Override
                public Boolean apply(final Argument it) {
                  return Boolean.valueOf(it.getBlockName().equals(e.getBlockName()));
                }
              };
              n.moveTo(IterableExtensions.<Argument>findFirst(fg.getArguments(), _function), n.getX(), n.getY());
            }
          };
          e.getBaseElements().forEach(_function);
        }
      };
      this.sib.getArguments().forEach(_function);
    }
    this.sib.delete();
  }
}
