/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import de.jabc.cinco.meta.core.referenceregistry.ReferenceRegistry;
import graphmodel.ModelElementContainer;
import info.scce.dime.gui.actions.DIMEGUICustomAction;
import info.scce.dime.gui.gui.File;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GeneralStyling;
import info.scce.dime.gui.gui.GuardSIB;
import info.scce.dime.gui.gui.Image;
import info.scce.dime.process.process.ProcessType;
import org.eclipse.emf.ecore.EObject;

/**
 * Context menu action, which updates a given GUI SIB.
 * The update process includes the input ports and the branches and their output ports.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class UpdateGuardSIB extends DIMEGUICustomAction<GuardSIB> {
  private GUI parentGUI;
  
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Update GuardSIB";
  }
  
  /**
   * Checks if the reference to a GUI SIB is present and valid
   */
  @Override
  public boolean canExecute(final GuardSIB guiSib) throws ClassCastException {
    EObject _eObject = ReferenceRegistry.getInstance().getEObject(guiSib.getLibraryComponentUID());
    info.scce.dime.process.process.Process eObj = ((info.scce.dime.process.process.Process) _eObject);
    if (((eObj == null) || (Boolean.valueOf((eObj instanceof info.scce.dime.process.process.Process)) == Boolean.valueOf(false)))) {
      return false;
    }
    ProcessType _processType = eObj.getProcessType();
    boolean _tripleNotEquals = (_processType != ProcessType.FILE_DOWNLOAD_SECURITY);
    if (_tripleNotEquals) {
      return false;
    }
    return true;
  }
  
  /**
   * Updates the given GUI SIB.
   * The update process creates a new GUI SIB
   * and uses the semantics of the post create hook to
   * consider all changes.
   * In a second step, the data flow edges are reconnected
   * and the out dated GUI SIB is removed, so that
   * the new SIB is in the same position
   */
  @Override
  public void execute(final GuardSIB guiSib) {
    EObject _eObject = ReferenceRegistry.getInstance().getEObject(guiSib.getLibraryComponentUID());
    info.scce.dime.process.process.Process eObj = ((info.scce.dime.process.process.Process) _eObject);
    if (((eObj == null) || (Boolean.valueOf((eObj instanceof info.scce.dime.process.process.Process)) == Boolean.valueOf(false)))) {
      this._gUIActionExtension.showDialog("Reference is null", "Update failed. Reference is null!");
      return;
    }
    GuardSIB newGuardSIB = null;
    ModelElementContainer container = guiSib.getContainer();
    if ((container instanceof File)) {
      File n = ((File) container);
      int _x = guiSib.getX();
      int _plus = (_x + 1);
      int _y = guiSib.getY();
      int _plus_1 = (_y + 1);
      newGuardSIB = n.newGuardSIB(eObj, _plus, _plus_1);
    }
    if ((container instanceof Image)) {
      Image n_1 = ((Image) container);
      int _x_1 = guiSib.getX();
      int _plus_2 = (_x_1 + 1);
      int _y_1 = guiSib.getY();
      int _plus_3 = (_y_1 + 1);
      newGuardSIB = n_1.newGuardSIB(eObj, _plus_2, _plus_3);
    }
    this.parentGUI = guiSib.getRootElement();
    GeneralStyling _generalStyle = guiSib.getGeneralStyle();
    boolean _tripleNotEquals = (_generalStyle != null);
    if (_tripleNotEquals) {
      newGuardSIB.setGeneralStyle(guiSib.getGeneralStyle());
    }
    this._gUIActionExtension.rebuildPorts(guiSib, newGuardSIB);
    guiSib.delete();
  }
}
