/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import graphmodel.ModelElementContainer;
import info.scce.dime.gui.actions.UpdateGuiSIB;
import info.scce.dime.gui.gui.Alert;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.Box;
import info.scce.dime.gui.gui.Col;
import info.scce.dime.gui.gui.DispatchedGUISIB;
import info.scce.dime.gui.gui.ExtensionContext;
import info.scce.dime.gui.gui.Form;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.Jumbotron;
import info.scce.dime.gui.gui.Panel;
import info.scce.dime.gui.gui.Tab;
import info.scce.dime.gui.gui.TableEntry;
import info.scce.dime.gui.gui.Template;
import info.scce.dime.gui.gui.Thumbnail;

/**
 * Context menu action, which updates a given GUI SIB.
 * The update process includes the input ports and the branches and their output ports.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class UpdateDispatchedGuiSIB extends UpdateGuiSIB {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Update dispatched GuiSIB";
  }
  
  @Override
  public GUISIB createSIB(final GUISIB guiSIB) {
    DispatchedGUISIB _xblockexpression = null;
    {
      final GUI gui = guiSIB.getGui();
      final int x = guiSIB.getX();
      final int y = guiSIB.getY();
      DispatchedGUISIB _switchResult = null;
      ModelElementContainer _container = guiSIB.getContainer();
      final ModelElementContainer it = _container;
      boolean _matched = false;
      if (it instanceof Alert) {
        _matched=true;
        _switchResult = ((Alert)it).newDispatchedGUISIB(gui, x, y);
      }
      if (!_matched) {
        if (it instanceof Argument) {
          _matched=true;
          _switchResult = ((Argument)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Box) {
          _matched=true;
          _switchResult = ((Box)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Col) {
          _matched=true;
          _switchResult = ((Col)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof ExtensionContext) {
          _matched=true;
          _switchResult = ((ExtensionContext)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Form) {
          _matched=true;
          _switchResult = ((Form)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Jumbotron) {
          _matched=true;
          _switchResult = ((Jumbotron)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Panel) {
          _matched=true;
          _switchResult = ((Panel)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Tab) {
          _matched=true;
          _switchResult = ((Tab)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof TableEntry) {
          _matched=true;
          _switchResult = ((TableEntry)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Template) {
          _matched=true;
          _switchResult = ((Template)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        if (it instanceof Thumbnail) {
          _matched=true;
          _switchResult = ((Thumbnail)it).newDispatchedGUISIB(gui, x, y);
        }
      }
      if (!_matched) {
        {
          this._gUIActionExtension.showDialog("Unknown container", "Update failed: No handler for the SIB\'s container");
          return null;
        }
      }
      _xblockexpression = _switchResult;
    }
    return _xblockexpression;
  }
}
