/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import graphmodel.ModelElementContainer;
import info.scce.dime.gui.actions.DIMEGUICustomAction;
import info.scce.dime.gui.actions.UpdateGuiSIB;
import info.scce.dime.gui.gui.DispatchedGUISIB;
import info.scce.dime.gui.gui.ExtensionContext;

/**
 * Context menu action, which updates a given GUI SIB.
 * The update process includes the input ports and the branches and their output ports.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class UnDispatchGuiSIB extends DIMEGUICustomAction<DispatchedGUISIB> {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Deactivate Dispatching";
  }
  
  /**
   * Checks if the GUI SIB is dispatched
   */
  @Override
  public boolean canExecute(final DispatchedGUISIB guiSib) {
    ModelElementContainer _container = guiSib.getContainer();
    return (!(_container instanceof ExtensionContext));
  }
  
  @Override
  public void execute(final DispatchedGUISIB guiSib) {
    new UpdateGuiSIB().updateSIB(guiSib);
  }
}
