/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.ControlSIB;
import info.scce.dime.gui.gui.IO;
import info.scce.dime.gui.hooks.CreateComponentHook;
import info.scce.dime.process.helper.LayoutConstants;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Adds input ports to a given IF SIB
 * @author zweihoff
 */
@SuppressWarnings("all")
public class RemovePrimitivePort<T extends IO> extends DIMECustomAction<IO> {
  /**
   * Returns the name displayed in the context menu
   */
  @Override
  public String getName() {
    return "Remove input port";
  }
  
  /**
   * Input ports can always be added
   */
  @Override
  public boolean canExecute(final IO node) throws ClassCastException {
    ModelElementContainer _container = node.getContainer();
    return (_container instanceof ControlSIB);
  }
  
  /**
   * Creates a new primitive input port
   */
  @Override
  public void execute(final IO io) {
    ModelElementContainer _container = io.getContainer();
    final ControlSIB node = ((ControlSIB) _container);
    final Function1<IO, Boolean> _function = new Function1<IO, Boolean>() {
      @Override
      public Boolean apply(final IO it) {
        boolean _equals = it.getId().equals(io.getId());
        return Boolean.valueOf((!_equals));
      }
    };
    final Consumer<IO> _function_1 = new Consumer<IO>() {
      @Override
      public void accept(final IO n) {
        int _y = n.getY();
        int _y_1 = io.getY();
        boolean _greaterEqualsThan = (_y >= _y_1);
        if (_greaterEqualsThan) {
          int _y_2 = n.getY();
          int _minus = (_y_2 - LayoutConstants.PORT_SPACE);
          n.setY(_minus);
        }
      }
    };
    IterableExtensions.<IO>filter(node.getIOs(), _function).forEach(_function_1);
    final Consumer<Argument> _function_2 = new Consumer<Argument>() {
      @Override
      public void accept(final Argument n) {
        int _y = n.getY();
        int _minus = (_y - LayoutConstants.PORT_SPACE);
        n.setY(_minus);
      }
    };
    node.getArguments().forEach(_function_2);
    int _width = node.getWidth();
    int _height = node.getHeight();
    int _minus = (_height - LayoutConstants.PORT_SPACE);
    node.resize(_width, _minus);
    io.delete();
    CreateComponentHook cch = new CreateComponentHook();
    cch.postCreate(node);
  }
}
