/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.FORSIB;
import info.scce.dime.gui.hooks.CreateComponentHook;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Removes the Else argument of an IF SIB.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class RemoveEmptyFORSIB extends DIMECustomAction<FORSIB> {
  /**
   * Returns the name displayed in the context menu
   */
  @Override
  public String getName() {
    return "remove empty";
  }
  
  /**
   * Checks if a footer template is already present in the given GUI model
   */
  @Override
  public boolean canExecute(final FORSIB node) throws ClassCastException {
    final Function1<Argument, Boolean> _function = new Function1<Argument, Boolean>() {
      @Override
      public Boolean apply(final Argument it) {
        return Boolean.valueOf(it.getBlockName().equals("EMPTY"));
      }
    };
    return IterableExtensions.<Argument>exists(node.getArguments(), _function);
  }
  
  /**
   * Creates a new footer template on the given GUI model
   */
  @Override
  public void execute(final FORSIB node) {
    final Function1<Argument, Boolean> _function = new Function1<Argument, Boolean>() {
      @Override
      public Boolean apply(final Argument it) {
        return Boolean.valueOf(it.getBlockName().equals("EMPTY"));
      }
    };
    final Argument argElse = IterableExtensions.<Argument>findFirst(node.getArguments(), _function);
    final Function1<Argument, Boolean> _function_1 = new Function1<Argument, Boolean>() {
      @Override
      public Boolean apply(final Argument it) {
        boolean _equals = it.getBlockName().equals("EMPTY");
        return Boolean.valueOf((!_equals));
      }
    };
    final Iterable<Argument> otherArgs = IterableExtensions.<Argument>filter(node.getArguments(), _function_1);
    boolean _notEquals = this._gUIExtension.operator_notEquals(argElse, null);
    if (_notEquals) {
      for (final Argument oA : otherArgs) {
        int _y = oA.getY();
        int _y_1 = argElse.getY();
        boolean _greaterEqualsThan = (_y >= _y_1);
        if (_greaterEqualsThan) {
          oA.setY(argElse.getY());
        }
      }
      final int h = argElse.getHeight();
      int _width = node.getWidth();
      int _height = node.getHeight();
      int _minus = (_height - h);
      node.resize(_width, _minus);
      argElse.delete();
      CreateComponentHook cch = new CreateComponentHook();
      cch.postCreate(node);
    }
  }
}
