/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.ControlSIB;
import info.scce.dime.gui.gui.SecuritySIB;
import info.scce.dime.gui.hooks.CreateComponentHook;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Removes the Else argument of an IF SIB.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class RemoveElseSecuritySIB<T extends SecuritySIB> extends DIMECustomAction<ControlSIB> {
  /**
   * Returns the name displayed in the context menu
   */
  @Override
  public String getName() {
    return "remove denied";
  }
  
  /**
   * Checks if a footer template is already present in the given GUI model
   */
  @Override
  public boolean canExecute(final ControlSIB node) throws ClassCastException {
    int _size = node.getArguments().size();
    return (_size >= 2);
  }
  
  /**
   * Creates a new footer template on the given GUI model
   */
  @Override
  public void execute(final ControlSIB node) {
    if ((node instanceof SecuritySIB)) {
      final Function1<Argument, Boolean> _function = new Function1<Argument, Boolean>() {
        @Override
        public Boolean apply(final Argument it) {
          return Boolean.valueOf(it.getBlockName().equals("DENIED"));
        }
      };
      final Argument argDenied = IterableExtensions.<Argument>findFirst(((SecuritySIB)node).getArguments(), _function);
      final Function1<Argument, Boolean> _function_1 = new Function1<Argument, Boolean>() {
        @Override
        public Boolean apply(final Argument it) {
          return Boolean.valueOf(it.getBlockName().equals("GRANTED"));
        }
      };
      final Argument argGranted = IterableExtensions.<Argument>findFirst(((SecuritySIB)node).getArguments(), _function_1);
      boolean _notEquals = this._gUIExtension.operator_notEquals(argDenied, null);
      if (_notEquals) {
        int _y = argGranted.getY();
        int _y_1 = argDenied.getY();
        boolean _greaterEqualsThan = (_y >= _y_1);
        if (_greaterEqualsThan) {
          argGranted.setY(argDenied.getY());
        }
        final int h = argDenied.getHeight();
        int _width = ((SecuritySIB)node).getWidth();
        int _height = ((SecuritySIB)node).getHeight();
        int _minus = (_height - h);
        ((SecuritySIB)node).resize(_width, _minus);
        argDenied.delete();
        CreateComponentHook cch = new CreateComponentHook();
        cch.postCreate(node);
      }
    }
  }
}
