/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.ControlSIB;
import info.scce.dime.gui.gui.IFSIB;
import info.scce.dime.gui.gui.ISSIB;
import info.scce.dime.gui.hooks.CreateComponentHook;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Removes the Else argument of an IF SIB.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class RemoveElseIFSIB<T extends ControlSIB> extends DIMECustomAction<ControlSIB> {
  /**
   * Returns the name displayed in the context menu
   */
  @Override
  public String getName() {
    return "remove else";
  }
  
  /**
   * Checks if a footer template is already present in the given GUI model
   */
  @Override
  public boolean canExecute(final ControlSIB node) throws ClassCastException {
    int _size = node.getArguments().size();
    return (_size >= 2);
  }
  
  /**
   * Creates a new footer template on the given GUI model
   */
  @Override
  public void execute(final ControlSIB node) {
    if ((node instanceof IFSIB)) {
      final Function1<Argument, Boolean> _function = new Function1<Argument, Boolean>() {
        @Override
        public Boolean apply(final Argument it) {
          return Boolean.valueOf(it.getBlockName().equals("ELSE"));
        }
      };
      final Argument argElse = IterableExtensions.<Argument>findFirst(((IFSIB)node).getArguments(), _function);
      final Function1<Argument, Boolean> _function_1 = new Function1<Argument, Boolean>() {
        @Override
        public Boolean apply(final Argument it) {
          return Boolean.valueOf(it.getBlockName().equals("THEN"));
        }
      };
      final Argument argIf = IterableExtensions.<Argument>findFirst(((IFSIB)node).getArguments(), _function_1);
      boolean _notEquals = this._gUIExtension.operator_notEquals(argElse, null);
      if (_notEquals) {
        int _y = argIf.getY();
        int _y_1 = argElse.getY();
        boolean _greaterEqualsThan = (_y >= _y_1);
        if (_greaterEqualsThan) {
          argIf.setY(argElse.getY());
        }
        final int h = argElse.getHeight();
        int _width = ((IFSIB)node).getWidth();
        int _height = ((IFSIB)node).getHeight();
        int _minus = (_height - h);
        ((IFSIB)node).resize(_width, _minus);
        argElse.delete();
        CreateComponentHook cch = new CreateComponentHook();
        cch.postCreate(node);
      }
    }
    if ((node instanceof ISSIB)) {
      final Function1<Argument, Boolean> _function_2 = new Function1<Argument, Boolean>() {
        @Override
        public Boolean apply(final Argument it) {
          return Boolean.valueOf(it.getBlockName().equals("ELSE"));
        }
      };
      final Argument argElse_1 = IterableExtensions.<Argument>findFirst(((ISSIB)node).getArguments(), _function_2);
      final Function1<Argument, Boolean> _function_3 = new Function1<Argument, Boolean>() {
        @Override
        public Boolean apply(final Argument it) {
          return Boolean.valueOf(it.getBlockName().equals("THEN"));
        }
      };
      final Argument argIs = IterableExtensions.<Argument>findFirst(((ISSIB)node).getArguments(), _function_3);
      boolean _notEquals_1 = this._gUIExtension.operator_notEquals(argElse_1, null);
      if (_notEquals_1) {
        int _y_2 = argIs.getY();
        int _y_3 = argElse_1.getY();
        boolean _greaterEqualsThan_1 = (_y_2 >= _y_3);
        if (_greaterEqualsThan_1) {
          argIs.setY(argElse_1.getY());
        }
        final int h_1 = argElse_1.getHeight();
        int _width_1 = ((ISSIB)node).getWidth();
        int _height_1 = ((ISSIB)node).getHeight();
        int _minus_1 = (_height_1 - h_1);
        ((ISSIB)node).resize(_width_1, _minus_1);
        argElse_1.delete();
        CreateComponentHook cch_1 = new CreateComponentHook();
        cch_1.postCreate(node);
      }
    }
  }
}
