/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.GUI;
import java.io.File;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * The open preview action opens a plain HTML5 preview for a given GUI model
 * if the HTML file is already generated by a resource change listener hook.
 * The context menu action can be used on the GUI model itself.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class OpenPreview extends DIMECustomAction<GUI> {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Show preview";
  }
  
  /**
   * Preserves that the action does not perform any changes to the GUI model,
   * so that it has not to be flagged as dirty
   */
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
  
  /**
   * Opens the preview HTML file in the Eclipse browser.
   */
  @Override
  public void execute(final GUI node) {
    final String guiName = node.getTitle();
    final String platformString = node.eResource().getURI().toPlatformString(true);
    final IResource ir = ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("_tmp/");
    _builder.append(guiName);
    _builder.append(".html");
    String _string = ir.getProject().getLocation().append(_builder.toString()).toString();
    final File f = new File(_string);
    boolean _exists = f.exists();
    if (_exists) {
      boolean found = false;
      final IWorkbenchPage wp = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
      IEditorReference[] _editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
      for (final IEditorReference er : _editorReferences) {
        boolean _equals = er.getId().equals("org.eclipse.ui.browser.editor");
        if (_equals) {
          IEditorPart iep = er.getEditor(false);
          if ((iep instanceof IWorkbenchPartReference)) {
            IWorkbenchPartReference iwpr = ((IWorkbenchPartReference) iep);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Preview ");
            _builder_1.append(guiName);
            boolean _equals_1 = iwpr.getPartName().equals(_builder_1.toString());
            if (_equals_1) {
              iwpr.getPart(true).setFocus();
            }
          }
        }
      }
      if ((!found)) {
        final Runnable _function = new Runnable() {
          @Override
          public void run() {
            IFileStore file = EFS.getLocalFileSystem().getStore(f.toURI());
            try {
              IDE.openEditorOnFileStore(wp, file);
            } catch (final Throwable _t) {
              if (_t instanceof PartInitException) {
                final PartInitException e = (PartInitException)_t;
                e.printStackTrace();
              } else {
                throw Exceptions.sneakyThrow(_t);
              }
            }
          }
        };
        this._workbenchExtension.async(_function);
      }
    }
  }
}
