/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.dad.dad.URLProcess;
import info.scce.dime.gui.gui.GUIPlugin;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.GuardSIB;
import info.scce.dime.gui.gui.LinkProcessSIB;
import info.scce.dime.gui.gui.ProcessSIB;
import info.scce.dime.gui.gui.SIB;
import org.eclipse.emf.ecore.EObject;

/**
 * The open model action opens the editor for the model referenced by a given embedded
 * GUI SIBs, Guard SIBs or GUI plug in SIB placed in a GUI model
 * @author zweihoff
 */
@SuppressWarnings("all")
public class OpenModel extends DIMECustomAction<SIB> {
  /**
   * Preserves that the action does not perform any changes to the GUI model,
   * so that it has not to be flagged as dirty
   */
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
  
  /**
   * If a GUI SIB, Guard SIB or GUI plug in SIB is double clicked, the corresponding model
   * is opened in a new editor tab, which is brought to front.
   */
  @Override
  public void execute(final SIB s) {
    EObject _switchResult = null;
    boolean _matched = false;
    if (s instanceof GUISIB) {
      _matched=true;
      _switchResult = ((GUISIB)s).getGui();
    }
    if (!_matched) {
      if (s instanceof GUIPlugin) {
        _matched=true;
        _switchResult = ((GUIPlugin)s).getFunction().eContainer().eContainer();
      }
    }
    if (!_matched) {
      if (s instanceof GuardSIB) {
        _matched=true;
        _switchResult = ((GuardSIB)s).getProcess();
      }
    }
    if (!_matched) {
      if (s instanceof ProcessSIB) {
        _matched=true;
        _switchResult = ((ProcessSIB)s).getProMod();
      }
    }
    if (!_matched) {
      if (s instanceof LinkProcessSIB) {
        _matched=true;
        URLProcess _proMod = ((LinkProcessSIB)s).getProMod();
        _switchResult = ((URLProcess) _proMod).getRootElement();
      }
    }
    if (_switchResult!=null) {
      EObject _switchResult_1 = null;
      boolean _matched_1 = false;
      if (s instanceof GUISIB) {
        _matched_1=true;
        _switchResult_1 = ((GUISIB)s).getGui();
      }
      if (!_matched_1) {
        if (s instanceof GUIPlugin) {
          _matched_1=true;
          _switchResult_1 = ((GUIPlugin)s).getFunction().eContainer().eContainer();
        }
      }
      if (!_matched_1) {
        if (s instanceof GuardSIB) {
          _matched_1=true;
          _switchResult_1 = ((GuardSIB)s).getProcess();
        }
      }
      if (!_matched_1) {
        if (s instanceof ProcessSIB) {
          _matched_1=true;
          _switchResult_1 = ((ProcessSIB)s).getProMod();
        }
      }
      if (!_matched_1) {
        if (s instanceof LinkProcessSIB) {
          _matched_1=true;
          URLProcess _proMod = ((LinkProcessSIB)s).getProMod();
          _switchResult_1 = ((URLProcess) _proMod).getRootElement();
        }
      }
      this._workbenchExtension.openEditor(_switchResult);
    }
  }
}
