/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import com.google.common.collect.Iterables;
import info.scce.dime.gui.actions.DIMEGUICustomAction;
import info.scce.dime.gui.actions.StaticToPrimitivePort;
import info.scce.dime.gui.gui.InputStatic;
import info.scce.dime.gui.gui.SIB;
import java.util.function.Consumer;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Context menu action, which converts all static ports to
 * input ports
 * @author zweihoff
 */
@SuppressWarnings("all")
public class MultiStaticToInput<T extends SIB> extends DIMEGUICustomAction<SIB> {
  /**
   * Returns the name of the context menu entry
   */
  @Override
  public String getName() {
    return "Convert to input ports";
  }
  
  /**
   * Checks if the r GUI SIB is not already dispatched
   */
  @Override
  public boolean canExecute(final SIB guiSib) {
    boolean _isEmpty = IterableExtensions.isEmpty(Iterables.<InputStatic>filter(guiSib.getIOs(), InputStatic.class));
    return (!_isEmpty);
  }
  
  @Override
  public void execute(final SIB guiSib) {
    final Consumer<InputStatic> _function = new Consumer<InputStatic>() {
      @Override
      public void accept(final InputStatic n) {
        final StaticToPrimitivePort<InputStatic> p = new StaticToPrimitivePort<InputStatic>();
        p.execute(n);
      }
    };
    Iterables.<InputStatic>filter(guiSib.getIOs(), InputStatic.class).forEach(_function);
  }
}
