/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import graphmodel.Container;
import graphmodel.ModelElementContainer;
import graphmodel.Node;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.MovableContainer;
import info.scce.dime.gui.gui.MoveLeft;
import info.scce.dime.gui.gui.MoveSign;
import info.scce.dime.gui.gui.MoveUp;
import info.scce.dime.gui.hooks.CreateComponentHook;
import info.scce.dime.gui.hooks.LayoutHelper;
import java.util.ArrayList;
import org.eclipse.xtext.xbase.lib.Exceptions;

/**
 * The MoveAction is triggered, when a moving sign on a movable component is double clicked.
 * The component which surrounds the clicked moving sign is moved in the direction, the sign signs.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class MoveAction extends DIMECustomAction<MoveSign> {
  public static int MOVE_UP = 1;
  
  public static int MOVE_DOWN = 2;
  
  public static int MOVE_LEFT = 3;
  
  public static int MOVE_RIGHT = 4;
  
  /**
   * If a moving sign is double clicked the component is moved.
   * Moving means, the clicked component switches its place with a neighbor on the signed place.
   */
  @Override
  public void execute(final MoveSign node) {
    GUI gui = node.getRootElement();
    try {
      int direction = 0;
      MovableContainer _container = node.getContainer();
      Container clickedNode = ((Container) _container);
      ModelElementContainer _container_1 = clickedNode.getContainer();
      Container cContainer = ((Container) _container_1);
      Node shufflePartner = null;
      boolean _isHorizontalComponent = LayoutHelper.isHorizontalComponent(cContainer);
      if (_isHorizontalComponent) {
        if ((node instanceof MoveLeft)) {
          ArrayList<Node> _allNodes = LayoutHelper.getAllNodes(cContainer);
          for (final Node n : _allNodes) {
            int _x = n.getX();
            int _x_1 = clickedNode.getX();
            boolean _lessThan = (_x < _x_1);
            if (_lessThan) {
              if ((shufflePartner == null)) {
                shufflePartner = n;
              } else {
                int _x_2 = clickedNode.getX();
                int _x_3 = n.getX();
                int _minus = (_x_2 - _x_3);
                int _x_4 = clickedNode.getX();
                int _x_5 = shufflePartner.getX();
                int _minus_1 = (_x_4 - _x_5);
                boolean _lessThan_1 = (_minus < _minus_1);
                if (_lessThan_1) {
                  shufflePartner = n;
                }
              }
              direction = MoveAction.MOVE_LEFT;
            }
          }
        } else {
          ArrayList<Node> _allNodes_1 = LayoutHelper.getAllNodes(cContainer);
          for (final Node n_1 : _allNodes_1) {
            int _x_6 = n_1.getX();
            int _x_7 = clickedNode.getX();
            boolean _greaterThan = (_x_6 > _x_7);
            if (_greaterThan) {
              if ((shufflePartner == null)) {
                shufflePartner = n_1;
              } else {
                int _x_8 = n_1.getX();
                int _x_9 = clickedNode.getX();
                int _minus_2 = (_x_8 - _x_9);
                int _x_10 = shufflePartner.getX();
                int _x_11 = clickedNode.getX();
                int _minus_3 = (_x_10 - _x_11);
                boolean _lessThan_2 = (_minus_2 < _minus_3);
                if (_lessThan_2) {
                  shufflePartner = n_1;
                }
              }
              direction = MoveAction.MOVE_RIGHT;
            }
          }
        }
      } else {
        if ((node instanceof MoveUp)) {
          ArrayList<Node> _allNodes_2 = LayoutHelper.getAllNodes(cContainer);
          for (final Node n_2 : _allNodes_2) {
            int _y = n_2.getY();
            int _y_1 = clickedNode.getY();
            boolean _lessThan_3 = (_y < _y_1);
            if (_lessThan_3) {
              if ((shufflePartner == null)) {
                shufflePartner = n_2;
              } else {
                int _y_2 = clickedNode.getY();
                int _y_3 = n_2.getY();
                int _minus_4 = (_y_2 - _y_3);
                int _y_4 = clickedNode.getY();
                int _y_5 = shufflePartner.getY();
                int _minus_5 = (_y_4 - _y_5);
                boolean _lessThan_4 = (_minus_4 < _minus_5);
                if (_lessThan_4) {
                  shufflePartner = n_2;
                }
              }
              direction = MoveAction.MOVE_UP;
            }
          }
        } else {
          ArrayList<Node> _allNodes_3 = LayoutHelper.getAllNodes(cContainer);
          for (final Node n_3 : _allNodes_3) {
            int _y_6 = n_3.getY();
            int _y_7 = clickedNode.getY();
            boolean _greaterThan_1 = (_y_6 > _y_7);
            if (_greaterThan_1) {
              if ((shufflePartner == null)) {
                shufflePartner = n_3;
              } else {
                int _y_8 = n_3.getY();
                int _y_9 = clickedNode.getY();
                int _minus_6 = (_y_8 - _y_9);
                int _y_10 = shufflePartner.getY();
                int _y_11 = clickedNode.getY();
                int _minus_7 = (_y_10 - _y_11);
                boolean _lessThan_5 = (_minus_6 < _minus_7);
                if (_lessThan_5) {
                  shufflePartner = n_3;
                }
              }
              direction = MoveAction.MOVE_DOWN;
            }
          }
        }
      }
      if ((shufflePartner != null)) {
        if ((direction == MoveAction.MOVE_UP)) {
          clickedNode.setY(shufflePartner.getY());
          int _y_12 = clickedNode.getY();
          int _height = clickedNode.getHeight();
          int _plus = (_y_12 + _height);
          int _plus_1 = (_plus + CreateComponentHook.V_OFFSET);
          shufflePartner.setY(_plus_1);
        }
        if ((direction == MoveAction.MOVE_DOWN)) {
          shufflePartner.setY(clickedNode.getY());
          int _y_13 = shufflePartner.getY();
          int _height_1 = shufflePartner.getHeight();
          int _plus_2 = (_y_13 + _height_1);
          int _plus_3 = (_plus_2 + CreateComponentHook.V_OFFSET);
          clickedNode.setY(_plus_3);
        }
        if ((direction == MoveAction.MOVE_LEFT)) {
          clickedNode.setX(shufflePartner.getX());
          int _x_12 = clickedNode.getX();
          int _width = clickedNode.getWidth();
          int _plus_4 = (_x_12 + _width);
          int _plus_5 = (_plus_4 + CreateComponentHook.H_OFFSET);
          shufflePartner.setX(_plus_5);
        }
        if ((direction == MoveAction.MOVE_RIGHT)) {
          shufflePartner.setX(clickedNode.getX());
          int _x_13 = shufflePartner.getX();
          int _width_1 = shufflePartner.getWidth();
          int _plus_6 = (_x_13 + _width_1);
          int _plus_7 = (_plus_6 + CreateComponentHook.H_OFFSET);
          clickedNode.setX(_plus_7);
        }
      }
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
