/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import com.google.common.collect.Iterables;
import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.ComplexOutputPort;
import info.scce.dime.gui.gui.ComplexVariable;
import info.scce.dime.gui.gui.DispatchedGUISIB;
import info.scce.dime.gui.gui.Event;
import info.scce.dime.gui.gui.ExtensionContext;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.OutputPort;
import info.scce.dime.gui.gui.PrimitiveOutputPort;
import info.scce.dime.gui.gui.PrimitiveVariable;
import info.scce.dime.gui.gui.ProcessSIB;
import info.scce.dime.gui.gui.Variable;
import info.scce.dime.gui.helper.ComplexGUIBranchPort;
import info.scce.dime.gui.helper.GUIBranch;
import info.scce.dime.gui.helper.GUIBranchPort;
import info.scce.dime.gui.helper.PrimitiveGUIBranchPort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class GenerateMarkdownDocumentation<T extends GUI> extends DIMECustomAction<T> {
  @Override
  public String getName() {
    return "Create Documentation";
  }
  
  @Override
  public boolean canExecute(final GUI d) {
    return true;
  }
  
  @Override
  public boolean hasDoneChanges() {
    return false;
  }
  
  @Override
  public void execute(final GUI d) {
    try {
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("../documentation/gui/");
      String _title = d.getTitle();
      _builder.append(_title);
      _builder.append(".md");
      final String filePath = this._workspaceExtension.getFile(d).getProject().getLocation().append(_builder.toString()).toString();
      this.createFile(this.createDoc(d).toString(), filePath);
    } catch (Throwable _e) {
      throw Exceptions.sneakyThrow(_e);
    }
  }
  
  /**
   * Helper method to create a file with the given content on the given path.
   * @param content
   * @param path
   * @throws IOException
   */
  public void createFile(final String content, final String path) throws IOException {
    final File f = new File(path);
    f.getParentFile().mkdirs();
    f.createNewFile();
    FileUtils.writeStringToFile(f, content);
  }
  
  public CharSequence createDoc(final GUI d) {
    CharSequence _xblockexpression = null;
    {
      final Iterable<Variable> inputs = this._gUIExtension.inputVariables(d);
      final Collection<GUIBranch> branches = this._gUIExtension.getGUIBranchesMerged(d);
      final Iterable<Event> events = this._gUIExtension.events(d);
      final List<GUISIB> containedGuiSibs = this.getContainedGuiSibs(d);
      final List<ProcessSIB> containedInteractionSibs = this.getContainedInteractionSibs(d);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("# ");
      String _title = d.getTitle();
      _builder.append(_title);
      _builder.append(" *GUI* ");
      {
        boolean _isEmpty = d.getExtensionContexts().isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          _builder.append(" extends ");
          final Function1<ExtensionContext, EList<GUISIB>> _function = new Function1<ExtensionContext, EList<GUISIB>>() {
            @Override
            public EList<GUISIB> apply(final ExtensionContext it) {
              return it.getGUISIBs();
            }
          };
          final Function1<GUISIB, String> _function_1 = new Function1<GUISIB, String>() {
            @Override
            public String apply(final GUISIB it) {
              return it.getName();
            }
          };
          String _join = IterableExtensions.join(IterableExtensions.<GUISIB, String>map(Iterables.<GUISIB>concat(ListExtensions.<ExtensionContext, EList<GUISIB>>map(d.getExtensionContexts(), _function)), _function_1), ",");
          _builder.append(_join);
        }
      }
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Input Ports");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<Variable, String> _function_2 = new Function1<Variable, String>() {
        @Override
        public String apply(final Variable it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* *");
          String _name = it.getName();
          _builder.append(_name);
          _builder.append("* : ");
          {
            boolean _isIsList = it.isIsList();
            if (_isIsList) {
              _builder.append("List<");
            }
          }
          CharSequence _typeName = GenerateMarkdownDocumentation.this.typeName(it);
          _builder.append(_typeName);
          {
            boolean _isIsList_1 = it.isIsList();
            if (_isIsList_1) {
              _builder.append(">");
            }
          }
          return _builder.toString();
        }
      };
      String _join_1 = IterableExtensions.join(IterableExtensions.<Variable, String>map(inputs, _function_2), "\n");
      _builder.append(_join_1);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Events");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<Event, CharSequence> _function_3 = new Function1<Event, CharSequence>() {
        @Override
        public CharSequence apply(final Event it) {
          return GenerateMarkdownDocumentation.this.event(it);
        }
      };
      String _join_2 = IterableExtensions.join(IterableExtensions.<Event, CharSequence>map(events, _function_3), "\n");
      _builder.append(_join_2);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Branches");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<GUIBranch, CharSequence> _function_4 = new Function1<GUIBranch, CharSequence>() {
        @Override
        public CharSequence apply(final GUIBranch it) {
          return GenerateMarkdownDocumentation.this.branch(it);
        }
      };
      String _join_3 = IterableExtensions.join(IterableExtensions.<GUIBranch, CharSequence>map(branches, _function_4), "\n");
      _builder.append(_join_3);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Used GUI SIBs");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<GUISIB, String> _function_5 = new Function1<GUISIB, String>() {
        @Override
        public String apply(final GUISIB it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* [");
          String _name = it.getName();
          _builder.append(_name);
          {
            if ((it instanceof DispatchedGUISIB)) {
              _builder.append(" _dispatched_");
            }
          }
          _builder.append("](./");
          String _name_1 = it.getName();
          _builder.append(_name_1);
          _builder.append(".md)");
          return _builder.toString();
        }
      };
      String _join_4 = IterableExtensions.join(ListExtensions.<GUISIB, String>map(containedGuiSibs, _function_5), "\n");
      _builder.append(_join_4);
      _builder.newLineIfNotEmpty();
      _builder.append(" ");
      _builder.newLine();
      _builder.append("### Used Interaction Processes");
      _builder.newLine();
      _builder.append(" ");
      _builder.newLine();
      final Function1<ProcessSIB, String> _function_6 = new Function1<ProcessSIB, String>() {
        @Override
        public String apply(final ProcessSIB it) {
          StringConcatenation _builder = new StringConcatenation();
          _builder.append("* [");
          String _name = GenerateMarkdownDocumentation.this.getName();
          _builder.append(_name);
          _builder.append("](../process/");
          String _name_1 = GenerateMarkdownDocumentation.this.getName();
          _builder.append(_name_1);
          _builder.append(".md)");
          return _builder.toString();
        }
      };
      String _join_5 = IterableExtensions.join(ListExtensions.<ProcessSIB, String>map(containedInteractionSibs, _function_6), "\n");
      _builder.append(_join_5);
      _builder.newLineIfNotEmpty();
      _xblockexpression = _builder;
    }
    return _xblockexpression;
  }
  
  public CharSequence branch(final GUIBranch b) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("* *");
    String _name = b.getName();
    _builder.append(_name);
    _builder.append("*");
    _builder.newLineIfNotEmpty();
    {
      List<GUIBranchPort> _ports = b.getPorts();
      for(final GUIBranchPort p : _ports) {
        _builder.append(" ");
        _builder.append("* ");
        String _name_1 = p.getName();
        _builder.append(_name_1);
        _builder.append(": ");
        {
          boolean _isList = p.isList();
          if (_isList) {
            _builder.append("List<");
          }
        }
        {
          if ((p instanceof ComplexGUIBranchPort)) {
            String _name_2 = ((ComplexGUIBranchPort)p).getType().getName();
            _builder.append(_name_2);
          } else {
            String _literal = ((PrimitiveGUIBranchPort) p).getType().getLiteral();
            _builder.append(_literal);
          }
        }
        {
          boolean _isList_1 = p.isList();
          if (_isList_1) {
            _builder.append(">");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  public CharSequence event(final Event b) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("* *");
    String _name = b.getName();
    _builder.append(_name);
    _builder.append("*");
    _builder.newLineIfNotEmpty();
    {
      EList<OutputPort> _outputPorts = b.getOutputPorts();
      for(final OutputPort p : _outputPorts) {
        _builder.append(" ");
        _builder.append("* ");
        String _name_1 = p.getName();
        _builder.append(_name_1);
        _builder.append(": ");
        {
          boolean _isIsList = p.isIsList();
          if (_isIsList) {
            _builder.append("List<");
          }
        }
        {
          if ((p instanceof ComplexOutputPort)) {
            String _name_2 = ((ComplexOutputPort)p).getDataType().getName();
            _builder.append(_name_2);
          } else {
            String _literal = ((PrimitiveOutputPort) p).getDataType().getLiteral();
            _builder.append(_literal);
          }
        }
        {
          boolean _isIsList_1 = p.isIsList();
          if (_isIsList_1) {
            _builder.append(">");
          }
        }
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder;
  }
  
  protected CharSequence _typeName(final ComplexVariable t) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("[");
    String _name = t.getDataType().getName();
    _builder.append(_name);
    _builder.append("](../data/");
    String _modelName = t.getDataType().getRootElement().getModelName();
    _builder.append(_modelName);
    _builder.append("/");
    String _name_1 = t.getDataType().getName();
    _builder.append(_name_1);
    _builder.append(".md)");
    return _builder;
  }
  
  protected CharSequence _typeName(final PrimitiveVariable t) {
    return t.getDataType().getLiteral();
  }
  
  public String doc(final String s) {
    String _xblockexpression = null;
    {
      boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(s);
      boolean _not = (!_isNullOrEmpty);
      if (_not) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(">>>");
        _builder.newLine();
        _builder.append(s);
        _builder.newLineIfNotEmpty();
        _builder.append("<<<");
        _builder.newLine();
        return _builder.toString();
      }
      _xblockexpression = "";
    }
    return _xblockexpression;
  }
  
  private List<GUISIB> getContainedGuiSibs(final GUI gui) {
    ArrayList<GUISIB> list = new ArrayList<GUISIB>();
    TreeIterator<EObject> it = gui.eAllContents();
    while (it.hasNext()) {
      {
        Object obj = it.next();
        if ((obj instanceof GUISIB)) {
          ModelElementContainer _container = ((GUISIB)obj).getContainer();
          boolean _not = (!(_container instanceof ExtensionContext));
          if (_not) {
            GUISIB guiSib = ((GUISIB) obj);
            list.add(guiSib);
          }
        }
      }
    }
    return list;
  }
  
  private List<ProcessSIB> getContainedInteractionSibs(final GUI gui) {
    List<ProcessSIB> list = new LinkedList<ProcessSIB>();
    TreeIterator<EObject> it = gui.eAllContents();
    while (it.hasNext()) {
      {
        Object obj = it.next();
        if ((obj instanceof ProcessSIB)) {
          list.add(((ProcessSIB)obj));
        }
      }
    }
    return list;
  }
  
  public CharSequence typeName(final Variable t) {
    if (t instanceof ComplexVariable) {
      return _typeName((ComplexVariable)t);
    } else if (t instanceof PrimitiveVariable) {
      return _typeName((PrimitiveVariable)t);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(t).toString());
    }
  }
}
