/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import de.jabc.cinco.meta.core.utils.messages.CincoMessageHandler;
import graphmodel.Container;
import graphmodel.ModelElementContainer;
import info.scce.dime.gui.actions.PrimitivePortToStatic;
import info.scce.dime.gui.gui.BaseElement;
import info.scce.dime.gui.gui.BooleanInputStatic;
import info.scce.dime.gui.gui.ComplexInputPort;
import info.scce.dime.gui.gui.ComplexRead;
import info.scce.dime.gui.gui.ControlSIB;
import info.scce.dime.gui.gui.DispatchedGUISIB;
import info.scce.dime.gui.gui.EventListener;
import info.scce.dime.gui.gui.FOR;
import info.scce.dime.gui.gui.GUIPlugin;
import info.scce.dime.gui.gui.GUISIB;
import info.scce.dime.gui.gui.IF;
import info.scce.dime.gui.gui.IO;
import info.scce.dime.gui.gui.IS;
import info.scce.dime.gui.gui.InputStatic;
import info.scce.dime.gui.gui.IntegerInputStatic;
import info.scce.dime.gui.gui.PrimitiveInputPort;
import info.scce.dime.gui.gui.PrimitiveRead;
import info.scce.dime.gui.gui.RealInputStatic;
import info.scce.dime.gui.gui.Registration;
import info.scce.dime.gui.gui.SIB;
import info.scce.dime.gui.gui.SecuritySIB;
import info.scce.dime.gui.gui.TextInputStatic;
import info.scce.dime.gui.gui.TimestampInputStatic;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;

@SuppressWarnings("all")
public class GUIActionExtension {
  public void rebuildPorts(final BaseElement oldSIB, final BaseElement newSIB) {
    final Function1<IO, Boolean> _function = new Function1<IO, Boolean>() {
      @Override
      public Boolean apply(final IO n) {
        return Boolean.valueOf((n instanceof InputStatic));
      }
    };
    final Function1<IO, InputStatic> _function_1 = new Function1<IO, InputStatic>() {
      @Override
      public InputStatic apply(final IO n) {
        return ((InputStatic) n);
      }
    };
    Iterable<InputStatic> staticPorts = IterableExtensions.<IO, InputStatic>map(IterableExtensions.<IO>filter(this.getIOs(oldSIB), _function), _function_1);
    if ((newSIB != null)) {
      if (((newSIB instanceof SIB) && (oldSIB instanceof SIB))) {
        ((SIB) newSIB).setLabel(((SIB) oldSIB).getLabel());
      }
      EList<IF> _incoming = oldSIB.<IF>getIncoming(IF.class);
      for (final IF i : _incoming) {
        i.reconnectTarget(newSIB);
      }
      EList<FOR> _incoming_1 = oldSIB.<FOR>getIncoming(FOR.class);
      for (final FOR i_1 : _incoming_1) {
        i_1.reconnectTarget(newSIB);
      }
      EList<IS> _incoming_2 = oldSIB.<IS>getIncoming(IS.class);
      for (final IS i_2 : _incoming_2) {
        i_2.reconnectTarget(newSIB);
      }
      if ((((newSIB instanceof GUISIB) || (newSIB instanceof GUIPlugin)) || (newSIB instanceof DispatchedGUISIB))) {
        this.reconnectPorts(this.eventInputs(((SIB) oldSIB)), this.eventInputs(((SIB) newSIB)));
        this.reconnectRegistration(((SIB) oldSIB).getEventListeners(), ((SIB) newSIB).getEventListeners());
        this.rebuildStaticInputs(this.getStaticEventInputs(((SIB) oldSIB)), this.eventInputs(((SIB) newSIB)), newSIB);
      }
      this.reconnectPorts(this.getSibInputs(oldSIB), this.getSibInputs(newSIB));
      this.rebuildStaticInputs(IterableExtensions.<InputStatic>toList(staticPorts), this.getIOs(newSIB), newSIB);
    } else {
      System.out.println("Could not create new GUISIB in Update Action");
    }
  }
  
  public Map<String, List<InputStatic>> getStaticEventInputs(final SIB csib) {
    final Function1<List<IO>, List<InputStatic>> _function = new Function1<List<IO>, List<InputStatic>>() {
      @Override
      public List<InputStatic> apply(final List<IO> n) {
        final Function1<IO, Boolean> _function = new Function1<IO, Boolean>() {
          @Override
          public Boolean apply(final IO e) {
            return Boolean.valueOf((e instanceof InputStatic));
          }
        };
        final Function1<IO, InputStatic> _function_1 = new Function1<IO, InputStatic>() {
          @Override
          public InputStatic apply(final IO it) {
            return ((InputStatic) it);
          }
        };
        return IterableExtensions.<InputStatic>toList(IterableExtensions.<IO, InputStatic>map(IterableExtensions.<IO>filter(n, _function), _function_1));
      }
    };
    return MapExtensions.<String, List<IO>, List<InputStatic>>mapValues(this.eventInputs(csib), _function);
  }
  
  public void rebuildStaticInputs(final List<InputStatic> staticPortMap, final List<IO> cioMap, final Container inputContainer) {
    final HashMap<String, List<InputStatic>> oldMap = new HashMap<String, List<InputStatic>>();
    oldMap.put("key", staticPortMap);
    final HashMap<String, List<IO>> newMap = new HashMap<String, List<IO>>();
    newMap.put("key", cioMap);
    this.rebuildStaticInputs(oldMap, newMap, inputContainer);
  }
  
  public void rebuildStaticInputs(final Map<String, List<InputStatic>> staticPortMap, final Map<String, List<IO>> cioMap, final Container inputContainer) {
    Set<Map.Entry<String, List<InputStatic>>> _entrySet = staticPortMap.entrySet();
    for (final Map.Entry<String, List<InputStatic>> compoundStaticPort : _entrySet) {
      {
        List<IO> compoundCios = cioMap.get(compoundStaticPort.getKey());
        List<InputStatic> _value = compoundStaticPort.getValue();
        for (final InputStatic staticPort : _value) {
          {
            final Function1<IO, Boolean> _function = new Function1<IO, Boolean>() {
              @Override
              public Boolean apply(final IO it) {
                EObject _eContainer = it.eContainer();
                return Boolean.valueOf((!Objects.equal(_eContainer, null)));
              }
            };
            final Function1<IO, Boolean> _function_1 = new Function1<IO, Boolean>() {
              @Override
              public Boolean apply(final IO it) {
                return Boolean.valueOf(it.getName().equals(staticPort.getName()));
              }
            };
            final IO port = IterableExtensions.<IO>findFirst(IterableExtensions.<IO>filter(compoundCios, _function), _function_1);
            boolean _notEquals = (!Objects.equal(port, null));
            if (_notEquals) {
              final String portName = port.getName();
              PrimitivePortToStatic ppts = new PrimitivePortToStatic();
              ppts.execute(((PrimitiveInputPort) port));
              final Function1<IO, Boolean> _function_2 = new Function1<IO, Boolean>() {
                @Override
                public Boolean apply(final IO n) {
                  return Boolean.valueOf((n instanceof InputStatic));
                }
              };
              final Function1<IO, Boolean> _function_3 = new Function1<IO, Boolean>() {
                @Override
                public Boolean apply(final IO it) {
                  return Boolean.valueOf(it.getName().equals(portName));
                }
              };
              IO newStaticPort = IterableExtensions.<IO>findFirst(IterableExtensions.<IO>filter(this.getIOs(inputContainer), _function_2), _function_3);
              boolean _notEquals_1 = (!Objects.equal(newStaticPort, null));
              if (_notEquals_1) {
                boolean _matched = false;
                if (newStaticPort instanceof IntegerInputStatic) {
                  if ((staticPort instanceof IntegerInputStatic)) {
                    _matched=true;
                    ((IntegerInputStatic)newStaticPort).setValue(((IntegerInputStatic) staticPort).getValue());
                  }
                }
                if (!_matched) {
                  if (newStaticPort instanceof RealInputStatic) {
                    if ((staticPort instanceof RealInputStatic)) {
                      _matched=true;
                      ((RealInputStatic)newStaticPort).setValue(((RealInputStatic) staticPort).getValue());
                    }
                  }
                }
                if (!_matched) {
                  if (newStaticPort instanceof TextInputStatic) {
                    if ((staticPort instanceof TextInputStatic)) {
                      _matched=true;
                      ((TextInputStatic)newStaticPort).setValue(((TextInputStatic) staticPort).getValue());
                    }
                  }
                }
                if (!_matched) {
                  if (newStaticPort instanceof BooleanInputStatic) {
                    if ((staticPort instanceof BooleanInputStatic)) {
                      _matched=true;
                      ((BooleanInputStatic)newStaticPort).setValue(((BooleanInputStatic) staticPort).isValue());
                    }
                  }
                }
                if (!_matched) {
                  if (newStaticPort instanceof TimestampInputStatic) {
                    if ((staticPort instanceof TimestampInputStatic)) {
                      _matched=true;
                      ((TimestampInputStatic)newStaticPort).setValue(((TimestampInputStatic) staticPort).getValue());
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  public List<IO> getIOs(final Container container) {
    if ((container instanceof SIB)) {
      return ((SIB) container).getIOs();
    }
    if ((container instanceof ControlSIB)) {
      return ((ControlSIB) container).getIOs();
    }
    if ((container instanceof EventListener)) {
      return ((EventListener) container).getIOs();
    }
    return null;
  }
  
  public void reconnectRegistration(final List<EventListener> oldEvt, final List<EventListener> newEvt) {
    final Function1<EventListener, Boolean> _function = new Function1<EventListener, Boolean>() {
      @Override
      public Boolean apply(final EventListener it) {
        boolean _isEmpty = it.<Registration>getIncoming(Registration.class).isEmpty();
        return Boolean.valueOf((!_isEmpty));
      }
    };
    final Function1<EventListener, Boolean> _function_1 = new Function1<EventListener, Boolean>() {
      @Override
      public Boolean apply(final EventListener o) {
        final Function1<EventListener, Boolean> _function = new Function1<EventListener, Boolean>() {
          @Override
          public Boolean apply(final EventListener it) {
            return Boolean.valueOf(it.getName().equals(o.getName()));
          }
        };
        boolean _isEmpty = IterableExtensions.isEmpty(IterableExtensions.<EventListener>filter(newEvt, _function));
        return Boolean.valueOf((!_isEmpty));
      }
    };
    Iterable<EventListener> _filter = IterableExtensions.<EventListener>filter(IterableExtensions.<EventListener>filter(oldEvt, _function), _function_1);
    for (final EventListener o : _filter) {
      {
        final Function1<EventListener, Boolean> _function_2 = new Function1<EventListener, Boolean>() {
          @Override
          public Boolean apply(final EventListener it) {
            return Boolean.valueOf(it.getName().equals(o.getName()));
          }
        };
        EventListener e = ((EventListener[])Conversions.unwrapArray(IterableExtensions.<EventListener>filter(newEvt, _function_2), EventListener.class))[0];
        EList<Registration> _incoming = o.<Registration>getIncoming(Registration.class);
        for (final Registration reg : _incoming) {
          reg.reconnectTarget(e);
        }
      }
    }
  }
  
  public List<EventListener> eventListeners(final SIB csib) {
    return IterableExtensions.<EventListener>toList(Iterables.<EventListener>filter(csib.getAbstractBranchs(), EventListener.class));
  }
  
  protected Map<String, List<IO>> _getSibInputs(final SIB csib) {
    final Function1<IO, String> _function = new Function1<IO, String>() {
      @Override
      public String apply(final IO it) {
        return csib.getLabel();
      }
    };
    return IterableExtensions.<String, IO>groupBy(csib.getIOs(), _function);
  }
  
  protected Map<String, List<IO>> _getSibInputs(final SecuritySIB csib) {
    final Function1<IO, String> _function = new Function1<IO, String>() {
      @Override
      public String apply(final IO it) {
        info.scce.dime.process.process.Process _proMod = csib.getProMod();
        return ((info.scce.dime.process.process.Process) _proMod).getModelName();
      }
    };
    return IterableExtensions.<String, IO>groupBy(csib.getIOs(), _function);
  }
  
  public Map<String, List<IO>> eventInputs(final SIB csib) {
    final Function1<EventListener, EList<IO>> _function = new Function1<EventListener, EList<IO>>() {
      @Override
      public EList<IO> apply(final EventListener it) {
        return it.getIOs();
      }
    };
    final Function1<IO, String> _function_1 = new Function1<IO, String>() {
      @Override
      public String apply(final IO it) {
        ModelElementContainer _container = it.getContainer();
        return ((EventListener) _container).getName();
      }
    };
    return IterableExtensions.<String, IO>groupBy(Iterables.<IO>concat(ListExtensions.<EventListener, EList<IO>>map(csib.getEventListeners(), _function)), _function_1);
  }
  
  public boolean showDialog(final String title, final String msg) {
    return CincoMessageHandler.showQuestion(msg, title, true);
  }
  
  public void reconnectPorts(final Map<String, List<IO>> oldCompound, final Map<String, List<IO>> newCompound) {
    Set<Map.Entry<String, List<IO>>> _entrySet = newCompound.entrySet();
    for (final Map.Entry<String, List<IO>> compound : _entrySet) {
      {
        List<IO> newCIOs = compound.getValue();
        boolean _containsKey = oldCompound.containsKey(compound.getKey());
        if (_containsKey) {
          List<IO> oldCIOs = oldCompound.get(compound.getKey());
          for (final IO io : oldCIOs) {
            for (final IO newIo : newCIOs) {
              boolean _equals = io.getName().equals(newIo.getName());
              if (_equals) {
                if (((newIo instanceof ComplexInputPort) && (io instanceof ComplexInputPort))) {
                  boolean _isEmpty = io.<ComplexRead>getIncoming(ComplexRead.class).isEmpty();
                  boolean _not = (!_isEmpty);
                  if (_not) {
                    io.<ComplexRead>getIncoming(ComplexRead.class).get(0).reconnectTarget(((ComplexInputPort) newIo));
                  }
                }
                if (((newIo instanceof PrimitiveInputPort) && (io instanceof PrimitiveInputPort))) {
                  boolean _isEmpty_1 = io.<PrimitiveRead>getIncoming(PrimitiveRead.class).isEmpty();
                  boolean _not_1 = (!_isEmpty_1);
                  if (_not_1) {
                    io.<PrimitiveRead>getIncoming(PrimitiveRead.class).get(0).reconnectTarget(((PrimitiveInputPort) newIo));
                  }
                }
              }
            }
          }
        }
      }
    }
  }
  
  public Map<String, List<IO>> getSibInputs(final BaseElement csib) {
    if (csib instanceof SecuritySIB) {
      return _getSibInputs((SecuritySIB)csib);
    } else if (csib instanceof SIB) {
      return _getSibInputs((SIB)csib);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(csib).toString());
    }
  }
}
