/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.ControlSIB;
import info.scce.dime.gui.gui.IFSIB;
import info.scce.dime.gui.gui.ISSIB;

/**
 * De-negates an IF SIB.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class DenegateIFSIB<T extends ControlSIB> extends DIMECustomAction<ControlSIB> {
  /**
   * Returns the name displayed in the context menu
   */
  @Override
  public String getName() {
    return "de-negate";
  }
  
  /**
   * Checks if a footer template is already present in the given GUI model
   */
  @Override
  public boolean canExecute(final ControlSIB node) throws ClassCastException {
    boolean _xblockexpression = false;
    {
      if ((node instanceof IFSIB)) {
        return ((IFSIB)node).isNegate();
      }
      if ((node instanceof ISSIB)) {
        return ((ISSIB)node).isNegate();
      }
      _xblockexpression = false;
    }
    return _xblockexpression;
  }
  
  /**
   * Creates a new footer template on the given GUI model
   */
  @Override
  public void execute(final ControlSIB node) {
    if ((node instanceof IFSIB)) {
      ((IFSIB)node).setNegate(false);
    }
    if ((node instanceof ISSIB)) {
      ((ISSIB)node).setNegate(false);
    }
  }
}
