/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.ControlSIB;
import info.scce.dime.gui.gui.PrimitiveInputPort;
import info.scce.dime.gui.hooks.CreateComponentHook;
import info.scce.dime.process.helper.LayoutConstants;
import java.util.function.Consumer;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.StringExtensions;

/**
 * Adds input ports to a given IF SIB
 * @author zweihoff
 */
@SuppressWarnings("all")
public class AddPrimitivePort extends DIMECustomAction<ControlSIB> {
  /**
   * Returns the name displayed in the context menu
   */
  @Override
  public String getName() {
    return "Add primitive input";
  }
  
  /**
   * Input ports can always be added
   */
  @Override
  public boolean canExecute(final ControlSIB node) throws ClassCastException {
    return true;
  }
  
  /**
   * Creates a new primitive input port
   */
  @Override
  public void execute(final ControlSIB node) {
    final PrimitiveInputPort cpip = this.createPrimitivePort(node);
    StringConcatenation _builder = new StringConcatenation();
    String _firstLower = StringExtensions.toFirstLower(cpip.getDataType().getLiteral());
    _builder.append(_firstLower);
    int _size = node.getIOs().size();
    _builder.append(_size);
    cpip.setName(_builder.toString());
  }
  
  public PrimitiveInputPort createPrimitivePort(final ControlSIB cControlSIB) {
    int _size = cControlSIB.getIOs().size();
    int _plus = (_size + 1);
    int _multiply = (_plus * LayoutConstants.PORT_SPACE);
    final int posY = (50 + _multiply);
    final PrimitiveInputPort cpip = cControlSIB.newPrimitiveInputPort(LayoutConstants.PORT_X, posY);
    int _width = cControlSIB.getWidth();
    int _height = cControlSIB.getHeight();
    int _plus_1 = (_height + LayoutConstants.PORT_SPACE);
    cControlSIB.resize(_width, _plus_1);
    final Consumer<Argument> _function = new Consumer<Argument>() {
      @Override
      public void accept(final Argument n) {
        int _y = n.getY();
        int _plus = (_y + LayoutConstants.PORT_SPACE);
        n.setY(_plus);
      }
    };
    cControlSIB.getArguments().forEach(_function);
    CreateComponentHook cch = new CreateComponentHook();
    cch.postCreate(cControlSIB);
    return cpip;
  }
}
