/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.Argument;
import info.scce.dime.gui.gui.FORSIB;
import info.scce.dime.gui.hooks.CreateComponentHook;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

/**
 * Adds an Join argument to the FORSIB.
 * @author zweihoff
 */
@SuppressWarnings("all")
public class AddJoinFORSIB extends DIMECustomAction<FORSIB> {
  /**
   * Returns the name displayed in the context menu
   */
  @Override
  public String getName() {
    return "add join";
  }
  
  /**
   * Checks if a footer template is already present in the given GUI model
   */
  @Override
  public boolean canExecute(final FORSIB node) throws ClassCastException {
    final Function1<Argument, Boolean> _function = new Function1<Argument, Boolean>() {
      @Override
      public Boolean apply(final Argument it) {
        return Boolean.valueOf(it.getBlockName().equals("JOIN"));
      }
    };
    boolean _exists = IterableExtensions.<Argument>exists(node.getArguments(), _function);
    return (!_exists);
  }
  
  /**
   * Creates a new footer template on the given GUI model
   */
  @Override
  public void execute(final FORSIB node) {
    Argument arg = node.newArgument(10, 0);
    arg.setBlockName("JOIN");
    CreateComponentHook cch = new CreateComponentHook();
    cch.postCreate(arg);
  }
}
