/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.gui.actions;

import graphmodel.Node;
import info.scce.dime.api.DIMECustomAction;
import info.scce.dime.gui.gui.GUI;
import info.scce.dime.gui.gui.Template;
import java.util.function.Function;
import java.util.function.Predicate;

/**
 * Context menu action which can only be used on the GUI graphmodel.
 * Adds a footer template to the model, if no footer is already present
 * @author zweihoff
 */
@SuppressWarnings("all")
public class AddFooter extends DIMECustomAction<GUI> {
  /**
   * Returns the name displayed in the context menu
   */
  @Override
  public String getName() {
    return "Add Footer";
  }
  
  /**
   * Checks if a footer template is already present in the given GUI model
   */
  @Override
  public boolean canExecute(final GUI gui) throws ClassCastException {
    final Predicate<Node> _function = new Predicate<Node>() {
      @Override
      public boolean test(final Node n) {
        return (n instanceof Template);
      }
    };
    final Function<Node, Template> _function_1 = new Function<Node, Template>() {
      @Override
      public Template apply(final Node n) {
        return ((Template) n);
      }
    };
    final Predicate<Template> _function_2 = new Predicate<Template>() {
      @Override
      public boolean test(final Template n) {
        return n.getBlockName().equals("footer");
      }
    };
    boolean _isPresent = gui.getAllNodes().stream().filter(_function).<Template>map(_function_1).filter(_function_2).findAny().isPresent();
    return (!_isPresent);
  }
  
  /**
   * Creates a new footer template on the given GUI model
   */
  @Override
  public void execute(final GUI gui) {
    Template ct = gui.newTemplate(100, 200);
    ct.setBlockName("footer");
  }
}
