/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.util;

import de.jabc.cinco.meta.runtime.CincoRuntimeBaseClass;
import graphmodel.Container;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class LayoutUtils extends CincoRuntimeBaseClass {
  private final int MARGIN = 20;
  
  public void layout(final Container container) {
    final EList<Container> children = container.getAllContainers();
    int totalHeight = 30;
    for (final Container child : children) {
      {
        int _width = container.getWidth();
        int _minus = (_width - this.MARGIN);
        child.setWidth(_minus);
        child.setX((this.MARGIN / 2));
        child.setY(totalHeight);
        int _talHeight = totalHeight;
        int _height = child.getHeight();
        int _plus = (_height + this.MARGIN);
        totalHeight = (_talHeight + _plus);
      }
    }
    container.setHeight(totalHeight);
  }
}
