package info.scce.dime.graphql.schema.factory;

import de.jabc.cinco.meta.runtime.xapi.WorkbenchExtension;
import graphmodel.GraphModel;
import graphmodel.IdentifiableElement;
import graphmodel.ModelElement;
import graphmodel.Type;
import graphmodel.internal.InternalGraphModel;
import graphmodel.internal.InternalIdentifiableElement;
import graphmodel.internal.InternalModelElement;
import graphmodel.internal.InternalModelElementContainer;
import graphmodel.internal.InternalType;
import info.scce.dime.graphql.hooks.APISIBPostCreateHook;
import info.scce.dime.graphql.hooks.GraphQLInit;
import info.scce.dime.graphql.hooks.ReferencedTypePostCreate;
import info.scce.dime.graphql.hooks.ResolverAttributePostCreateHook;
import info.scce.dime.graphql.hooks.ResolverPostCreateHook;
import info.scce.dime.graphql.hooks.ResolverProcessPostCreateHook;
import info.scce.dime.graphql.schema.adapter.APISIBEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ApiErrorEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ApiInputEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ApiOutputEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ForbiddenComplexAttributeEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ForbiddenPrimitiveAttributeEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ForbiddenTypeEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ForbiddenTypesEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ForbiddenUserTypeEContentAdapter;
import info.scce.dime.graphql.schema.adapter.GraphQLEContentAdapter;
import info.scce.dime.graphql.schema.adapter.MutationsEContentAdapter;
import info.scce.dime.graphql.schema.adapter.QueriesEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ResolverAttributeEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ResolverEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ResolverProcessEContentAdapter;
import info.scce.dime.graphql.schema.adapter.ResolversEContentAdapter;
import info.scce.dime.graphql.schema.graphql.APISIB;
import info.scce.dime.graphql.schema.graphql.ApiError;
import info.scce.dime.graphql.schema.graphql.ApiInput;
import info.scce.dime.graphql.schema.graphql.ApiOutput;
import info.scce.dime.graphql.schema.graphql.ForbiddenComplexAttribute;
import info.scce.dime.graphql.schema.graphql.ForbiddenPrimitiveAttribute;
import info.scce.dime.graphql.schema.graphql.ForbiddenType;
import info.scce.dime.graphql.schema.graphql.ForbiddenTypes;
import info.scce.dime.graphql.schema.graphql.ForbiddenUserType;
import info.scce.dime.graphql.schema.graphql.GraphQL;
import info.scce.dime.graphql.schema.graphql.GraphqlPackage;
import info.scce.dime.graphql.schema.graphql.Mutations;
import info.scce.dime.graphql.schema.graphql.Queries;
import info.scce.dime.graphql.schema.graphql.Resolver;
import info.scce.dime.graphql.schema.graphql.ResolverAttribute;
import info.scce.dime.graphql.schema.graphql.ResolverProcess;
import info.scce.dime.graphql.schema.graphql.Resolvers;
import info.scce.dime.graphql.schema.graphql.impl.GraphqlFactoryImpl;
import info.scce.dime.graphql.schema.graphql.internal.InternalAPISIB;
import info.scce.dime.graphql.schema.graphql.internal.InternalApiError;
import info.scce.dime.graphql.schema.graphql.internal.InternalApiInput;
import info.scce.dime.graphql.schema.graphql.internal.InternalApiOutput;
import info.scce.dime.graphql.schema.graphql.internal.InternalFactory;
import info.scce.dime.graphql.schema.graphql.internal.InternalForbiddenComplexAttribute;
import info.scce.dime.graphql.schema.graphql.internal.InternalForbiddenPrimitiveAttribute;
import info.scce.dime.graphql.schema.graphql.internal.InternalForbiddenType;
import info.scce.dime.graphql.schema.graphql.internal.InternalForbiddenTypes;
import info.scce.dime.graphql.schema.graphql.internal.InternalForbiddenUserType;
import info.scce.dime.graphql.schema.graphql.internal.InternalGraphQL;
import info.scce.dime.graphql.schema.graphql.internal.InternalMutations;
import info.scce.dime.graphql.schema.graphql.internal.InternalQueries;
import info.scce.dime.graphql.schema.graphql.internal.InternalResolver;
import info.scce.dime.graphql.schema.graphql.internal.InternalResolverAttribute;
import info.scce.dime.graphql.schema.graphql.internal.InternalResolverProcess;
import info.scce.dime.graphql.schema.graphql.internal.InternalResolvers;
import java.io.IOException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures.Procedure1;
import org.eclipse.xtext.xbase.lib.StringExtensions;

@SuppressWarnings("all")
public class GraphQLFactory extends GraphqlFactoryImpl {
  @Extension
  private final InternalFactory _internalFactory = InternalFactory.eINSTANCE;
  
  public static GraphQLFactory eINSTANCE = GraphQLFactory.init();
  
  @Extension
  private WorkbenchExtension _workbenchExtension = new WorkbenchExtension();
  
  public static GraphQLFactory init() {
    GraphQLFactory _xblockexpression = null;
    {
      try {
        EFactory _eFactory = EPackage.Registry.INSTANCE.getEFactory(GraphqlPackage.eNS_URI);
        final GraphQLFactory fct = ((GraphQLFactory) _eFactory);
        if ((fct != null)) {
          return ((GraphQLFactory) fct);
        }
      } catch (final Throwable _t) {
        if (_t instanceof Exception) {
          final Exception exception = (Exception)_t;
          EcorePlugin.INSTANCE.log(exception);
        } else {
          throw Exceptions.sneakyThrow(_t);
        }
      }
      _xblockexpression = new GraphQLFactory();
    }
    return _xblockexpression;
  }
  
  /**
   * This method creates an GraphQL with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public GraphQL createGraphQL(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    GraphQL _createGraphQL = super.createGraphQL();
    final Procedure1<GraphQL> _function = new Procedure1<GraphQL>() {
      @Override
      public void apply(final GraphQL it) {
        EcoreUtil.setID(it, ID);
        InternalIdentifiableElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalGraphQL _createInternalGraphQL = GraphQLFactory.this._internalFactory.createInternalGraphQL();
          _elvis = _createInternalGraphQL;
        }
        final Procedure1<InternalIdentifiableElement> _function = new Procedure1<InternalIdentifiableElement>() {
          @Override
          public void apply(final InternalIdentifiableElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            EList<Adapter> _eAdapters = it.eAdapters();
            GraphQLEContentAdapter _graphQLEContentAdapter = new GraphQLEContentAdapter();
            _eAdapters.add(_graphQLEContentAdapter);
          }
        };
        InternalIdentifiableElement _doubleArrow = ObjectExtensions.<InternalIdentifiableElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          GraphQLFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<GraphQL>operator_doubleArrow(_createGraphQL, _function);
  }
  
  /**
   * This method creates an GraphQL with the given id. Post create hook won't be triggered.
   */
  public GraphQL createGraphQL(final String ID) {
    return this.createGraphQL(ID, null, null, false);
  }
  
  /**
   * This method creates an GraphQL with the given id. Post create hook will be triggered.
   */
  public GraphQL createGraphQL(final InternalModelElementContainer parent) {
    return this.createGraphQL(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an GraphQL with the given id. Post create hook will be triggered.
   */
  public GraphQL createGraphQL(final String ID, final InternalModelElementContainer parent) {
    return this.createGraphQL(ID, null, parent, true);
  }
  
  public GraphQL createGraphQL(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createGraphQL(ID, ime, parent, true);
  }
  
  /**
   * This method creates an GraphQL with the given id. Post create hook won't be triggered.
   */
  public GraphQL createGraphQL(final InternalModelElement ime) {
    return this.createGraphQL(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public GraphQL createGraphQL() {
    return this.createGraphQL(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ApiInput with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ApiInput createApiInput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ApiInput _createApiInput = super.createApiInput();
    final Procedure1<ApiInput> _function = new Procedure1<ApiInput>() {
      @Override
      public void apply(final ApiInput it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalApiInput _createInternalApiInput = GraphQLFactory.this._internalFactory.createInternalApiInput();
          _elvis = _createInternalApiInput;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ApiInputEContentAdapter _apiInputEContentAdapter = new ApiInputEContentAdapter();
            _eAdapters.add(_apiInputEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ApiInput>operator_doubleArrow(_createApiInput, _function);
  }
  
  /**
   * This method creates an ApiInput with the given id. Post create hook won't be triggered.
   */
  public ApiInput createApiInput(final String ID) {
    return this.createApiInput(ID, null, null, false);
  }
  
  /**
   * This method creates an ApiInput with the given id. Post create hook will be triggered.
   */
  public ApiInput createApiInput(final InternalModelElementContainer parent) {
    return this.createApiInput(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ApiInput with the given id. Post create hook will be triggered.
   */
  public ApiInput createApiInput(final String ID, final InternalModelElementContainer parent) {
    return this.createApiInput(ID, null, parent, true);
  }
  
  public ApiInput createApiInput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createApiInput(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ApiInput with the given id. Post create hook won't be triggered.
   */
  public ApiInput createApiInput(final InternalModelElement ime) {
    return this.createApiInput(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ApiInput createApiInput() {
    return this.createApiInput(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Queries with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Queries createQueries(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Queries _createQueries = super.createQueries();
    final Procedure1<Queries> _function = new Procedure1<Queries>() {
      @Override
      public void apply(final Queries it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalQueries _createInternalQueries = GraphQLFactory.this._internalFactory.createInternalQueries();
          _elvis = _createInternalQueries;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            QueriesEContentAdapter _queriesEContentAdapter = new QueriesEContentAdapter();
            _eAdapters.add(_queriesEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Queries>operator_doubleArrow(_createQueries, _function);
  }
  
  /**
   * This method creates an Queries with the given id. Post create hook won't be triggered.
   */
  public Queries createQueries(final String ID) {
    return this.createQueries(ID, null, null, false);
  }
  
  /**
   * This method creates an Queries with the given id. Post create hook will be triggered.
   */
  public Queries createQueries(final InternalModelElementContainer parent) {
    return this.createQueries(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Queries with the given id. Post create hook will be triggered.
   */
  public Queries createQueries(final String ID, final InternalModelElementContainer parent) {
    return this.createQueries(ID, null, parent, true);
  }
  
  public Queries createQueries(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createQueries(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Queries with the given id. Post create hook won't be triggered.
   */
  public Queries createQueries(final InternalModelElement ime) {
    return this.createQueries(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Queries createQueries() {
    return this.createQueries(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ForbiddenPrimitiveAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ForbiddenPrimitiveAttribute createForbiddenPrimitiveAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ForbiddenPrimitiveAttribute _createForbiddenPrimitiveAttribute = super.createForbiddenPrimitiveAttribute();
    final Procedure1<ForbiddenPrimitiveAttribute> _function = new Procedure1<ForbiddenPrimitiveAttribute>() {
      @Override
      public void apply(final ForbiddenPrimitiveAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalForbiddenPrimitiveAttribute _createInternalForbiddenPrimitiveAttribute = GraphQLFactory.this._internalFactory.createInternalForbiddenPrimitiveAttribute();
          _elvis = _createInternalForbiddenPrimitiveAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ForbiddenPrimitiveAttributeEContentAdapter _forbiddenPrimitiveAttributeEContentAdapter = new ForbiddenPrimitiveAttributeEContentAdapter();
            _eAdapters.add(_forbiddenPrimitiveAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ForbiddenPrimitiveAttribute>operator_doubleArrow(_createForbiddenPrimitiveAttribute, _function);
  }
  
  /**
   * This method creates an ForbiddenPrimitiveAttribute with the given id. Post create hook won't be triggered.
   */
  public ForbiddenPrimitiveAttribute createForbiddenPrimitiveAttribute(final String ID) {
    return this.createForbiddenPrimitiveAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ForbiddenPrimitiveAttribute with the given id. Post create hook will be triggered.
   */
  public ForbiddenPrimitiveAttribute createForbiddenPrimitiveAttribute(final InternalModelElementContainer parent) {
    return this.createForbiddenPrimitiveAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ForbiddenPrimitiveAttribute with the given id. Post create hook will be triggered.
   */
  public ForbiddenPrimitiveAttribute createForbiddenPrimitiveAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createForbiddenPrimitiveAttribute(ID, null, parent, true);
  }
  
  public ForbiddenPrimitiveAttribute createForbiddenPrimitiveAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createForbiddenPrimitiveAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ForbiddenPrimitiveAttribute with the given id. Post create hook won't be triggered.
   */
  public ForbiddenPrimitiveAttribute createForbiddenPrimitiveAttribute(final InternalModelElement ime) {
    return this.createForbiddenPrimitiveAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ForbiddenPrimitiveAttribute createForbiddenPrimitiveAttribute() {
    return this.createForbiddenPrimitiveAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ForbiddenTypes with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ForbiddenTypes createForbiddenTypes(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ForbiddenTypes _createForbiddenTypes = super.createForbiddenTypes();
    final Procedure1<ForbiddenTypes> _function = new Procedure1<ForbiddenTypes>() {
      @Override
      public void apply(final ForbiddenTypes it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalForbiddenTypes _createInternalForbiddenTypes = GraphQLFactory.this._internalFactory.createInternalForbiddenTypes();
          _elvis = _createInternalForbiddenTypes;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ForbiddenTypesEContentAdapter _forbiddenTypesEContentAdapter = new ForbiddenTypesEContentAdapter();
            _eAdapters.add(_forbiddenTypesEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ForbiddenTypes>operator_doubleArrow(_createForbiddenTypes, _function);
  }
  
  /**
   * This method creates an ForbiddenTypes with the given id. Post create hook won't be triggered.
   */
  public ForbiddenTypes createForbiddenTypes(final String ID) {
    return this.createForbiddenTypes(ID, null, null, false);
  }
  
  /**
   * This method creates an ForbiddenTypes with the given id. Post create hook will be triggered.
   */
  public ForbiddenTypes createForbiddenTypes(final InternalModelElementContainer parent) {
    return this.createForbiddenTypes(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ForbiddenTypes with the given id. Post create hook will be triggered.
   */
  public ForbiddenTypes createForbiddenTypes(final String ID, final InternalModelElementContainer parent) {
    return this.createForbiddenTypes(ID, null, parent, true);
  }
  
  public ForbiddenTypes createForbiddenTypes(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createForbiddenTypes(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ForbiddenTypes with the given id. Post create hook won't be triggered.
   */
  public ForbiddenTypes createForbiddenTypes(final InternalModelElement ime) {
    return this.createForbiddenTypes(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ForbiddenTypes createForbiddenTypes() {
    return this.createForbiddenTypes(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ForbiddenType with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ForbiddenType createForbiddenType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ForbiddenType _createForbiddenType = super.createForbiddenType();
    final Procedure1<ForbiddenType> _function = new Procedure1<ForbiddenType>() {
      @Override
      public void apply(final ForbiddenType it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalForbiddenType _createInternalForbiddenType = GraphQLFactory.this._internalFactory.createInternalForbiddenType();
          _elvis = _createInternalForbiddenType;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ForbiddenTypeEContentAdapter _forbiddenTypeEContentAdapter = new ForbiddenTypeEContentAdapter();
            _eAdapters.add(_forbiddenTypeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          GraphQLFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ForbiddenType>operator_doubleArrow(_createForbiddenType, _function);
  }
  
  /**
   * This method creates an ForbiddenType with the given id. Post create hook won't be triggered.
   */
  public ForbiddenType createForbiddenType(final String ID) {
    return this.createForbiddenType(ID, null, null, false);
  }
  
  /**
   * This method creates an ForbiddenType with the given id. Post create hook will be triggered.
   */
  public ForbiddenType createForbiddenType(final InternalModelElementContainer parent) {
    return this.createForbiddenType(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ForbiddenType with the given id. Post create hook will be triggered.
   */
  public ForbiddenType createForbiddenType(final String ID, final InternalModelElementContainer parent) {
    return this.createForbiddenType(ID, null, parent, true);
  }
  
  public ForbiddenType createForbiddenType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createForbiddenType(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ForbiddenType with the given id. Post create hook won't be triggered.
   */
  public ForbiddenType createForbiddenType(final InternalModelElement ime) {
    return this.createForbiddenType(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ForbiddenType createForbiddenType() {
    return this.createForbiddenType(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Mutations with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Mutations createMutations(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Mutations _createMutations = super.createMutations();
    final Procedure1<Mutations> _function = new Procedure1<Mutations>() {
      @Override
      public void apply(final Mutations it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalMutations _createInternalMutations = GraphQLFactory.this._internalFactory.createInternalMutations();
          _elvis = _createInternalMutations;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            MutationsEContentAdapter _mutationsEContentAdapter = new MutationsEContentAdapter();
            _eAdapters.add(_mutationsEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Mutations>operator_doubleArrow(_createMutations, _function);
  }
  
  /**
   * This method creates an Mutations with the given id. Post create hook won't be triggered.
   */
  public Mutations createMutations(final String ID) {
    return this.createMutations(ID, null, null, false);
  }
  
  /**
   * This method creates an Mutations with the given id. Post create hook will be triggered.
   */
  public Mutations createMutations(final InternalModelElementContainer parent) {
    return this.createMutations(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Mutations with the given id. Post create hook will be triggered.
   */
  public Mutations createMutations(final String ID, final InternalModelElementContainer parent) {
    return this.createMutations(ID, null, parent, true);
  }
  
  public Mutations createMutations(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createMutations(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Mutations with the given id. Post create hook won't be triggered.
   */
  public Mutations createMutations(final InternalModelElement ime) {
    return this.createMutations(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Mutations createMutations() {
    return this.createMutations(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ForbiddenUserType with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ForbiddenUserType createForbiddenUserType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ForbiddenUserType _createForbiddenUserType = super.createForbiddenUserType();
    final Procedure1<ForbiddenUserType> _function = new Procedure1<ForbiddenUserType>() {
      @Override
      public void apply(final ForbiddenUserType it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalForbiddenUserType _createInternalForbiddenUserType = GraphQLFactory.this._internalFactory.createInternalForbiddenUserType();
          _elvis = _createInternalForbiddenUserType;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ForbiddenUserTypeEContentAdapter _forbiddenUserTypeEContentAdapter = new ForbiddenUserTypeEContentAdapter();
            _eAdapters.add(_forbiddenUserTypeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          GraphQLFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ForbiddenUserType>operator_doubleArrow(_createForbiddenUserType, _function);
  }
  
  /**
   * This method creates an ForbiddenUserType with the given id. Post create hook won't be triggered.
   */
  public ForbiddenUserType createForbiddenUserType(final String ID) {
    return this.createForbiddenUserType(ID, null, null, false);
  }
  
  /**
   * This method creates an ForbiddenUserType with the given id. Post create hook will be triggered.
   */
  public ForbiddenUserType createForbiddenUserType(final InternalModelElementContainer parent) {
    return this.createForbiddenUserType(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ForbiddenUserType with the given id. Post create hook will be triggered.
   */
  public ForbiddenUserType createForbiddenUserType(final String ID, final InternalModelElementContainer parent) {
    return this.createForbiddenUserType(ID, null, parent, true);
  }
  
  public ForbiddenUserType createForbiddenUserType(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createForbiddenUserType(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ForbiddenUserType with the given id. Post create hook won't be triggered.
   */
  public ForbiddenUserType createForbiddenUserType(final InternalModelElement ime) {
    return this.createForbiddenUserType(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ForbiddenUserType createForbiddenUserType() {
    return this.createForbiddenUserType(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ResolverProcess with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ResolverProcess createResolverProcess(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ResolverProcess _createResolverProcess = super.createResolverProcess();
    final Procedure1<ResolverProcess> _function = new Procedure1<ResolverProcess>() {
      @Override
      public void apply(final ResolverProcess it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalResolverProcess _createInternalResolverProcess = GraphQLFactory.this._internalFactory.createInternalResolverProcess();
          _elvis = _createInternalResolverProcess;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ResolverProcessEContentAdapter _resolverProcessEContentAdapter = new ResolverProcessEContentAdapter();
            _eAdapters.add(_resolverProcessEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          GraphQLFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ResolverProcess>operator_doubleArrow(_createResolverProcess, _function);
  }
  
  /**
   * This method creates an ResolverProcess with the given id. Post create hook won't be triggered.
   */
  public ResolverProcess createResolverProcess(final String ID) {
    return this.createResolverProcess(ID, null, null, false);
  }
  
  /**
   * This method creates an ResolverProcess with the given id. Post create hook will be triggered.
   */
  public ResolverProcess createResolverProcess(final InternalModelElementContainer parent) {
    return this.createResolverProcess(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ResolverProcess with the given id. Post create hook will be triggered.
   */
  public ResolverProcess createResolverProcess(final String ID, final InternalModelElementContainer parent) {
    return this.createResolverProcess(ID, null, parent, true);
  }
  
  public ResolverProcess createResolverProcess(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createResolverProcess(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ResolverProcess with the given id. Post create hook won't be triggered.
   */
  public ResolverProcess createResolverProcess(final InternalModelElement ime) {
    return this.createResolverProcess(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ResolverProcess createResolverProcess() {
    return this.createResolverProcess(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Resolver with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Resolver createResolver(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Resolver _createResolver = super.createResolver();
    final Procedure1<Resolver> _function = new Procedure1<Resolver>() {
      @Override
      public void apply(final Resolver it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalResolver _createInternalResolver = GraphQLFactory.this._internalFactory.createInternalResolver();
          _elvis = _createInternalResolver;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ResolverEContentAdapter _resolverEContentAdapter = new ResolverEContentAdapter();
            _eAdapters.add(_resolverEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          GraphQLFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<Resolver>operator_doubleArrow(_createResolver, _function);
  }
  
  /**
   * This method creates an Resolver with the given id. Post create hook won't be triggered.
   */
  public Resolver createResolver(final String ID) {
    return this.createResolver(ID, null, null, false);
  }
  
  /**
   * This method creates an Resolver with the given id. Post create hook will be triggered.
   */
  public Resolver createResolver(final InternalModelElementContainer parent) {
    return this.createResolver(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Resolver with the given id. Post create hook will be triggered.
   */
  public Resolver createResolver(final String ID, final InternalModelElementContainer parent) {
    return this.createResolver(ID, null, parent, true);
  }
  
  public Resolver createResolver(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createResolver(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Resolver with the given id. Post create hook won't be triggered.
   */
  public Resolver createResolver(final InternalModelElement ime) {
    return this.createResolver(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Resolver createResolver() {
    return this.createResolver(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an APISIB with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public APISIB createAPISIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    APISIB _createAPISIB = super.createAPISIB();
    final Procedure1<APISIB> _function = new Procedure1<APISIB>() {
      @Override
      public void apply(final APISIB it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalAPISIB _createInternalAPISIB = GraphQLFactory.this._internalFactory.createInternalAPISIB();
          _elvis = _createInternalAPISIB;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            APISIBEContentAdapter _aPISIBEContentAdapter = new APISIBEContentAdapter();
            _eAdapters.add(_aPISIBEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          GraphQLFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<APISIB>operator_doubleArrow(_createAPISIB, _function);
  }
  
  /**
   * This method creates an APISIB with the given id. Post create hook won't be triggered.
   */
  public APISIB createAPISIB(final String ID) {
    return this.createAPISIB(ID, null, null, false);
  }
  
  /**
   * This method creates an APISIB with the given id. Post create hook will be triggered.
   */
  public APISIB createAPISIB(final InternalModelElementContainer parent) {
    return this.createAPISIB(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an APISIB with the given id. Post create hook will be triggered.
   */
  public APISIB createAPISIB(final String ID, final InternalModelElementContainer parent) {
    return this.createAPISIB(ID, null, parent, true);
  }
  
  public APISIB createAPISIB(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createAPISIB(ID, ime, parent, true);
  }
  
  /**
   * This method creates an APISIB with the given id. Post create hook won't be triggered.
   */
  public APISIB createAPISIB(final InternalModelElement ime) {
    return this.createAPISIB(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public APISIB createAPISIB() {
    return this.createAPISIB(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ResolverAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ResolverAttribute createResolverAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ResolverAttribute _createResolverAttribute = super.createResolverAttribute();
    final Procedure1<ResolverAttribute> _function = new Procedure1<ResolverAttribute>() {
      @Override
      public void apply(final ResolverAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalResolverAttribute _createInternalResolverAttribute = GraphQLFactory.this._internalFactory.createInternalResolverAttribute();
          _elvis = _createInternalResolverAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ResolverAttributeEContentAdapter _resolverAttributeEContentAdapter = new ResolverAttributeEContentAdapter();
            _eAdapters.add(_resolverAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
        if (hook) {
          GraphQLFactory.this.postCreates(it);
        }
      }
    };
    return ObjectExtensions.<ResolverAttribute>operator_doubleArrow(_createResolverAttribute, _function);
  }
  
  /**
   * This method creates an ResolverAttribute with the given id. Post create hook won't be triggered.
   */
  public ResolverAttribute createResolverAttribute(final String ID) {
    return this.createResolverAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ResolverAttribute with the given id. Post create hook will be triggered.
   */
  public ResolverAttribute createResolverAttribute(final InternalModelElementContainer parent) {
    return this.createResolverAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ResolverAttribute with the given id. Post create hook will be triggered.
   */
  public ResolverAttribute createResolverAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createResolverAttribute(ID, null, parent, true);
  }
  
  public ResolverAttribute createResolverAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createResolverAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ResolverAttribute with the given id. Post create hook won't be triggered.
   */
  public ResolverAttribute createResolverAttribute(final InternalModelElement ime) {
    return this.createResolverAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ResolverAttribute createResolverAttribute() {
    return this.createResolverAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ForbiddenComplexAttribute with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ForbiddenComplexAttribute createForbiddenComplexAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ForbiddenComplexAttribute _createForbiddenComplexAttribute = super.createForbiddenComplexAttribute();
    final Procedure1<ForbiddenComplexAttribute> _function = new Procedure1<ForbiddenComplexAttribute>() {
      @Override
      public void apply(final ForbiddenComplexAttribute it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalForbiddenComplexAttribute _createInternalForbiddenComplexAttribute = GraphQLFactory.this._internalFactory.createInternalForbiddenComplexAttribute();
          _elvis = _createInternalForbiddenComplexAttribute;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ForbiddenComplexAttributeEContentAdapter _forbiddenComplexAttributeEContentAdapter = new ForbiddenComplexAttributeEContentAdapter();
            _eAdapters.add(_forbiddenComplexAttributeEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ForbiddenComplexAttribute>operator_doubleArrow(_createForbiddenComplexAttribute, _function);
  }
  
  /**
   * This method creates an ForbiddenComplexAttribute with the given id. Post create hook won't be triggered.
   */
  public ForbiddenComplexAttribute createForbiddenComplexAttribute(final String ID) {
    return this.createForbiddenComplexAttribute(ID, null, null, false);
  }
  
  /**
   * This method creates an ForbiddenComplexAttribute with the given id. Post create hook will be triggered.
   */
  public ForbiddenComplexAttribute createForbiddenComplexAttribute(final InternalModelElementContainer parent) {
    return this.createForbiddenComplexAttribute(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ForbiddenComplexAttribute with the given id. Post create hook will be triggered.
   */
  public ForbiddenComplexAttribute createForbiddenComplexAttribute(final String ID, final InternalModelElementContainer parent) {
    return this.createForbiddenComplexAttribute(ID, null, parent, true);
  }
  
  public ForbiddenComplexAttribute createForbiddenComplexAttribute(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createForbiddenComplexAttribute(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ForbiddenComplexAttribute with the given id. Post create hook won't be triggered.
   */
  public ForbiddenComplexAttribute createForbiddenComplexAttribute(final InternalModelElement ime) {
    return this.createForbiddenComplexAttribute(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ForbiddenComplexAttribute createForbiddenComplexAttribute() {
    return this.createForbiddenComplexAttribute(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ApiError with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ApiError createApiError(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ApiError _createApiError = super.createApiError();
    final Procedure1<ApiError> _function = new Procedure1<ApiError>() {
      @Override
      public void apply(final ApiError it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalApiError _createInternalApiError = GraphQLFactory.this._internalFactory.createInternalApiError();
          _elvis = _createInternalApiError;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ApiErrorEContentAdapter _apiErrorEContentAdapter = new ApiErrorEContentAdapter();
            _eAdapters.add(_apiErrorEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ApiError>operator_doubleArrow(_createApiError, _function);
  }
  
  /**
   * This method creates an ApiError with the given id. Post create hook won't be triggered.
   */
  public ApiError createApiError(final String ID) {
    return this.createApiError(ID, null, null, false);
  }
  
  /**
   * This method creates an ApiError with the given id. Post create hook will be triggered.
   */
  public ApiError createApiError(final InternalModelElementContainer parent) {
    return this.createApiError(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ApiError with the given id. Post create hook will be triggered.
   */
  public ApiError createApiError(final String ID, final InternalModelElementContainer parent) {
    return this.createApiError(ID, null, parent, true);
  }
  
  public ApiError createApiError(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createApiError(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ApiError with the given id. Post create hook won't be triggered.
   */
  public ApiError createApiError(final InternalModelElement ime) {
    return this.createApiError(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ApiError createApiError() {
    return this.createApiError(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an ApiOutput with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public ApiOutput createApiOutput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    ApiOutput _createApiOutput = super.createApiOutput();
    final Procedure1<ApiOutput> _function = new Procedure1<ApiOutput>() {
      @Override
      public void apply(final ApiOutput it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalApiOutput _createInternalApiOutput = GraphQLFactory.this._internalFactory.createInternalApiOutput();
          _elvis = _createInternalApiOutput;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ApiOutputEContentAdapter _apiOutputEContentAdapter = new ApiOutputEContentAdapter();
            _eAdapters.add(_apiOutputEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<ApiOutput>operator_doubleArrow(_createApiOutput, _function);
  }
  
  /**
   * This method creates an ApiOutput with the given id. Post create hook won't be triggered.
   */
  public ApiOutput createApiOutput(final String ID) {
    return this.createApiOutput(ID, null, null, false);
  }
  
  /**
   * This method creates an ApiOutput with the given id. Post create hook will be triggered.
   */
  public ApiOutput createApiOutput(final InternalModelElementContainer parent) {
    return this.createApiOutput(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an ApiOutput with the given id. Post create hook will be triggered.
   */
  public ApiOutput createApiOutput(final String ID, final InternalModelElementContainer parent) {
    return this.createApiOutput(ID, null, parent, true);
  }
  
  public ApiOutput createApiOutput(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createApiOutput(ID, ime, parent, true);
  }
  
  /**
   * This method creates an ApiOutput with the given id. Post create hook won't be triggered.
   */
  public ApiOutput createApiOutput(final InternalModelElement ime) {
    return this.createApiOutput(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public ApiOutput createApiOutput() {
    return this.createApiOutput(EcoreUtil.generateUUID());
  }
  
  /**
   * This method creates an Resolvers with the given id.
   * 
   * @param ID: The id for the new element
   * @param ime: The internal model element {@link graphmodel.internal.InternalModelElement}
   * @param parent: The parent element of the newly created element. Needed if a post create hook accesses the parent
   * element of the created element
   * @param hook: Indicates, if the post create hook should be executed
   */
  public Resolvers createResolvers(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent, final boolean hook) {
    Resolvers _createResolvers = super.createResolvers();
    final Procedure1<Resolvers> _function = new Procedure1<Resolvers>() {
      @Override
      public void apply(final Resolvers it) {
        EcoreUtil.setID(it, ID);
        InternalModelElement _elvis = null;
        if (ime != null) {
          _elvis = ime;
        } else {
          InternalResolvers _createInternalResolvers = GraphQLFactory.this._internalFactory.createInternalResolvers();
          _elvis = _createInternalResolvers;
        }
        final Procedure1<InternalModelElement> _function = new Procedure1<InternalModelElement>() {
          @Override
          public void apply(final InternalModelElement it) {
            EcoreUtil.setID(it, (ID + "_INTERNAL"));
            it.setContainer(parent);
            EList<Adapter> _eAdapters = it.eAdapters();
            ResolversEContentAdapter _resolversEContentAdapter = new ResolversEContentAdapter();
            _eAdapters.add(_resolversEContentAdapter);
          }
        };
        InternalModelElement _doubleArrow = ObjectExtensions.<InternalModelElement>operator_doubleArrow(_elvis, _function);
        GraphQLFactory.this.setInternal(it, _doubleArrow);
      }
    };
    return ObjectExtensions.<Resolvers>operator_doubleArrow(_createResolvers, _function);
  }
  
  /**
   * This method creates an Resolvers with the given id. Post create hook won't be triggered.
   */
  public Resolvers createResolvers(final String ID) {
    return this.createResolvers(ID, null, null, false);
  }
  
  /**
   * This method creates an Resolvers with the given id. Post create hook will be triggered.
   */
  public Resolvers createResolvers(final InternalModelElementContainer parent) {
    return this.createResolvers(EcoreUtil.generateUUID(), null, parent, true);
  }
  
  /**
   * This method creates an Resolvers with the given id. Post create hook will be triggered.
   */
  public Resolvers createResolvers(final String ID, final InternalModelElementContainer parent) {
    return this.createResolvers(ID, null, parent, true);
  }
  
  public Resolvers createResolvers(final String ID, final InternalModelElement ime, final InternalModelElementContainer parent) {
    return this.createResolvers(ID, ime, parent, true);
  }
  
  /**
   * This method creates an Resolvers with the given id. Post create hook won't be triggered.
   */
  public Resolvers createResolvers(final InternalModelElement ime) {
    return this.createResolvers(EcoreUtil.generateUUID(), ime, null, false);
  }
  
  @Override
  public Resolvers createResolvers() {
    return this.createResolvers(EcoreUtil.generateUUID());
  }
  
  private <T extends IdentifiableElement> T setInternal(final T elm, final InternalIdentifiableElement internal) {
    final Procedure1<T> _function = new Procedure1<T>() {
      @Override
      public void apply(final T it) {
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty(it.getId());
        if (_isNullOrEmpty) {
          EcoreUtil.setID(it, EcoreUtil.generateUUID());
        }
        boolean _matched = false;
        if (elm instanceof GraphModel) {
          _matched=true;
          ((GraphModel)elm).setInternalElement_(((InternalGraphModel) internal));
        }
        if (!_matched) {
          if (elm instanceof ModelElement) {
            _matched=true;
            ((ModelElement)elm).setInternalElement_(((InternalModelElement) internal));
          }
        }
        if (!_matched) {
          if (elm instanceof Type) {
            _matched=true;
            ((Type)elm).setInternalElement_(((InternalType) internal));
          }
        }
      }
    };
    return ObjectExtensions.<T>operator_doubleArrow(elm, _function);
  }
  
  /**
   * This method creates a new GraphQL object with an underlying org.eclipse.emf.ecore.resource.Resource. Thus you can
   * simply call the GraphQL's save method to save your changes.
   */
  public GraphQL createGraphQL(final String path, final String fileName) {
    IPath filePath = new Path(path).append(fileName).addFileExtension("graphql");
    URI uri = URI.createPlatformResourceURI(filePath.toOSString(), true);
    Resource res = new ResourceSetImpl().createResource(uri);
    GraphQL graph = GraphQLFactory.eINSTANCE.createGraphQL();
    EcoreUtil.setID(graph, EcoreUtil.generateUUID());
    res.getContents().add(graph.getInternalElement_());
    this.postCreates(graph);
    try {
      res.save(null);
    } catch (final Throwable _t) {
      if (_t instanceof IOException) {
        final IOException e = (IOException)_t;
        e.printStackTrace();
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
    return graph;
  }
  
  public void postCreates(final Resolver me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ResolverPostCreateHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ResolverAttribute me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ResolverAttributePostCreateHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ResolverProcess me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ResolverProcessPostCreateHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final APISIB me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new APISIBPostCreateHook().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ForbiddenType me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ReferencedTypePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final ForbiddenUserType me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new ReferencedTypePostCreate().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
  
  public void postCreates(final GraphQL me) {
    final Runnable _function = new Runnable() {
      @Override
      public void run() {
        new GraphQLInit().postCreate(me);
      }
    };
    this._workbenchExtension.transact(me, _function);
  }
}
