/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import info.scce.dime.graphql.schema.graphql.Resolver;
import info.scce.dime.graphql.schema.graphql.ResolverAttribute;
import info.scce.dime.graphql.schema.graphql.ResolverProcess;
import info.scce.dime.graphql.schema.graphql.Resolvers;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.Functions.Function2;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@SuppressWarnings("all")
public class ResolversLayouter {
  public void layout(final Resolvers resolversContainer) {
    final int offsetTop = 30;
    final int offsetBottom = 15;
    final int offsetY = 10;
    final int offsetX = 10;
    int curY = offsetTop;
    EList<Resolver> _resolvers = resolversContainer.getResolvers();
    for (final Resolver resolver : _resolvers) {
      {
        resolver.setY(curY);
        resolver.setX(offsetX);
        int _width = resolversContainer.getWidth();
        int _minus = (_width - (2 * offsetX));
        resolver.setWidth(_minus);
        int curAttributeY = 40;
        EList<ResolverAttribute> _resolverAttributes = resolver.getResolverAttributes();
        for (final ResolverAttribute attribute : _resolverAttributes) {
          {
            attribute.setY(curAttributeY);
            attribute.setX(offsetX);
            int _width_1 = resolver.getWidth();
            int _minus_1 = (_width_1 - (2 * offsetX));
            attribute.setWidth(_minus_1);
            boolean _isEmpty = attribute.getResolverProcesss().isEmpty();
            boolean _not = (!_isEmpty);
            if (_not) {
              final ResolverProcess referencedProcess = attribute.getResolverProcesss().get(0);
              if ((referencedProcess != null)) {
                referencedProcess.setY(40);
                referencedProcess.setX(offsetX);
                int _width_2 = attribute.getWidth();
                int _minus_2 = (_width_2 - (2 * offsetX));
                referencedProcess.setWidth(_minus_2);
                int _height = referencedProcess.getHeight();
                int _plus = (30 + _height);
                int _plus_1 = (_plus + offsetY);
                int _plus_2 = (_plus_1 + offsetBottom);
                attribute.setHeight(_plus_2);
              }
            } else {
              attribute.setHeight(30);
            }
            int _height_1 = attribute.getHeight();
            int _plus_3 = (curAttributeY + _height_1);
            int _plus_4 = (_plus_3 + offsetY);
            curAttributeY = _plus_4;
          }
        }
        boolean _isEmpty = resolver.getResolverAttributes().isEmpty();
        boolean _not = (!_isEmpty);
        if (_not) {
          final Function1<ResolverAttribute, Integer> _function = new Function1<ResolverAttribute, Integer>() {
            @Override
            public Integer apply(final ResolverAttribute it) {
              return Integer.valueOf(it.getHeight());
            }
          };
          final Function2<Integer, Integer, Integer> _function_1 = new Function2<Integer, Integer, Integer>() {
            @Override
            public Integer apply(final Integer p1, final Integer p2) {
              return Integer.valueOf((((p1).intValue() + (p2).intValue()) + offsetY));
            }
          };
          Integer _reduce = IterableExtensions.<Integer>reduce(ListExtensions.<ResolverAttribute, Integer>map(resolver.getResolverAttributes(), _function), _function_1);
          int _plus = (40 + (_reduce).intValue());
          int _plus_1 = (_plus + offsetBottom);
          resolver.setHeight(_plus_1);
        } else {
          resolver.setHeight(30);
        }
        int _height = resolver.getHeight();
        int _plus_2 = (curY + _height);
        int _plus_3 = (_plus_2 + offsetY);
        curY = _plus_3;
      }
    }
    resolversContainer.setHeight((offsetTop + offsetBottom));
    boolean _isEmpty = resolversContainer.getResolvers().isEmpty();
    boolean _not = (!_isEmpty);
    if (_not) {
      int _height = resolversContainer.getHeight();
      final Function1<Resolver, Integer> _function = new Function1<Resolver, Integer>() {
        @Override
        public Integer apply(final Resolver it) {
          return Integer.valueOf(it.getHeight());
        }
      };
      final Function2<Integer, Integer, Integer> _function_1 = new Function2<Integer, Integer, Integer>() {
        @Override
        public Integer apply(final Integer p1, final Integer p2) {
          return Integer.valueOf((((p1).intValue() + (p2).intValue()) + offsetY));
        }
      };
      Integer _reduce = IterableExtensions.<Integer>reduce(ListExtensions.<Resolver, Integer>map(resolversContainer.getResolvers(), _function), _function_1);
      int _plus = (_height + (_reduce).intValue());
      resolversContainer.setHeight(_plus);
    }
  }
}
