/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.graphql.hooks.ResolversLayouter;
import info.scce.dime.graphql.schema.graphql.Resolver;
import info.scce.dime.graphql.schema.graphql.Resolvers;
import org.eclipse.xtext.xbase.lib.Functions.Function1;

@SuppressWarnings("all")
public class ResolverPostCreateHook extends DIMEPostCreateHook<Resolver> {
  @Override
  public void postCreate(final Resolver resolver) {
    final Resolvers container = resolver.getContainer();
    final Function1<Resolver, Boolean> _function = new Function1<Resolver, Boolean>() {
      @Override
      public Boolean apply(final Resolver it) {
        return Boolean.valueOf(((it.getReferencedType().getName() == resolver.getReferencedType().getName()) && 
          (it != resolver)));
      }
    };
    Boolean _any = this._collectionExtension.<Resolver>any(container.getResolvers(), _function);
    if ((_any).booleanValue()) {
      resolver.delete();
    } else {
      new ResolversLayouter().layout(resolver.getRootElement().getResolverss().get(0));
    }
  }
}
