/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.data.data.Attribute;
import info.scce.dime.data.data.ComplexAttribute;
import info.scce.dime.data.data.PrimitiveAttribute;
import info.scce.dime.data.data.PrimitiveType;
import info.scce.dime.data.data.Type;
import info.scce.dime.graphql.hooks.ResolversLayouter;
import info.scce.dime.graphql.schema.graphql.Resolver;
import info.scce.dime.graphql.schema.graphql.ResolverAttribute;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

@SuppressWarnings("all")
public class ResolverAttributePostCreateHook extends DIMEPostCreateHook<ResolverAttribute> {
  @Override
  public void postCreate(final ResolverAttribute attribute) {
    final Resolver resolver = attribute.getContainer();
    final Type dataType = resolver.getReferencedType();
    final Function1<ResolverAttribute, Boolean> _function = new Function1<ResolverAttribute, Boolean>() {
      @Override
      public Boolean apply(final ResolverAttribute it) {
        return Boolean.valueOf((it != attribute));
      }
    };
    final Function1<ResolverAttribute, Boolean> _function_1 = new Function1<ResolverAttribute, Boolean>() {
      @Override
      public Boolean apply(final ResolverAttribute it) {
        return Boolean.valueOf(ResolverAttributePostCreateHook.this.isSameAttribute(it.getReferencedAttribute(), attribute.getReferencedAttribute()));
      }
    };
    Boolean _any = this._collectionExtension.<ResolverAttribute>any(IterableExtensions.<ResolverAttribute>filter(resolver.getResolverAttributes(), _function), _function_1);
    if ((_any).booleanValue()) {
      attribute.delete();
      return;
    }
    final Function1<Attribute, Boolean> _function_2 = new Function1<Attribute, Boolean>() {
      @Override
      public Boolean apply(final Attribute it) {
        return Boolean.valueOf(ResolverAttributePostCreateHook.this.isSameAttribute(it, attribute.getReferencedAttribute()));
      }
    };
    Boolean _any_1 = this._collectionExtension.<Attribute>any(dataType.getAttributes(), _function_2);
    boolean _not = (!(_any_1).booleanValue());
    if (_not) {
      attribute.delete();
      return;
    }
    new ResolversLayouter().layout(attribute.getRootElement().getResolverss().get(0));
  }
  
  public boolean isSameAttribute(final Attribute a, final Attribute b) {
    String _name = a.getName();
    String _name_1 = b.getName();
    boolean _tripleNotEquals = (_name != _name_1);
    if (_tripleNotEquals) {
      return false;
    }
    if (((a.isIsList() && (!b.isIsList())) || ((!a.isIsList()) && b.isIsList()))) {
      return false;
    }
    if ((a instanceof PrimitiveAttribute)) {
      if ((b instanceof PrimitiveAttribute)) {
        PrimitiveType _dataType = ((PrimitiveAttribute)a).getDataType();
        PrimitiveType _dataType_1 = ((PrimitiveAttribute)b).getDataType();
        return (_dataType == _dataType_1);
      }
    }
    if ((a instanceof ComplexAttribute)) {
      if ((b instanceof ComplexAttribute)) {
        String _name_2 = ((ComplexAttribute)a).getDataType().getName();
        String _name_3 = ((ComplexAttribute)b).getDataType().getName();
        return (_name_2 == _name_3);
      }
    }
    return false;
  }
}
