/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import graphmodel.ModelElementContainer;
import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.graphql.api.api.APIinputPort;
import info.scce.dime.graphql.api.api.IO;
import info.scce.dime.graphql.api.api.StartSIB;
import info.scce.dime.process.helper.LayoutConstants;
import info.scce.dime.process.helper.NodeLayout;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class PortPostCreateHook extends DIMEPostCreateHook<IO> {
  @Override
  public void postCreate(final IO port) {
    int x = LayoutConstants.ATTR_X;
    int y = (LayoutConstants.TYPE_FIRST_ATTR_Y + 35);
    final ModelElementContainer container = port.getContainer();
    if ((container instanceof StartSIB)) {
      int _size = ((StartSIB)container).getAPIinputPorts().size();
      int attributeAmount = (_size + 2);
      ((StartSIB)container).resize(((StartSIB)container).getWidth(), NodeLayout.getTypeHeight(attributeAmount));
      EList<APIinputPort> _aPIinputPorts = ((StartSIB)container).getAPIinputPorts();
      for (final APIinputPort input : _aPIinputPorts) {
        {
          input.moveTo(((StartSIB)container), x, y);
          int _y = y;
          y = (_y + LayoutConstants.ATTR_SPACE);
        }
      }
    }
  }
}
