/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.graphql.api.api.Branch;
import info.scce.dime.graphql.api.api.ComplexOutputPort;
import info.scce.dime.graphql.api.api.DataFlowSource;
import info.scce.dime.graphql.api.api.Output;
import info.scce.dime.graphql.api.api.StartSIB;
import info.scce.dime.process.helper.LayoutConstants;
import info.scce.dime.process.helper.NodeLayout;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class OutputPortHook extends DIMEPostCreateHook<ComplexOutputPort> {
  public void layout(final DataFlowSource node) {
    int x = LayoutConstants.ATTR_X;
    int y = (LayoutConstants.TYPE_FIRST_ATTR_Y + 35);
    if ((node instanceof StartSIB)) {
      int _size = node.getOutputs().size();
      int attributeAmountStartSib = (_size + 2);
      node.resize(node.getWidth(), NodeLayout.getTypeHeight(attributeAmountStartSib));
      EList<Output> _outputs = node.getOutputs();
      for (final Output output : _outputs) {
        {
          output.moveTo(node, x, y);
          int _width = node.getWidth();
          int _minus = (_width - (2 * LayoutConstants.ATTR_X));
          output.resize(_minus, output.getHeight());
          int _y = y;
          y = (_y + LayoutConstants.ATTR_SPACE);
        }
      }
    }
    if ((node instanceof Branch)) {
      y = LayoutConstants.TYPE_FIRST_ATTR_Y;
      int _size_1 = ((Branch)node).getOutputs().size();
      int attributeAmountBranch = (_size_1 + 2);
      ((Branch)node).resize(((Branch)node).getWidth(), NodeLayout.getTypeHeight(attributeAmountBranch));
      EList<Output> _outputs_1 = ((Branch)node).getOutputs();
      for (final Output output_1 : _outputs_1) {
        {
          output_1.moveTo(((Branch)node), x, y);
          int _width = ((Branch)node).getWidth();
          int _minus = (_width - (2 * LayoutConstants.ATTR_X));
          output_1.resize(_minus, output_1.getHeight());
          int _y = y;
          y = (_y + LayoutConstants.ATTR_SPACE);
        }
      }
    }
  }
  
  @Override
  public void postCreate(final ComplexOutputPort outPort) {
    this.layout(outPort.getContainer());
  }
}
