/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.graphql.api.api.ComplexInputPort;
import info.scce.dime.graphql.api.api.DataFlowTarget;
import info.scce.dime.graphql.api.api.Input;
import info.scce.dime.graphql.api.api.ProcessSIB;
import info.scce.dime.process.helper.LayoutConstants;
import info.scce.dime.process.helper.NodeLayout;
import org.eclipse.emf.common.util.EList;

@SuppressWarnings("all")
public class InputPortHook extends DIMEPostCreateHook<ComplexInputPort> {
  public void layout(final DataFlowTarget node) {
    int x = LayoutConstants.ATTR_X;
    int y = (LayoutConstants.TYPE_FIRST_ATTR_Y + 35);
    if ((node instanceof ProcessSIB)) {
      int _size = ((ProcessSIB)node).getInputs().size();
      int attributeAmountEndSib = (_size + 2);
      ((ProcessSIB)node).resize(((ProcessSIB)node).getWidth(), NodeLayout.getTypeHeight(attributeAmountEndSib));
      EList<Input> _inputs = ((ProcessSIB)node).getInputs();
      for (final Input input : _inputs) {
        {
          input.moveTo(((ProcessSIB)node), x, y);
          int _width = ((ProcessSIB)node).getWidth();
          int _minus = (_width - (2 * LayoutConstants.ATTR_X));
          input.resize(_minus, input.getHeight());
          int _y = y;
          y = (_y + LayoutConstants.ATTR_SPACE);
        }
      }
    }
  }
  
  @Override
  public void postCreate(final ComplexInputPort inPort) {
    this.layout(inPort.getContainer());
  }
}
