/**
 * -
 * #%L
 * DIME
 * %%
 * Copyright (C) 2021 - 2022 TU Dortmund University - Department of Computer Science - Chair for Programming Systems
 * %%
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License, v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is
 * available at https://www.gnu.org/software/classpath/license.html.
 * 
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 * #L%
 */
package info.scce.dime.graphql.hooks;

import info.scce.dime.api.DIMEPostCreateHook;
import info.scce.dime.graphql.schema.graphql.ForbiddenTypes;
import info.scce.dime.graphql.schema.graphql.GraphQL;
import info.scce.dime.graphql.schema.graphql.Mutations;
import info.scce.dime.graphql.schema.graphql.Queries;
import info.scce.dime.graphql.schema.graphql.Resolvers;

@SuppressWarnings("all")
public class GraphQLInit extends DIMEPostCreateHook<GraphQL> {
  @Override
  public void postCreate(final GraphQL model) {
    final Queries queryContainer = model.newQueries(30, 150);
    final Mutations mutationContainer = model.newMutations(299, 150);
    final ForbiddenTypes forbiddenTypesContainer = model.newForbiddenTypes(568, 150);
    final Resolvers resolversContainer = model.newResolvers(897, 150);
    queryContainer.setWidth(270);
    queryContainer.setHeight(106);
    mutationContainer.setWidth(270);
    mutationContainer.setHeight(106);
    forbiddenTypesContainer.setWidth(330);
    forbiddenTypesContainer.setHeight(106);
    resolversContainer.setWidth(330);
    resolversContainer.setHeight(106);
  }
}
